/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.notification;

import com.google.gson.Gson;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.dao.WebhooksDAO;
import org.wso2.carbon.apimgt.impl.handlers.EventHandler;
import org.wso2.carbon.apimgt.notification.event.WebhooksSubscriptionEvent;
import org.wso2.carbon.apimgt.notification.util.NotificationUtil;
import org.wso2.carbon.databridge.commons.Event;

public class WebhooksSubscriptionEventHandler
implements EventHandler {
    private static final Log log = LogFactory.getLog(WebhooksSubscriptionEventHandler.class);

    public boolean handleEvent(String event, Map<String, List<String>> headers) throws APIManagementException {
        WebhooksSubscriptionEvent subscriptionEvent = (WebhooksSubscriptionEvent)new Gson().fromJson(event, WebhooksSubscriptionEvent.class);
        Properties properties = this.populateProperties(subscriptionEvent);
        boolean isSuccess = true;
        if ("subscribe".equalsIgnoreCase(subscriptionEvent.getMode())) {
            isSuccess = WebhooksDAO.getInstance().addSubscription(properties);
        } else if ("unsubscribe".equalsIgnoreCase(subscriptionEvent.getMode())) {
            WebhooksDAO.getInstance().updateUnSubscription(properties);
        } else {
            throw new APIManagementException("Error while processing subscription request: Wrong subscription mode");
        }
        this.sendSubscriptionNotificationOnRealtime(subscriptionEvent, isSuccess);
        if (!isSuccess) {
            throw new APIManagementException("Throttled out");
        }
        return true;
    }

    private Properties populateProperties(WebhooksSubscriptionEvent subscriptionEvent) throws APIManagementException {
        Properties properties = new Properties();
        properties.put("apiUUID", subscriptionEvent.getApiUUID());
        properties.put("appID", subscriptionEvent.getAppID());
        properties.put("tenantDomain", subscriptionEvent.getTenantDomain());
        properties.put("tenantId", (Object)subscriptionEvent.getTenantId());
        properties.put("callback", subscriptionEvent.getCallback());
        properties.put("topic", subscriptionEvent.getTopic());
        this.putIfNotNull(properties, "secret", subscriptionEvent.getSecret());
        String leaseSeconds = subscriptionEvent.getLeaseSeconds();
        this.putIfNotNull(properties, "leaseSeconds", leaseSeconds);
        Date currentTime = new Date();
        Timestamp updatedTimestamp = new Timestamp(currentTime.getTime());
        subscriptionEvent.setUpdatedTime(updatedTimestamp);
        properties.put("updatedAt", updatedTimestamp);
        long expiryTime = 0L;
        if (!StringUtils.isEmpty((CharSequence)leaseSeconds)) {
            long leaseSecondsInLong;
            try {
                leaseSecondsInLong = Long.parseLong(leaseSeconds);
            }
            catch (NumberFormatException e) {
                throw new APIManagementException("Error while parsing leaseSeconds param", (Throwable)e);
            }
            expiryTime = updatedTimestamp.toInstant().plusSeconds(leaseSecondsInLong).toEpochMilli();
        }
        subscriptionEvent.setExpiryTime(expiryTime);
        properties.put("expireAt", "" + expiryTime);
        properties.put("tier", "" + subscriptionEvent.getTier());
        return properties;
    }

    public String getType() {
        return "subscriptionEventType";
    }

    private void sendSubscriptionNotificationOnRealtime(WebhooksSubscriptionEvent event, boolean isSuccess) {
        Object[] objects = new Object[]{event.getApiUUID(), event.getApiName(), event.getApiContext(), event.getApiVersion(), event.getAppID(), event.getTenantDomain(), event.getTenantId(), event.getCallback(), event.getTopic(), event.getMode(), event.getSecret(), event.getExpiryTime(), event.getSubscriberName(), event.getApplicationTier(), event.getTier(), event.getApiTier(), !isSuccess};
        Event notificationMessage = new Event("org.wso2.apimgt.webhooks.request.stream:1.0.0", System.currentTimeMillis(), null, null, objects);
        NotificationUtil.publishEventToStreamService(notificationMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully sent the webhooks subscription notification on realtime");
        }
    }

    private void putIfNotNull(Properties properties, String name, String value) {
        if (value != null) {
            properties.put(name, value);
        }
    }
}

