/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.notification;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.axis2.util.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.apimgt.impl.token.TokenRevocationNotifier;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.notification.util.NotificationUtil;
import org.wso2.carbon.databridge.commons.Event;

public class TokenRevocationNotifierImpl
implements TokenRevocationNotifier {
    private static final Log log = LogFactory.getLog(TokenRevocationNotifierImpl.class);
    protected static final String DEFAULT_TTL = "3600";
    protected Properties realTimeNotifierProperties;
    protected Properties persistentNotifierProperties;

    public void sendMessageOnRealtime(String revokedToken, Properties properties) {
        String realtimeNotifierTTL = this.realTimeNotifierProperties.getProperty("ttl", DEFAULT_TTL);
        long expiryTimeForJWT = Long.parseLong(properties.getProperty("expiryTime"));
        String eventId = properties.getProperty("eventId");
        String tokenType = properties.getProperty("token_type");
        int tenantId = (Integer)properties.get("tenantId");
        Object[] objects = new Object[]{eventId, revokedToken, realtimeNotifierTTL, expiryTimeForJWT, tokenType, tenantId};
        Event tokenRevocationMessage = new Event("org.wso2.apimgt.token.revocation.stream:1.0.0", System.currentTimeMillis(), null, null, objects);
        NotificationUtil.publishEventToStreamService(tokenRevocationMessage);
        log.debug((Object)"Successfully sent the revoked token notification on realtime");
    }

    public void sendMessageToPersistentStorage(String revokedToken, Properties properties) {
        String defaultPersistentNotifierHostname = "https://localhost:2379/v2/keys/jti/";
        String persistentNotifierHostname = properties.getProperty("hostname", defaultPersistentNotifierHostname);
        String persistentNotifierTTL = properties.getProperty("ttl", DEFAULT_TTL);
        String defaultPersistentNotifierUsername = "root";
        String persistentNotifierUsername = properties.getProperty("username", defaultPersistentNotifierUsername);
        String defaultPersistentNotifierPassword = "root";
        String persistentNotifierPassword = properties.getProperty("password", defaultPersistentNotifierPassword);
        String etcdEndpoint = persistentNotifierHostname + revokedToken;
        URL etcdEndpointURL = new URL(etcdEndpoint);
        String etcdEndpointProtocol = etcdEndpointURL.getProtocol();
        int etcdEndpointPort = etcdEndpointURL.getPort();
        HttpClient etcdEPClient = APIUtil.getHttpClient((int)etcdEndpointPort, (String)etcdEndpointProtocol);
        HttpPut httpETCDPut = new HttpPut(etcdEndpoint);
        byte[] encodedAuth = Base64.encodeBase64((byte[])(persistentNotifierUsername + ":" + persistentNotifierPassword).getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
        httpETCDPut.setHeader("Authorization", authHeader);
        ArrayList<BasicNameValuePair> etcdParams = new ArrayList<BasicNameValuePair>(2);
        etcdParams.add(new BasicNameValuePair("value", "true"));
        etcdParams.add(new BasicNameValuePair("ttl", persistentNotifierTTL));
        httpETCDPut.setEntity((HttpEntity)new UrlEncodedFormEntity(etcdParams, StandardCharsets.UTF_8));
        try {
            HttpResponse etcdResponse = etcdEPClient.execute((HttpUriRequest)httpETCDPut);
            if (etcdResponse.getStatusLine().getStatusCode() == 200 || etcdResponse.getStatusLine().getStatusCode() == 201) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully submitted the request for revoked token. HTTP status :" + etcdResponse.getStatusLine().getStatusCode()));
                }
            } else {
                log.error((Object)("Sending revoked token to persistent storage failed. HTTP error code : " + etcdResponse.getStatusLine().getStatusCode()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while sending revoked token to the persistent storage :", (Throwable)e);
        }
    }

    public void init(Properties realTimeNotifierProperties, Properties persistentNotifierProperties) {
        this.realTimeNotifierProperties = realTimeNotifierProperties;
        this.persistentNotifierProperties = persistentNotifierProperties;
    }
}

