/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.notification;

import java.util.Properties;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.keymgt.KeyManagerEventHandler;
import org.wso2.carbon.apimgt.impl.publishers.RevocationRequestPublisher;
import org.wso2.carbon.apimgt.notification.event.TokenRevocationEvent;

public abstract class AbstractKeyManagerEventHandler
implements KeyManagerEventHandler {
    private RevocationRequestPublisher revocationRequestPublisher = RevocationRequestPublisher.getInstance();

    public boolean handleTokenRevocationEvent(TokenRevocationEvent tokenRevocationEvent) throws APIManagementException {
        Properties properties = new Properties();
        properties.setProperty("eventId", tokenRevocationEvent.getEventId());
        properties.put("consumer_key", tokenRevocationEvent.getConsumerKey());
        properties.put("token_type", tokenRevocationEvent.getTokenType());
        properties.put("tenantId", (Object)tokenRevocationEvent.getTenantId());
        properties.put("tenant_domain", tokenRevocationEvent.getTenantDomain());
        ApiMgtDAO.getInstance().addRevokedJWTSignature(tokenRevocationEvent.getEventId(), tokenRevocationEvent.getAccessToken(), tokenRevocationEvent.getTokenType(), Long.valueOf(tokenRevocationEvent.getExpiryTime()), tokenRevocationEvent.getTenantId());
        this.revocationRequestPublisher.publishRevocationEvents(tokenRevocationEvent.getAccessToken(), tokenRevocationEvent.getExpiryTime(), properties);
        return true;
    }
}

