/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.application.authentication.internal;

import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.core.handler.MessageHandlerComparator;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherProxy;
import org.wso2.carbon.identity.data.publisher.application.authentication.impl.AuthenticationAuditLogger;
import org.wso2.carbon.identity.data.publisher.application.authentication.impl.DASLoginDataPublisherImpl;
import org.wso2.carbon.identity.data.publisher.application.authentication.impl.DASSessionDataPublisherImpl;
import org.wso2.carbon.identity.data.publisher.application.authentication.internal.AuthenticationDataPublisherDataHolder;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.data.publisher.authn", immediate=true)
public class AuthenticationDataPublisherServiceComponent {
    private static final Log log = LogFactory.getLog(AuthenticationDataPublisherServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(AuthenticationDataPublisher.class.getName(), (Object)new DASLoginDataPublisherImpl(), null);
            bundleContext.registerService(AuthenticationDataPublisher.class.getName(), (Object)new DASSessionDataPublisherImpl(), null);
            bundleContext.registerService(AuthenticationDataPublisher.class.getName(), (Object)new AuthenticationAuditLogger(), null);
            bundleContext.registerService(AuthenticationDataPublisher.class.getName(), (Object)new AuthnDataPublisherProxy(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"org.wso2.carbon.identity.data.publisher.application.authentication bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating org.wso2.carbon.identity.data.publisher.application.authentication bundle", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"org.wso2.carbon.identity.data.publisher.application.authentication bundle is deactivated");
        }
    }

    @Reference(name="IdentityEventService", service=IdentityEventService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityEventService")
    protected void setIdentityEventService(IdentityEventService eventService) {
        AuthenticationDataPublisherDataHolder.getInstance().setIdentityEventService(eventService);
    }

    protected void unsetIdentityEventService(IdentityEventService eventService) {
        AuthenticationDataPublisherDataHolder.getInstance().setIdentityEventService(null);
    }

    @Reference(name="EventStreamService", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Event Stream Service");
        }
        AuthenticationDataPublisherDataHolder.getInstance().setPublisherService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Event Stream Service");
        }
        AuthenticationDataPublisherDataHolder.getInstance().setPublisherService(null);
    }

    @Reference(name="RegistryService", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        AuthenticationDataPublisherDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Registry Service.");
        }
        AuthenticationDataPublisherDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="RealmService", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service.");
        }
        AuthenticationDataPublisherDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Realm Service.");
        }
        AuthenticationDataPublisherDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="AuthenticationDataPublisher", service=AuthenticationDataPublisher.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationDataPublisher")
    protected void setAuthenticationDataPublisher(AuthenticationDataPublisher publisher) {
        if (publisher != null && !"AuthnDataPublisherProxy".equalsIgnoreCase(publisher.getName())) {
            AuthenticationDataPublisherDataHolder.getInstance().getDataPublishers().add(publisher);
            Collections.sort(AuthenticationDataPublisherDataHolder.getInstance().getDataPublishers(), new MessageHandlerComparator(null));
            Collections.reverse(AuthenticationDataPublisherDataHolder.getInstance().getDataPublishers());
        }
    }

    protected void unsetAuthenticationDataPublisher(AuthenticationDataPublisher publisher) {
        AuthenticationDataPublisherDataHolder.getInstance().getDataPublishers().remove(publisher);
    }
}

