/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.application.authentication.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.data.publisher.application.authentication.AbstractAuthenticationDataPublisher;
import org.wso2.carbon.identity.data.publisher.application.authentication.model.AuthenticationData;
import org.wso2.carbon.identity.data.publisher.application.authentication.model.SessionData;

@Deprecated
public class AuthenticationAuditLogger
extends AbstractAuthenticationDataPublisher {
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    public static final Log LOG = LogFactory.getLog(AuthenticationAuditLogger.class);

    public String getName() {
        return "AuditDataPublisher";
    }

    public int getPriority(MessageContext messageContext) {
        return 1;
    }

    @Override
    public void doPublishAuthenticationStepSuccess(AuthenticationData authenticationData) {
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextId() + "\",\"AuthenticatedUser\" : \"" + authenticationData.getUsername() + "\",\"AuthenticatedUserTenantDomain\" : \"" + authenticationData.getTenantDomain() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getParameter("relyingParty") + "\",\"AuthenticatedIdP\" : \"" + authenticationData.getIdentityProvider() + "\"";
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getUsername(), "LoginStepSuccess", "ApplicationAuthenticationFramework", auditData, "Success"));
    }

    @Override
    public void doPublishAuthenticationStepFailure(AuthenticationData authenticationData) {
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextId() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getParameter("relyingParty") + "\",\"StepNo\" : \"" + authenticationData.getStepNo() + "\"";
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getUsername(), "Login", "ApplicationAuthenticationFramework", auditData, "Failed"));
    }

    @Override
    public void doPublishAuthenticationSuccess(AuthenticationData authenticationData) {
        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setAuthenticated(true);
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextId() + "\",\"AuthenticatedUser\" : \"" + authenticationData.getParameter("subjectIdentifier") + "\",\"AuthenticatedUserTenantDomain\" : \"" + authenticationData.getTenantDomain() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getParameter("relyingParty") + "\",\"AuthenticatedIdPs\" : \"" + authenticationData.getParameter("authenticatedIDPs") + "\"";
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getParameter("subjectIdentifier"), "Login", "ApplicationAuthenticationFramework", auditData, "Success"));
    }

    @Override
    public void doPublishAuthenticationFailure(AuthenticationData authenticationData) {
        String auditData = "\"ContextIdentifier\" : \"" + authenticationData.getContextId() + "\",\"ServiceProviderName\" : \"" + authenticationData.getServiceProvider() + "\",\"RequestType\" : \"" + authenticationData.getInboundProtocol() + "\",\"RelyingParty\" : \"" + authenticationData.getParameter("relyingParty") + "\",\"StepNo\" : \"" + authenticationData.getStepNo() + "\"";
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", authenticationData.getUsername(), "Login", "ApplicationAuthenticationFramework", auditData, "Failed"));
    }

    @Override
    public void doPublishSessionCreation(SessionData sessionData) {
    }

    @Override
    public void doPublishSessionUpdate(SessionData sessionData) {
    }

    @Override
    public void doPublishSessionTermination(SessionData sessionData) {
    }

    @Override
    public void publishSessionTermination(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> unmodifiableMap) {
        if (context == null) {
            return;
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        AuthenticatedUser authenticatedUser = null;
        String username = "";
        String tenantDomain = "";
        String authenticatedIDPs = "";
        if (sequenceConfig != null && sequenceConfig.getAuthenticatedUser() != null) {
            authenticatedUser = sequenceConfig.getAuthenticatedUser();
            authenticatedIDPs = sequenceConfig.getAuthenticatedIdPs();
        } else {
            Object authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser");
            if (authenticatedUserObj != null) {
                authenticatedUser = (AuthenticatedUser)authenticatedUserObj;
            }
        }
        if (authenticatedUser != null) {
            username = authenticatedUser.getAuthenticatedSubjectIdentifier();
            tenantDomain = authenticatedUser.getTenantDomain();
        }
        String auditData = "\"ContextIdentifier\" : \"" + context.getContextIdentifier() + "\",\"LoggedOutUser\" : \"" + username + "\",\"LoggedOutUserTenantDomain\" : \"" + tenantDomain + "\",\"ServiceProviderName\" : \"" + context.getServiceProviderName() + "\",\"RequestType\" : \"" + context.getRequestType() + "\",\"RelyingParty\" : \"" + context.getRelyingParty() + "\",\"AuthenticatedIdPs\" : \"" + authenticatedIDPs + "\"";
        String idpName = null;
        ExternalIdPConfig externalIdPConfig = context.getExternalIdP();
        if (externalIdPConfig != null) {
            idpName = externalIdPConfig.getName();
        }
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", username, "Logout", idpName, auditData, "Success"));
    }

    @Override
    public boolean isEnabled(MessageContext messageContext) {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)AbstractIdentityMessageHandler.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        if (identityEventListenerConfig == null) {
            return false;
        }
        return Boolean.parseBoolean(identityEventListenerConfig.getEnable());
    }

    @Override
    public boolean canHandle(MessageContext messageContext) {
        return true;
    }
}

