/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.application.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class AuthnDataPublisherUtils {
    public static final Log LOG = LogFactory.getLog(AuthnDataPublisherUtils.class);
    private static final String APPLICATION_DOMAIN = "Application";
    private static final String WORKFLOW_DOMAIN = "Workflow";
    private static final String INTERNAL_EVERYONE_ROLE = "Internal/everyone";

    public static String replaceIfNotAvailable(String name, String value) {
        String defaultValue;
        if (StringUtils.isNotEmpty((String)name) && StringUtils.isEmpty((String)value) && (defaultValue = IdentityUtil.getProperty((String)name)) != null) {
            return defaultValue;
        }
        if (StringUtils.isEmpty((String)value)) {
            return "NOT_AVAILABLE";
        }
        return value;
    }

    public static long getSessionExpirationTime(long createdTime, long updatedTime, String tenantDomain, boolean isRememberMe) {
        if (isRememberMe) {
            long rememberMeTimeout = TimeUnit.SECONDS.toMillis(IdPManagementUtil.getRememberMeTimeout((String)tenantDomain));
            return createdTime + rememberMeTimeout;
        }
        long idleSessionTimeOut = TimeUnit.SECONDS.toMillis(IdPManagementUtil.getIdleSessionTimeOut((String)tenantDomain));
        return idleSessionTimeOut + updatedTime;
    }

    public static String hashString(String value) throws NoSuchAlgorithmException {
        MessageDigest dgst = MessageDigest.getInstance("SHA-256");
        byte[] byteValue = dgst.digest(value.getBytes());
        value = Base64.encode((byte[])byteValue);
        return value;
    }

    public static Object[] getMetaDataArray(String tenantDomain) {
        Object[] metaData = new Object[]{StringUtils.isBlank((String)tenantDomain) ? Integer.valueOf(-1234) : Integer.valueOf(IdentityTenantUtil.getTenantId((String)tenantDomain))};
        return metaData;
    }

    public static String[] getTenantDomains(String spTenantDomain, String userTenantDomain) {
        if (StringUtils.isBlank((String)userTenantDomain) || userTenantDomain.equalsIgnoreCase("NOT_AVAILABLE")) {
            return new String[]{spTenantDomain};
        }
        if (StringUtils.isBlank((String)spTenantDomain) || userTenantDomain.equalsIgnoreCase("NOT_AVAILABLE")) {
            return new String[]{userTenantDomain};
        }
        if (spTenantDomain.equalsIgnoreCase(userTenantDomain)) {
            return new String[]{userTenantDomain};
        }
        return new String[]{userTenantDomain, spTenantDomain};
    }

    public static List<String> filterRoles(String[] roleList) {
        ArrayList<String> externalRoles = new ArrayList<String>();
        if (roleList != null) {
            for (String role : roleList) {
                String domain;
                int index;
                if (!StringUtils.isNotBlank((String)role) || (index = role.indexOf(CarbonConstants.DOMAIN_SEPARATOR)) > 0 && ("Internal".equalsIgnoreCase(domain = role.substring(0, index)) && INTERNAL_EVERYONE_ROLE.equalsIgnoreCase(role.trim()) || APPLICATION_DOMAIN.equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain))) continue;
                externalRoles.add(UserCoreUtil.removeDomainFromName((String)role));
            }
        }
        return externalRoles;
    }

    public static String getSubjectStepIDP(AuthenticationContext context) {
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        for (Map.Entry entry : sequenceConfig.getStepMap().entrySet()) {
            StepConfig stepConfig = (StepConfig)entry.getValue();
            if (!stepConfig.isSubjectIdentifierStep() || !StringUtils.isNotEmpty((String)stepConfig.getAuthenticatedIdP())) continue;
            return stepConfig.getAuthenticatedIdP();
        }
        return "NOT_AVAILABLE";
    }
}

