/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.application.authentication;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStatus;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.data.publisher.application.authentication.internal.AuthenticationDataPublisherDataHolder;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;

public class AuthnDataPublisherProxy
extends AbstractIdentityMessageHandler
implements AuthenticationDataPublisher {
    private static final Log log = LogFactory.getLog(AuthnDataPublisherProxy.class);
    private List<AuthenticationDataPublisher> dataPublishers = AuthenticationDataPublisherDataHolder.getInstance().getDataPublishers();

    public void publishAuthenticationStepSuccess(HttpServletRequest request, AuthenticationContext context, Map<String, Object> params) {
        Event event = this.createEvent(request, context, null, params, IdentityEventConstants.EventName.AUTHENTICATION_STEP_SUCCESS);
        event.addEventProperty("authenticationStatus", (Object)AuthenticatorStatus.PASS);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishAuthenticationStepSuccess(request, context, params);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    protected boolean isPublisherEnabledAndCanHandle(AuthenticationContext context, AuthenticationDataPublisher publisher) {
        return publisher != null && publisher.isEnabled((MessageContext)context) && publisher.canHandle((MessageContext)context);
    }

    public void publishAuthenticationStepFailure(HttpServletRequest request, AuthenticationContext context, Map<String, Object> unmodifiableMap) {
        Event event = this.createEvent(request, context, null, unmodifiableMap, IdentityEventConstants.EventName.AUTHENTICATION_STEP_FAILURE);
        event.addEventProperty("authenticationStatus", (Object)AuthenticatorStatus.FAIL);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishAuthenticationStepFailure(request, context, unmodifiableMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    public void publishAuthenticationSuccess(HttpServletRequest request, AuthenticationContext context, Map<String, Object> unmodifiableMap) {
        Event event = this.createEvent(request, context, null, unmodifiableMap, IdentityEventConstants.EventName.AUTHENTICATION_SUCCESS);
        event.addEventProperty("authenticationStatus", (Object)AuthenticatorStatus.PASS);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishAuthenticationSuccess(request, context, unmodifiableMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    public void publishAuthenticationFailure(HttpServletRequest request, AuthenticationContext context, Map<String, Object> unmodifiableMap) {
        Event event = this.createEvent(request, context, null, unmodifiableMap, IdentityEventConstants.EventName.AUTHENTICATION_FAILURE);
        event.addEventProperty("authenticationStatus", (Object)AuthenticatorStatus.FAIL);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishAuthenticationFailure(request, context, unmodifiableMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    public void publishSessionCreation(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> unmodifiableMap) {
        Event event = this.createEvent(request, context, sessionContext, unmodifiableMap, IdentityEventConstants.EventName.SESSION_CREATE);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishSessionCreation(request, context, sessionContext, unmodifiableMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    public void publishSessionUpdate(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> unmodifiableMap) {
        Event event = this.createEvent(request, context, sessionContext, unmodifiableMap, IdentityEventConstants.EventName.SESSION_UPDATE);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishSessionUpdate(request, context, sessionContext, unmodifiableMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    public void publishSessionTermination(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> unmodifiableMap) {
        Event event = this.createEvent(request, context, sessionContext, unmodifiableMap, IdentityEventConstants.EventName.SESSION_TERMINATE);
        this.doPublishEvent(event);
        for (AuthenticationDataPublisher publisher : this.dataPublishers) {
            if (!this.isPublisherEnabledAndCanHandle(context, publisher)) continue;
            publisher.publishSessionTermination(request, context, sessionContext, unmodifiableMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(publisher.getName() + " is invoked."));
        }
    }

    public String getName() {
        return "AuthnDataPublisherProxy";
    }

    private Event createEvent(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> params, IdentityEventConstants.EventName eventName) {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("request", request);
        eventProperties.put("context", context);
        if (sessionContext != null) {
            eventProperties.put("sessionContext", sessionContext);
        }
        eventProperties.put("params", params);
        Event event = new Event(eventName.name(), eventProperties);
        return event;
    }

    private void doPublishEvent(Event event) {
        try {
            AuthenticationDataPublisherDataHolder.getInstance().getIdentityEventService().handleEvent(event);
        }
        catch (IdentityEventException e) {
            log.error((Object)("Error while publishing the event: " + event.getEventName() + "."), (Throwable)e);
        }
    }
}

