/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.application.authentication;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.application.authentication.model.AuthenticationData;
import org.wso2.carbon.identity.data.publisher.application.authentication.model.SessionData;

@Deprecated
public abstract class AbstractAuthenticationDataPublisher
extends AbstractIdentityMessageHandler
implements AuthenticationDataPublisher {
    private static final Log log = LogFactory.getLog(AbstractAuthenticationDataPublisher.class);

    public void publishAuthenticationStepSuccess(HttpServletRequest request, AuthenticationContext context, Map<String, Object> params) {
        Object isFederatedObj;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing authentication step success");
        }
        AuthenticationData<String, Object> authenticationData = new AuthenticationData<String, Object>();
        int step = context.getCurrentStep();
        if (context.getExternalIdP() == null) {
            authenticationData.setIdentityProvider("LOCAL");
        } else {
            authenticationData.setIdentityProvider(context.getExternalIdP().getIdPName());
        }
        Object userObj = params.get("user");
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            authenticationData.setTenantDomain(user.getTenantDomain());
            authenticationData.setUserStoreDomain(user.getUserStoreDomain());
            if (StringUtils.isNotBlank((String)user.getUserName())) {
                authenticationData.setUsername(user.getUserName());
            } else {
                authenticationData.setUsername(user.getAuthenticatedSubjectIdentifier());
            }
        }
        if ((isFederatedObj = params.get("isFederated")) != null) {
            boolean isFederated = (Boolean)isFederatedObj;
            if (isFederated) {
                authenticationData.setIdentityProviderType("FEDERATED");
            } else {
                authenticationData.setIdentityProviderType("LOCAL");
                authenticationData.setLocalUsername(authenticationData.getUsername());
            }
        }
        authenticationData.setContextId(context.getContextIdentifier());
        authenticationData.setEventId(UUID.randomUUID().toString());
        authenticationData.setEventType("step");
        authenticationData.setAuthnSuccess(false);
        if (request != null) {
            authenticationData.setRemoteIp(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        } else {
            authenticationData.setRemoteIp((String)params.get("remote-ip-address"));
        }
        authenticationData.setServiceProvider(context.getServiceProviderName());
        authenticationData.setInboundProtocol(context.getRequestType());
        authenticationData.setRememberMe(context.isRememberMe());
        authenticationData.setForcedAuthn(context.isForceAuthenticate());
        authenticationData.setPassive(context.isPassiveAuthenticate());
        authenticationData.setInitialLogin(false);
        String authenticator = AuthnDataPublisherUtils.replaceIfNotAvailable("ISAnalytics.DefaultValues.authenticatorName", (String)params.get("authenticator"));
        authenticationData.setAuthenticator(authenticator);
        authenticationData.setSuccess(true);
        authenticationData.setStepNo(step);
        authenticationData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), authenticationData.getTenantDomain()));
        authenticationData.addParameter("relyingParty", context.getRelyingParty());
        this.doPublishAuthenticationStepSuccess(authenticationData);
    }

    public void publishAuthenticationStepFailure(HttpServletRequest request, AuthenticationContext context, Map<String, Object> params) {
        User user;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing authentication step failure");
        }
        AuthenticationData<String, Object> authenticationData = new AuthenticationData<String, Object>();
        int step = context.getCurrentStep();
        if (context.getExternalIdP() == null) {
            authenticationData.setIdentityProvider("LOCAL");
        } else {
            authenticationData.setIdentityProvider(context.getExternalIdP().getIdPName());
        }
        Object userObj = params.get("user");
        if (userObj != null && userObj instanceof User) {
            user = (User)userObj;
            authenticationData.setTenantDomain(user.getTenantDomain());
            authenticationData.setUserStoreDomain(user.getUserStoreDomain());
            authenticationData.setUsername(user.getUserName());
        } else if (userObj != null && userObj instanceof AuthenticatedUser) {
            user = (AuthenticatedUser)userObj;
            authenticationData.setTenantDomain(user.getTenantDomain());
            authenticationData.setUserStoreDomain(user.getUserStoreDomain());
            if (StringUtils.isNotEmpty((String)user.getUserName())) {
                authenticationData.setUsername(user.getUserName());
            } else {
                authenticationData.setUsername(user.getAuthenticatedSubjectIdentifier());
            }
        }
        Object isFederatedObj = params.get("isFederated");
        if (isFederatedObj != null) {
            boolean isFederated = (Boolean)isFederatedObj;
            if (isFederated) {
                authenticationData.setIdentityProviderType("FEDERATED");
            } else {
                authenticationData.setIdentityProviderType("LOCAL");
                authenticationData.setLocalUsername(authenticationData.getUsername());
            }
        }
        authenticationData.setContextId(context.getContextIdentifier());
        authenticationData.setEventId(UUID.randomUUID().toString());
        authenticationData.setEventType("step");
        authenticationData.setAuthnSuccess(false);
        if (request != null) {
            authenticationData.setRemoteIp(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        } else {
            authenticationData.setRemoteIp((String)params.get("remote-ip-address"));
        }
        authenticationData.setServiceProvider(context.getServiceProviderName());
        authenticationData.setInboundProtocol(context.getRequestType());
        authenticationData.setRememberMe(context.isRememberMe());
        authenticationData.setForcedAuthn(context.isForceAuthenticate());
        authenticationData.setPassive(context.isPassiveAuthenticate());
        authenticationData.setInitialLogin(false);
        String authenticator = AuthnDataPublisherUtils.replaceIfNotAvailable("ISAnalytics.DefaultValues.authenticatorName", (String)params.get("authenticator"));
        authenticationData.setAuthenticator(authenticator);
        authenticationData.setSuccess(false);
        authenticationData.setStepNo(step);
        if (context.getSequenceConfig() != null && context.getSequenceConfig().getApplicationConfig() != null && context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
            authenticationData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), authenticationData.getTenantDomain()));
        } else {
            authenticationData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), null));
        }
        authenticationData.addParameter("relyingParty", context.getRelyingParty());
        this.doPublishAuthenticationStepFailure(authenticationData);
    }

    public void publishAuthenticationSuccess(HttpServletRequest request, AuthenticationContext context, Map<String, Object> params) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing authentication success");
        }
        AuthenticationData authenticationData = new AuthenticationData();
        Object userObj = params.get("user");
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            authenticationData.setUsername(user.getUserName());
        }
        Object hasFederatedStepObj = context.getProperty("hasFederatedStep");
        Object hasLocalStepObj = context.getProperty("hasLocalStep");
        Object isInitialLoginObj = context.getProperty("isInitialLogin");
        boolean hasFederated = false;
        boolean hasLocal = false;
        boolean isInitialLogin = false;
        boolean hasPreviousLocalStep = this.hasPreviousLocalEvent(context);
        if (hasFederatedStepObj != null) {
            hasFederated = (Boolean)hasFederatedStepObj;
        }
        if (isInitialLoginObj != null) {
            isInitialLogin = (Boolean)isInitialLoginObj;
        }
        if (hasLocalStepObj != null) {
            hasLocal = (Boolean)hasLocalStepObj;
        }
        if (!hasPreviousLocalStep && hasFederated && hasLocal) {
            authenticationData.setIdentityProviderType("FEDERATED,LOCAL");
            authenticationData.setStepNo(this.getLocalStepNo(context));
        } else if (!hasPreviousLocalStep && hasLocal) {
            authenticationData.setIdentityProviderType("LOCAL");
            authenticationData.setStepNo(this.getLocalStepNo(context));
        } else if (hasFederated) {
            authenticationData.setIdentityProviderType("FEDERATED");
        }
        authenticationData.setIdentityProvider(AuthnDataPublisherUtils.getSubjectStepIDP(context));
        authenticationData.setEventType("overall");
        authenticationData.setSuccess(true);
        authenticationData.setContextId(context.getContextIdentifier());
        authenticationData.setEventId(UUID.randomUUID().toString());
        authenticationData.setAuthnSuccess(true);
        if (request != null) {
            authenticationData.setRemoteIp(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        } else {
            authenticationData.setRemoteIp((String)params.get("remote-ip-address"));
        }
        authenticationData.setServiceProvider(context.getServiceProviderName());
        authenticationData.setInboundProtocol(context.getRequestType());
        authenticationData.setRememberMe(context.isRememberMe());
        authenticationData.setForcedAuthn(context.isForceAuthenticate());
        authenticationData.setPassive(context.isPassiveAuthenticate());
        authenticationData.setInitialLogin(isInitialLogin);
        authenticationData = this.fillLocalEvent(authenticationData, context);
        authenticationData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), authenticationData.getTenantDomain()));
        authenticationData.addParameter("subjectIdentifier", context.getSequenceConfig().getAuthenticatedUser().getAuthenticatedSubjectIdentifier());
        authenticationData.addParameter("relyingParty", context.getRelyingParty());
        authenticationData.addParameter("authenticatedIDPs", context.getSequenceConfig().getAuthenticatedIdPs());
        this.doPublishAuthenticationSuccess(authenticationData);
    }

    public void publishAuthenticationFailure(HttpServletRequest request, AuthenticationContext context, Map<String, Object> params) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing authentication failure");
        }
        AuthenticationData<String, Object> authenticationData = new AuthenticationData<String, Object>();
        Object userObj = params.get("user");
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            authenticationData.setTenantDomain(user.getTenantDomain());
            authenticationData.setUserStoreDomain(user.getUserStoreDomain());
            authenticationData.setUsername(user.getUserName());
        }
        authenticationData.setContextId(context.getContextIdentifier());
        authenticationData.setEventId(UUID.randomUUID().toString());
        authenticationData.setEventType("overall");
        authenticationData.setAuthnSuccess(false);
        if (request != null) {
            authenticationData.setRemoteIp(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        } else {
            authenticationData.setRemoteIp((String)params.get("remote-ip-address"));
        }
        authenticationData.setServiceProvider(context.getServiceProviderName());
        authenticationData.setInboundProtocol(context.getRequestType());
        authenticationData.setRememberMe(context.isRememberMe());
        authenticationData.setForcedAuthn(context.isForceAuthenticate());
        authenticationData.setPassive(context.isPassiveAuthenticate());
        authenticationData.setInitialLogin(false);
        if (context.getSequenceConfig() != null && context.getSequenceConfig().getApplicationConfig() != null && context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
            authenticationData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), authenticationData.getTenantDomain()));
        } else {
            authenticationData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), null));
        }
        authenticationData.addParameter("relyingParty", context.getRelyingParty());
        this.doPublishAuthenticationFailure(authenticationData);
    }

    public void publishSessionCreation(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> params) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing session creation");
        }
        SessionData<String, String[]> sessionData = new SessionData<String, String[]>();
        Object userObj = params.get("user");
        String sessionId = (String)params.get("sessionId");
        String userName = null;
        String userStoreDomain = null;
        String tenantDomain = null;
        Long terminationTime = null;
        Long createdTime = null;
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            userName = user.getUserName();
            userStoreDomain = user.getUserStoreDomain();
            tenantDomain = user.getTenantDomain();
        }
        if (sessionContext != null) {
            Object createdTimeObj = sessionContext.getProperty("CreatedTimestamp");
            createdTime = (Long)createdTimeObj;
            terminationTime = AuthnDataPublisherUtils.getSessionExpirationTime(createdTime, createdTime, context.getTenantDomain(), sessionContext.isRememberMe());
            sessionData.setIsRememberMe(sessionContext.isRememberMe());
        }
        sessionData.setUser(userName);
        sessionData.setUserStoreDomain(userStoreDomain);
        sessionData.setTenantDomain(tenantDomain);
        sessionData.setSessionId(sessionId);
        sessionData.setCreatedTimestamp(createdTime);
        sessionData.setUpdatedTimestamp(createdTime);
        sessionData.setTerminationTimestamp(terminationTime);
        sessionData.setIdentityProviders(this.getCommaSeparatedIDPs(sessionContext));
        sessionData.setServiceProvider(context.getServiceProviderName());
        sessionData.setRemoteIP(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        sessionData.setUserAgent(request.getHeader("User-Agent"));
        if (context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
            sessionData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), sessionData.getTenantDomain()));
        } else {
            sessionData.addParameter("tenantId", new String[]{sessionData.getTenantDomain()});
        }
        if (params.containsKey("activeSessionCount")) {
            int activeSessionCount = (Integer)params.get("activeSessionCount");
            sessionData.setActiveSessionCount(activeSessionCount);
        }
        this.doPublishSessionCreation(sessionData);
    }

    public void publishSessionUpdate(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> params) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing session update");
        }
        SessionData<String, String[]> sessionData = new SessionData<String, String[]>();
        Object userObj = params.get("user");
        String sessionId = (String)params.get("sessionId");
        String userName = null;
        String userStoreDomain = null;
        String tenantDomain = null;
        Long terminationTime = null;
        Long createdTime = null;
        Long currentTime = System.currentTimeMillis();
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            userName = user.getUserName();
            userStoreDomain = user.getUserStoreDomain();
            tenantDomain = user.getTenantDomain();
        }
        if (sessionContext != null) {
            Object createdTimeObj = sessionContext.getProperty("CreatedTimestamp");
            createdTime = (Long)createdTimeObj;
            terminationTime = AuthnDataPublisherUtils.getSessionExpirationTime(createdTime, currentTime, context.getTenantDomain(), sessionContext.isRememberMe());
            sessionData.setIsRememberMe(sessionContext.isRememberMe());
        }
        sessionData.setUser(userName);
        sessionData.setIdentityProviders(this.getCommaSeparatedIDPs(sessionContext));
        sessionData.setServiceProvider(context.getServiceProviderName());
        sessionData.setUserStoreDomain(userStoreDomain);
        sessionData.setTenantDomain(tenantDomain);
        sessionData.setSessionId(sessionId);
        sessionData.setCreatedTimestamp(createdTime);
        sessionData.setUpdatedTimestamp(currentTime);
        sessionData.setTerminationTimestamp(terminationTime);
        sessionData.setRemoteIP(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        if (context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
            sessionData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), sessionData.getTenantDomain()));
        } else {
            sessionData.addParameter("tenantId", new String[]{sessionData.getTenantDomain()});
        }
        if (params.containsKey("activeSessionCount")) {
            int activeSessionCount = (Integer)params.get("activeSessionCount");
            sessionData.setActiveSessionCount(activeSessionCount);
        }
        this.doPublishSessionUpdate(sessionData);
    }

    public void publishSessionTermination(HttpServletRequest request, AuthenticationContext context, SessionContext sessionContext, Map<String, Object> params) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing session termination");
        }
        SessionData<String, String[]> sessionData = new SessionData<String, String[]>();
        Object userObj = params.get("user");
        String sessionId = (String)params.get("sessionId");
        String userName = null;
        String userStoreDomain = null;
        String tenantDomain = null;
        Long createdTime = null;
        Long currentTime = System.currentTimeMillis();
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            userName = user.getUserName();
            userStoreDomain = user.getUserStoreDomain();
            tenantDomain = user.getTenantDomain();
        }
        if (sessionContext != null) {
            Object createdTimeObj = sessionContext.getProperty("CreatedTimestamp");
            createdTime = (Long)createdTimeObj;
            sessionData.setIsRememberMe(sessionContext.isRememberMe());
        }
        sessionData.setUser(userName);
        sessionData.setUserStoreDomain(userStoreDomain);
        sessionData.setTenantDomain(tenantDomain);
        sessionData.setSessionId(sessionId);
        sessionData.setCreatedTimestamp(createdTime);
        sessionData.setUpdatedTimestamp(currentTime);
        sessionData.setIdentityProviders(this.getCommaSeparatedIDPs(sessionContext));
        sessionData.setTerminationTimestamp(currentTime);
        if (context != null) {
            sessionData.setServiceProvider(context.getServiceProviderName());
            sessionData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains(context.getTenantDomain(), sessionData.getTenantDomain()));
        } else {
            sessionData.addParameter("tenantId", new String[]{sessionData.getTenantDomain()});
        }
        if (request != null) {
            sessionData.setRemoteIP(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        }
        if (params.containsKey("activeSessionCount")) {
            int activeSessionCount = (Integer)params.get("activeSessionCount");
            sessionData.setActiveSessionCount(activeSessionCount);
        }
        this.doPublishSessionTermination(sessionData);
    }

    protected String getCommaSeparatedIDPs(SessionContext sessionContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving current IDPw for user ");
        }
        if (sessionContext == null || sessionContext.getAuthenticatedIdPs() == null || sessionContext.getAuthenticatedIdPs().isEmpty()) {
            return "";
        }
        Iterator iterator = sessionContext.getAuthenticatedIdPs().entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry pair = iterator.next();
            sb.append(",").append(pair.getKey());
        }
        if (sb.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning roles, " + sb.substring(1)));
            }
            return sb.substring(1);
        }
        return "";
    }

    protected AuthenticationData fillLocalEvent(AuthenticationData authenticationData, AuthenticationContext context) {
        AuthenticatedIdPData localIDPData = null;
        Map previousAuthenticatedIDPs = context.getPreviousAuthenticatedIdPs();
        Map currentAuthenticatedIDPs = context.getCurrentAuthenticatedIdPs();
        if (currentAuthenticatedIDPs != null && currentAuthenticatedIDPs.size() > 0) {
            localIDPData = (AuthenticatedIdPData)currentAuthenticatedIDPs.get("LOCAL");
        }
        if (localIDPData == null && previousAuthenticatedIDPs != null && previousAuthenticatedIDPs.size() > 0) {
            localIDPData = (AuthenticatedIdPData)previousAuthenticatedIDPs.get("LOCAL");
        }
        if (localIDPData != null) {
            authenticationData.setLocalUsername(localIDPData.getUser().getAuthenticatedSubjectIdentifier());
            authenticationData.setUserStoreDomain(localIDPData.getUser().getUserStoreDomain());
            authenticationData.setTenantDomain(localIDPData.getUser().getTenantDomain());
            authenticationData.setAuthenticator(localIDPData.getAuthenticator().getName());
        }
        return authenticationData;
    }

    protected int getLocalStepNo(AuthenticationContext context) {
        int stepNo = 0;
        Map map = context.getSequenceConfig().getStepMap();
        for (Map.Entry entry : map.entrySet()) {
            StepConfig stepConfig = (StepConfig)entry.getValue();
            if (stepConfig == null || !"LOCAL".equalsIgnoreCase(stepConfig.getAuthenticatedIdP())) continue;
            stepNo = (Integer)entry.getKey();
            return stepNo;
        }
        return stepNo;
    }

    public boolean hasPreviousLocalEvent(AuthenticationContext context) {
        Map previousAuthenticatedIDPs = context.getPreviousAuthenticatedIdPs();
        return previousAuthenticatedIDPs.get("LOCAL") != null;
    }

    public abstract void doPublishAuthenticationStepSuccess(AuthenticationData var1);

    public abstract void doPublishAuthenticationStepFailure(AuthenticationData var1);

    public abstract void doPublishAuthenticationSuccess(AuthenticationData var1);

    public abstract void doPublishAuthenticationFailure(AuthenticationData var1);

    public abstract void doPublishSessionCreation(SessionData var1);

    public abstract void doPublishSessionUpdate(SessionData var1);

    public abstract void doPublishSessionTermination(SessionData var1);

    public boolean canHandle(MessageContext messageContext) {
        return true;
    }

    public boolean isEnabled(MessageContext messageContext) {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)AbstractIdentityMessageHandler.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        if (identityEventListenerConfig == null) {
            return false;
        }
        return Boolean.parseBoolean(identityEventListenerConfig.getEnable());
    }
}

