/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.http.HTTPEventAdapter;

public class HTTPEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.http.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "http";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("text");
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticPropertyList = new ArrayList<Property>();
        Property proxyHostProp = new Property("http.proxy.host");
        proxyHostProp.setDisplayName(this.resourceBundle.getString("http.proxy.host"));
        proxyHostProp.setHint(this.resourceBundle.getString("http.proxy.host.hint"));
        proxyHostProp.setRequired(false);
        Property proxyPortProp = new Property("http.proxy.port");
        proxyPortProp.setDisplayName(this.resourceBundle.getString("http.proxy.port"));
        proxyPortProp.setHint(this.resourceBundle.getString("http.proxy.port.hint"));
        proxyPortProp.setRequired(false);
        Property clientMethod = new Property("http.client.method");
        clientMethod.setDisplayName(this.resourceBundle.getString("http.client.method"));
        clientMethod.setRequired(true);
        clientMethod.setOptions(new String[]{"HttpPost", "HttpPut"});
        clientMethod.setDefaultValue("HttpPost");
        staticPropertyList.add(proxyHostProp);
        staticPropertyList.add(proxyPortProp);
        staticPropertyList.add(clientMethod);
        return staticPropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> dynamicPropertyList = new ArrayList<Property>();
        Property urlProp = new Property("http.url");
        urlProp.setDisplayName(this.resourceBundle.getString("http.url"));
        urlProp.setHint(this.resourceBundle.getString("http.url.hint"));
        urlProp.setRequired(true);
        Property usernameProp = new Property("http.username");
        usernameProp.setDisplayName(this.resourceBundle.getString("http.username"));
        usernameProp.setHint(this.resourceBundle.getString("http.username.hint"));
        usernameProp.setRequired(false);
        Property passwordProp = new Property("http.password");
        passwordProp.setDisplayName(this.resourceBundle.getString("http.password"));
        passwordProp.setHint(this.resourceBundle.getString("http.password.hint"));
        passwordProp.setRequired(false);
        passwordProp.setSecured(true);
        passwordProp.setEncrypted(true);
        Property headersProp = new Property("http.headers");
        headersProp.setDisplayName(this.resourceBundle.getString("http.headers"));
        headersProp.setHint(this.resourceBundle.getString("http.headers.hint"));
        headersProp.setRequired(false);
        dynamicPropertyList.add(urlProp);
        dynamicPropertyList.add(usernameProp);
        dynamicPropertyList.add(passwordProp);
        dynamicPropertyList.add(headersProp);
        return dynamicPropertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new HTTPEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

