/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.http;

import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public class HTTPEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(OutputEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private static ExecutorService executorService;
    private String clientMethod;
    private String proxyHost = null;
    private String proxyPort = null;
    private int tenantId;
    private String contentType;
    private static HttpConnectionManager connectionManager;
    private HttpClient httpClient = null;
    private HostConfiguration hostConfiguration = null;

    public HTTPEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.clientMethod = (String)eventAdapterConfiguration.getStaticProperties().get("http.client.method");
        if (eventAdapterConfiguration.getStaticProperties().get("http.proxy.host") != null && eventAdapterConfiguration.getStaticProperties().get("http.proxy.port") != null) {
            this.proxyPort = (String)eventAdapterConfiguration.getStaticProperties().get("http.proxy.port");
            this.proxyHost = (String)eventAdapterConfiguration.getStaticProperties().get("http.proxy.host");
        }
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
            int defaultMaxConnectionsPerHost = this.globalProperties.get("defaultMaxConnectionsPerHost") != null ? Integer.parseInt(this.globalProperties.get("defaultMaxConnectionsPerHost")) : 2;
            int maxTotalConnections = this.globalProperties.get("maxTotalConnections") != null ? Integer.parseInt(this.globalProperties.get("maxTotalConnections")) : 20;
            connectionManager = new MultiThreadedHttpConnectionManager();
            connectionManager.getParams().setDefaultMaxConnectionsPerHost(defaultMaxConnectionsPerHost);
            connectionManager.getParams().setMaxTotalConnections(maxTotalConnections);
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
        this.checkHTTPClientInit(this.eventAdapterConfiguration.getStaticProperties());
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String url = dynamicProperties.get("http.url");
        String username = dynamicProperties.get("http.username");
        String password = dynamicProperties.get("http.password");
        Map<String, String> headers = this.extractHeaders(dynamicProperties.get("http.headers"));
        String payload = message.toString();
        try {
            executorService.submit(new HTTPSender(url, payload, username, password, headers, this.httpClient));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHTTPClientInit(Map<String, String> staticProperties) {
        if (this.httpClient != null) {
            return;
        }
        Class<HTTPEventAdapter> clazz = HTTPEventAdapter.class;
        synchronized (HTTPEventAdapter.class) {
            String messageFormat;
            if (this.httpClient != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.httpClient = new HttpClient(connectionManager);
            String proxyHost = staticProperties.get("http.proxy.host");
            String proxyPort = staticProperties.get("http.proxy.port");
            if (proxyHost != null && proxyHost.trim().length() > 0) {
                try {
                    HttpHost host = new HttpHost(proxyHost, Integer.parseInt(proxyPort));
                    this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)host);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid proxy port: " + proxyPort + ", ignoring proxy settings for HTTP output event adaptor..."));
                }
            }
            this.contentType = (messageFormat = this.eventAdapterConfiguration.getMessageFormat()).equalsIgnoreCase("json") ? "application/json" : (messageFormat.equalsIgnoreCase("text") ? "text/plain" : "text/xml");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private Map<String, String> extractHeaders(String headers) {
        if (headers == null || headers.trim().length() == 0) {
            return null;
        }
        String[] entries = headers.split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String header : entries) {
            try {
                String[] keyValue = header.split(":", 2);
                result.put(keyValue[0].trim(), keyValue[1].trim());
            }
            catch (Exception e) {
                log.warn((Object)("Header property '" + header + "' is not defined in the correct format."), (Throwable)e);
            }
        }
        return result;
    }

    class HTTPSender
    implements Runnable {
        private String url;
        private String payload;
        private String username;
        private String password;
        private Map<String, String> headers;
        private HttpClient httpClient;

        public HTTPSender(String url, String payload, String username, String password, Map<String, String> headers, HttpClient httpClient) {
            this.url = url;
            this.payload = payload;
            this.username = username;
            this.password = password;
            this.headers = headers;
            this.httpClient = httpClient;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPayload() {
            return this.payload;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object method = null;
            try {
                method = HTTPEventAdapter.this.clientMethod.equalsIgnoreCase("HttpPut") ? new PutMethod(this.getUrl()) : new PostMethod(this.getUrl());
                if (HTTPEventAdapter.this.hostConfiguration == null) {
                    URL hostUrl = new URL(this.getUrl());
                    HTTPEventAdapter.this.hostConfiguration = new HostConfiguration();
                    HTTPEventAdapter.this.hostConfiguration.setHost(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
                    if (StringUtils.isNotBlank((String)HTTPEventAdapter.this.proxyHost) && StringUtils.isNotBlank((String)HTTPEventAdapter.this.proxyPort)) {
                        HTTPEventAdapter.this.hostConfiguration.setProxy(HTTPEventAdapter.this.proxyHost, Integer.parseInt(HTTPEventAdapter.this.proxyPort));
                    }
                }
                method.setRequestEntity((RequestEntity)new StringRequestEntity(this.getPayload(), HTTPEventAdapter.this.contentType, "UTF-8"));
                if (this.getUsername() != null && this.getUsername().trim().length() > 0) {
                    method.setRequestHeader("Authorization", "Basic " + Base64.encode((byte[])(this.getUsername() + ":" + this.getPassword()).getBytes()));
                }
                if (this.getHeaders() != null) {
                    for (Map.Entry entry : this.getHeaders().entrySet()) {
                        method.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                this.getHttpClient().executeMethod(HTTPEventAdapter.this.hostConfiguration, (HttpMethod)method);
            }
            catch (UnknownHostException e) {
                EventAdapterUtil.logAndDrop((String)HTTPEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.getPayload(), (String)("Cannot connect to " + this.getUrl()), (Throwable)e, (Log)log, (int)HTTPEventAdapter.this.tenantId);
            }
            catch (Throwable e) {
                EventAdapterUtil.logAndDrop((String)HTTPEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.getPayload(), null, (Throwable)e, (Log)log, (int)HTTPEventAdapter.this.tenantId);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }
}

