/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.endpoint.service;

import java.util.UUID;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.endpoints.Endpoint;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class EndpointSynchronizeRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(EndpointSynchronizeRequest.class);
    private int tenantId;
    private String tenantDomain;
    private UUID messageId;
    private String endpointName;
    private EndpointOperationType endpointOperationType;

    EndpointSynchronizeRequest(int tenantId, String tenantDomain, UUID messageId, String endpointName, EndpointOperationType endpointOperationType) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.messageId = messageId;
        this.endpointName = endpointName;
        this.endpointOperationType = endpointOperationType;
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received [" + (Object)((Object)this) + "] "));
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(this.tenantId);
            privilegedCarbonContext.setTenantDomain(this.tenantDomain);
            SynapseConfiguration synapseConfiguration = (SynapseConfiguration)configurationContext.getAxisConfiguration().getParameter("synapse.config").getValue();
            Endpoint endpoint = synapseConfiguration.getEndpoint(this.endpointName);
            if (endpoint == null) {
                throw new ClusteringFault(String.format("Endpoint could not be found: ", this.endpointName));
            }
            if (this.endpointOperationType == EndpointOperationType.ACTIVATE) {
                endpoint.getContext().switchOn();
            } else {
                endpoint.getContext().switchOff();
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public String toString() {
        return "EndpointSynchronizeRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.messageId + ", endpointName='" + this.endpointName + '\'' + ", endpointOperationType=" + (Object)((Object)this.endpointOperationType) + '}';
    }

    public static enum EndpointOperationType {
        DEACTIVATE,
        ACTIVATE;

    }
}

