/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.rdbms;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.rdbms.RDBMSEventAdapter;

public class RDBMSEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.rdbms.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "rdbms";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportOutputMessageTypes = new ArrayList<String>();
        supportOutputMessageTypes.add("map");
        return supportOutputMessageTypes;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticPropertyList = new ArrayList<Property>();
        Property datasourceName = new Property("datasource.name");
        datasourceName.setDisplayName(this.resourceBundle.getString("datasource.name"));
        datasourceName.setRequired(true);
        staticPropertyList.add(datasourceName);
        Property tableName = new Property("table.name");
        tableName.setDisplayName(this.resourceBundle.getString("table.name"));
        tableName.setRequired(true);
        staticPropertyList.add(tableName);
        Property executionMode = new Property("execution.mode");
        executionMode.setDisplayName(this.resourceBundle.getString("execution.mode"));
        executionMode.setOptions(new String[]{this.resourceBundle.getString("execution.mode.insert"), this.resourceBundle.getString("execution.mode.update")});
        executionMode.setHint(this.resourceBundle.getString("execution.mode.hint"));
        executionMode.setRequired(true);
        staticPropertyList.add(executionMode);
        Property updateColumnKeys = new Property("update.keys");
        updateColumnKeys.setDisplayName(this.resourceBundle.getString("update.keys"));
        updateColumnKeys.setHint(this.resourceBundle.getString("update.keys.hint"));
        staticPropertyList.add(updateColumnKeys);
        Property attributesWithTypes = new Property("attributes.with.type");
        attributesWithTypes.setDisplayName(this.resourceBundle.getString("attributes.with.type"));
        attributesWithTypes.setHint(this.resourceBundle.getString("attributes.with.type.hint"));
        attributesWithTypes.setRequired(false);
        staticPropertyList.add(attributesWithTypes);
        return staticPropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        return null;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new RDBMSEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

