/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.rdbms.internal.ExecutionInfo;
import org.wso2.carbon.event.output.adapter.rdbms.internal.ds.RDBMSEventAdapterServiceValueHolder;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;

public class RDBMSEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(RDBMSEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private ResourceBundle resourceBundle;
    private Map<String, String> dbTypeMappings;
    private ExecutionInfo executionInfo = null;
    private DataSource dataSource;
    private boolean isUpdate;
    private Queue<Object> events;
    private boolean isBatchInsertionEnabled = false;
    private long timeInterval = 1000L;
    private int batchSize = 1000;
    private ExecutorService scheduler;
    private final String IS_BATCH_INSERTION_ENABLED = "isBatchInsertionEnabled";
    private final String BATCH_SIZE = "batchSize";
    private final String TIME_INTERVAL = "timeInterval";
    private String tableName;
    private Lock lock;
    private String executionMode;
    private String updateColumnKeys;

    public RDBMSEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.events = new ConcurrentLinkedQueue<Object>();
        this.lock = new ReentrantLock();
    }

    public void init() throws OutputEventAdapterException {
        this.resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.rdbms.i18n.Resources", Locale.getDefault());
        this.populateDbMappings();
        if (this.isBatchInsertionEnabled) {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }
        this.tableName = (String)this.eventAdapterConfiguration.getStaticProperties().get("table.name");
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        Connection con = null;
        try {
            CarbonDataSource carbonDataSource = RDBMSEventAdapterServiceValueHolder.getDataSourceService().getDataSource((String)this.eventAdapterConfiguration.getStaticProperties().get("datasource.name"));
            if (carbonDataSource == null) {
                throw new OutputEventAdapterRuntimeException("There is no datasource found by the name datasource.name to connect.");
            }
            DataSource dataSource = (DataSource)carbonDataSource.getDSObject();
            con = dataSource.getConnection();
            this.cleanupConnections(null, con);
        }
        catch (Exception e) {
            try {
                throw new OutputEventAdapterRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(null, con);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        Connection con = null;
        try {
            CarbonDataSource carbonDataSource = RDBMSEventAdapterServiceValueHolder.getDataSourceService().getDataSource((String)this.eventAdapterConfiguration.getStaticProperties().get("datasource.name"));
            this.dataSource = (DataSource)carbonDataSource.getDSObject();
            con = ((DataSource)carbonDataSource.getDSObject()).getConnection();
            this.cleanupConnections(null, con);
        }
        catch (DataSourceException e) {
            try {
                log.error((Object)("No data-source found by the name: " + (String)this.eventAdapterConfiguration.getStaticProperties().get("datasource.name")), (Throwable)e);
                throw new ConnectionUnavailableException(e.getMessage(), (Throwable)e);
                catch (SQLException e2) {
                    throw new ConnectionUnavailableException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnections(null, con);
                throw throwable;
            }
        }
        if (this.isBatchInsertionEnabled) {
            this.startScheduler();
        }
        this.executionMode = (String)this.eventAdapterConfiguration.getStaticProperties().get("execution.mode");
        this.updateColumnKeys = (String)this.eventAdapterConfiguration.getStaticProperties().get("update.keys");
        Map<String, String> attributesWithTypeMap = this.extractAttributeTypes((String)this.eventAdapterConfiguration.getStaticProperties().get("attributes.with.type"));
        if (attributesWithTypeMap != null) {
            this.executionInfo = new ExecutionInfo();
            this.initializeDatabaseExecutionFromDefinition(this.tableName, this.executionMode, this.updateColumnKeys, attributesWithTypeMap);
        }
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        block7: {
            try {
                if (message instanceof Map) {
                    if (this.executionInfo == null) {
                        this.executionInfo = new ExecutionInfo();
                        this.initializeDatabaseExecutionFromMessage(this.tableName, this.executionMode, this.updateColumnKeys, message);
                    }
                    if (!this.isBatchInsertionEnabled) {
                        this.executeProcessActions(message, this.tableName);
                    } else {
                        this.events.offer(message);
                        if (this.events.size() >= this.batchSize) {
                            this.executeBatchProcessActions((ConcurrentLinkedQueue)this.events, this.tableName);
                        }
                    }
                    break block7;
                }
                throw new OutputEventAdapterRuntimeException(message.getClass().toString() + "is not a compatible type. Hence Event is dropped.");
            }
            catch (OutputEventAdapterException e) {
                log.error((Object)(e.getMessage() + " Hence Event is dropped."), (Throwable)e);
            }
        }
    }

    private void initializeDatabaseExecutionInfo(String tableName, String executionMode, String updateColumnKeys, StringBuilder columnTypes, StringBuilder columns, StringBuilder valuePositionsBuilder, List<Attribute> tableInsertColumnList) {
        String createTableQuery = this.constructQuery(tableName, this.dbTypeMappings.get("createTable"), columnTypes, null, null, null, null);
        String insertTableRowQuery = this.constructQuery(tableName, this.dbTypeMappings.get("insertDataToTable"), null, columns, valuePositionsBuilder, null, null);
        String isTableExistQuery = this.constructQuery(tableName, this.dbTypeMappings.get("isTableExist"), null, null, null, null, null);
        this.executionInfo.setPreparedInsertStatement(insertTableRowQuery);
        this.executionInfo.setPreparedCreateTableStatement(createTableQuery);
        this.executionInfo.setInsertQueryColumnOrder(tableInsertColumnList);
        this.executionInfo.setPreparedTableExistenceCheckStatement(isTableExistQuery);
        if (executionMode.equalsIgnoreCase(this.resourceBundle.getString("execution.mode.update"))) {
            String[] queryAttributes = updateColumnKeys.trim().split(",");
            ArrayList<Attribute> queryAttributeList = new ArrayList<Attribute>(queryAttributes.length);
            block0: for (String queryAttribute : queryAttributes) {
                for (Attribute attribute : this.executionInfo.getInsertQueryColumnOrder()) {
                    if (!queryAttribute.trim().equalsIgnoreCase(attribute.getName())) continue;
                    queryAttributeList.add(attribute);
                    continue block0;
                }
            }
            this.executionInfo.setExistenceCheckQueryColumnOrder(queryAttributeList);
            StringBuilder columnValues = new StringBuilder("");
            ArrayList<Attribute> updateAttributes = new ArrayList<Attribute>();
            boolean appendComma = false;
            for (Attribute at : this.executionInfo.getInsertQueryColumnOrder()) {
                if (this.executionInfo.getExistenceCheckQueryColumnOrder().contains(at)) continue;
                if (appendComma) {
                    columnValues.append(" ").append(this.dbTypeMappings.get("comma")).append(" ");
                }
                columnValues.append(at.getName());
                columnValues.append(" ").append(this.dbTypeMappings.get("equal")).append(" ").append(this.dbTypeMappings.get("questionMark")).append(" ");
                updateAttributes.add(at);
                appendComma = true;
            }
            StringBuilder condition = new StringBuilder("");
            boolean appendAnd = false;
            for (Attribute at : this.executionInfo.getExistenceCheckQueryColumnOrder()) {
                if (appendAnd) {
                    condition.append(" ").append(this.dbTypeMappings.get("and")).append(" ");
                }
                condition.append(at.getName());
                condition.append(" ").append(this.dbTypeMappings.get("equal")).append(" ").append(this.dbTypeMappings.get("questionMark")).append(" ");
                updateAttributes.add(at);
                appendAnd = true;
            }
            this.executionInfo.setUpdateQueryColumnOrder(updateAttributes);
            String string = this.constructQuery(tableName, this.dbTypeMappings.get("updateTableRow"), null, null, null, columnValues, condition);
            this.executionInfo.setPreparedUpdateStatement(string);
        }
    }

    private void initializeDatabaseExecutionFromMessage(String tableName, String executionMode, String updateColumnKeys, Object message) {
        if (this.resourceBundle.getString("execution.mode.update").equalsIgnoreCase(executionMode)) {
            this.isUpdate = true;
            this.executionInfo.setUpdateMode(true);
        }
        StringBuilder columnTypes = new StringBuilder("");
        StringBuilder columns = new StringBuilder("");
        StringBuilder valuePositionsBuilder = new StringBuilder("");
        ArrayList<Attribute> tableInsertColumnList = new ArrayList<Attribute>();
        boolean appendComma = false;
        for (Map.Entry entry : ((Map)message).entrySet()) {
            AttributeType type = null;
            String columnName = ((String)entry.getKey()).toUpperCase();
            if (appendComma) {
                columnTypes.append(this.dbTypeMappings.get("comma"));
            }
            columnTypes.append(columnName).append("  ");
            if (entry.getValue() instanceof Integer) {
                type = AttributeType.INT;
                columnTypes.append(this.dbTypeMappings.get("integer"));
            } else if (entry.getValue() instanceof Long) {
                type = AttributeType.LONG;
                columnTypes.append(this.dbTypeMappings.get("long"));
            } else if (entry.getValue() instanceof Float) {
                type = AttributeType.FLOAT;
                columnTypes.append(this.dbTypeMappings.get("float"));
            } else if (entry.getValue() instanceof Double) {
                type = AttributeType.DOUBLE;
                columnTypes.append(this.dbTypeMappings.get("double"));
            } else if (entry.getValue() instanceof String) {
                type = AttributeType.STRING;
                columnTypes.append(this.dbTypeMappings.get("string"));
            } else if (entry.getValue() instanceof Boolean) {
                type = AttributeType.BOOL;
                columnTypes.append(this.dbTypeMappings.get("boolean"));
            }
            Attribute attribute = new Attribute((String)entry.getKey(), type);
            if (appendComma) {
                columns.append(this.dbTypeMappings.get("comma"));
                valuePositionsBuilder.append(this.dbTypeMappings.get("comma"));
            } else {
                appendComma = true;
            }
            tableInsertColumnList.add(attribute);
            columns.append(attribute.getName());
            valuePositionsBuilder.append(this.dbTypeMappings.get("questionMark"));
        }
        this.initializeDatabaseExecutionInfo(tableName, executionMode, updateColumnKeys, columnTypes, columns, valuePositionsBuilder, tableInsertColumnList);
    }

    private void initializeDatabaseExecutionFromDefinition(String tableName, String executionMode, String updateColumnKeys, Map<String, String> attributesWithTypeMap) {
        if (this.resourceBundle.getString("execution.mode.update").equalsIgnoreCase(executionMode)) {
            this.isUpdate = true;
            this.executionInfo.setUpdateMode(true);
        }
        StringBuilder columnTypes = new StringBuilder("");
        StringBuilder columns = new StringBuilder("");
        StringBuilder valuePositionsBuilder = new StringBuilder("");
        ArrayList<Attribute> tableInsertColumnList = new ArrayList<Attribute>();
        boolean appendComma = false;
        for (Map.Entry<String, String> entry : attributesWithTypeMap.entrySet()) {
            AttributeType type = null;
            String columnName = entry.getKey().toUpperCase();
            if (appendComma) {
                columnTypes.append(this.dbTypeMappings.get("comma"));
            }
            columnTypes.append(columnName).append("  ");
            if (entry.getValue().equalsIgnoreCase(AttributeType.INT.toString())) {
                type = AttributeType.INT;
                columnTypes.append(this.dbTypeMappings.get("integer"));
            } else if (entry.getValue().equalsIgnoreCase(AttributeType.LONG.toString())) {
                type = AttributeType.LONG;
                columnTypes.append(this.dbTypeMappings.get("long"));
            } else if (entry.getValue().equalsIgnoreCase(AttributeType.FLOAT.toString())) {
                type = AttributeType.FLOAT;
                columnTypes.append(this.dbTypeMappings.get("float"));
            } else if (entry.getValue().equalsIgnoreCase(AttributeType.DOUBLE.toString())) {
                type = AttributeType.DOUBLE;
                columnTypes.append(this.dbTypeMappings.get("double"));
            } else if (entry.getValue().equalsIgnoreCase(AttributeType.STRING.toString())) {
                type = AttributeType.STRING;
                columnTypes.append(this.dbTypeMappings.get("string"));
            } else if (entry.getValue().equalsIgnoreCase(AttributeType.BOOL.toString())) {
                type = AttributeType.BOOL;
                columnTypes.append(this.dbTypeMappings.get("boolean"));
            }
            Attribute attribute = new Attribute(entry.getKey(), type);
            if (appendComma) {
                columns.append(this.dbTypeMappings.get("comma"));
                valuePositionsBuilder.append(this.dbTypeMappings.get("comma"));
            } else {
                appendComma = true;
            }
            tableInsertColumnList.add(attribute);
            columns.append(attribute.getName());
            valuePositionsBuilder.append(this.dbTypeMappings.get("questionMark"));
        }
        this.initializeDatabaseExecutionInfo(tableName, executionMode, updateColumnKeys, columnTypes, columns, valuePositionsBuilder, tableInsertColumnList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeProcessActions(Object message, String tableName) throws OutputEventAdapterException {
        this.createTableIfNotExist(tableName);
        if (this.isUpdate) {
            RDBMSEventAdapter rDBMSEventAdapter = this;
            synchronized (rDBMSEventAdapter) {
                this.executeDbActions(message);
            }
        } else {
            this.executeDbActions(message);
        }
    }

    private void executeBatchProcessActions(ConcurrentLinkedQueue batch, String tableName) throws OutputEventAdapterException {
        this.createTableIfNotExist(tableName);
        try {
            this.lock.lock();
            if (batch.size() > 0) {
                this.executeDbActions(batch);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeDbActions(Object message) throws OutputEventAdapterException {
        PreparedStatement stmt = null;
        Connection con = null;
        Map map = (Map)message;
        boolean executeInsert = true;
        try {
            try {
                con = this.dataSource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ConnectionUnavailableException((Throwable)e);
            }
            if (this.executionInfo.isUpdateMode()) {
                stmt = con.prepareStatement(this.executionInfo.getPreparedUpdateStatement());
                this.populateStatement(map, stmt, this.executionInfo.getUpdateQueryColumnOrder());
                int updatedRows = stmt.executeUpdate();
                con.commit();
                stmt.close();
                if (updatedRows > 0) {
                    executeInsert = false;
                }
            }
            if (executeInsert) {
                stmt = con.prepareStatement(this.executionInfo.getPreparedInsertStatement());
                this.populateStatement(map, stmt, this.executionInfo.getInsertQueryColumnOrder());
                stmt.executeUpdate();
                con.commit();
            }
            this.cleanupConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                throw new OutputEventAdapterException("Cannot Execute Insert/Update Query for event " + message.toString() + " " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
        }
    }

    private void executeDbActions(ConcurrentLinkedQueue<Object> events) throws OutputEventAdapterException {
        PreparedStatement stmt;
        Connection con;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement(this.executionInfo.getPreparedInsertStatement());
        }
        catch (SQLException e) {
            throw new ConnectionUnavailableException((Throwable)e);
        }
        boolean executeInsert = true;
        Object event = new HashMap();
        try {
            if (this.executionInfo.isUpdateMode()) {
                Object message;
                while ((message = events.poll()) != null) {
                    PreparedStatement updateStmt = con.prepareStatement(this.executionInfo.getPreparedUpdateStatement());
                    Map map = (Map)message;
                    event = message;
                    this.populateStatement(map, updateStmt, this.executionInfo.getUpdateQueryColumnOrder());
                    int updatedRows = updateStmt.executeUpdate();
                    con.commit();
                    updateStmt.close();
                    if (updatedRows > 0) {
                        executeInsert = false;
                    }
                    if (!executeInsert) continue;
                    this.populateStatement(map, stmt, this.executionInfo.getInsertQueryColumnOrder());
                    stmt.addBatch();
                }
                if (executeInsert && stmt != null) {
                    stmt.executeBatch();
                    con.commit();
                }
            } else {
                Object message;
                while ((message = events.poll()) != null) {
                    Map map = (Map)message;
                    event = message;
                    this.populateStatement(map, stmt, this.executionInfo.getInsertQueryColumnOrder());
                    stmt.addBatch();
                }
                if (stmt != null) {
                    stmt.executeBatch();
                    con.commit();
                }
            }
        }
        catch (SQLException e) {
            throw new OutputEventAdapterException("Cannot Execute Insert/Update Query for event " + event.toString() + " " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanupConnections(stmt, con);
        }
    }

    private void populateStatement(Map<String, Object> map, PreparedStatement stmt, List<Attribute> colOrder) throws OutputEventAdapterException {
        Attribute attribute = null;
        try {
            for (int i = 0; i < colOrder.size(); ++i) {
                attribute = colOrder.get(i);
                Object value = map.get(attribute.getName());
                if (value != null || attribute.getType() == AttributeType.STRING) {
                    switch (attribute.getType()) {
                        case INT: {
                            stmt.setInt(i + 1, (Integer)value);
                            break;
                        }
                        case LONG: {
                            stmt.setLong(i + 1, (Long)value);
                            break;
                        }
                        case FLOAT: {
                            stmt.setFloat(i + 1, ((Float)value).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            stmt.setDouble(i + 1, (Double)value);
                            break;
                        }
                        case STRING: {
                            stmt.setString(i + 1, (String)value);
                            break;
                        }
                        case BOOL: {
                            stmt.setBoolean(i + 1, (Boolean)value);
                        }
                    }
                    continue;
                }
                throw new OutputEventAdapterException("Cannot Execute Insert/Update. Null value detected for attribute : " + attribute.getName() + " ,attribute type : " + attribute.getType());
            }
        }
        catch (SQLException e) {
            this.cleanupConnections(stmt, null);
            throw new OutputEventAdapterException("Cannot set value to attribute name " + attribute.getName() + ". Hence dropping the event. " + e.getMessage(), (Throwable)e);
        }
    }

    private void createTableIfNotExist(String tableName) throws OutputEventAdapterException {
        if (!this.executionInfo.isTableExist()) {
            Statement stmt = null;
            Boolean tableExists = true;
            Connection con = null;
            try {
                block12: {
                    try {
                        con = this.dataSource.getConnection();
                        con.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        throw new ConnectionUnavailableException((Throwable)e);
                    }
                    stmt = con.createStatement();
                    try {
                        stmt.executeQuery(this.executionInfo.getPreparedTableExistenceCheckStatement());
                        this.executionInfo.setTableExist(true);
                    }
                    catch (SQLException e) {
                        tableExists = false;
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)("Table " + tableName + " does not Exist. Table Will be created. "));
                    }
                }
                try {
                    if (!tableExists.booleanValue()) {
                        stmt.executeUpdate(this.executionInfo.getPreparedCreateTableStatement());
                        con.commit();
                        this.executionInfo.setTableExist(true);
                    }
                }
                catch (SQLException e) {
                    throw new OutputEventAdapterException("Cannot Execute Create Table Query. " + e.getMessage(), (Throwable)e);
                }
                this.cleanupConnections(stmt, con);
            }
            catch (SQLException e) {
                try {
                    throw new ConnectionUnavailableException((Throwable)e);
                }
                catch (Throwable throwable) {
                    this.cleanupConnections(stmt, con);
                    throw throwable;
                }
            }
        }
    }

    private void cleanupConnections(Statement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)("unable to close statement. " + e.getMessage()), (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)("unable to close connection. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String constructQuery(String tableName, String query, StringBuilder columnTypes, StringBuilder columns, StringBuilder values, StringBuilder columnValues, StringBuilder condition) {
        if (query.contains("$TABLE_NAME")) {
            query = query.replace("$TABLE_NAME", tableName);
        }
        if (query.contains("$COLUMN_TYPES")) {
            query = query.replace("$COLUMN_TYPES", columnTypes.toString());
        }
        if (query.contains("$COLUMNS")) {
            query = query.replace("$COLUMNS", columns.toString());
        }
        if (query.contains("$VALUES")) {
            query = query.replace("$VALUES", values.toString());
        }
        if (query.contains("$COLUMN_VALUES")) {
            query = query.replace("$COLUMN_VALUES", columnValues.toString());
        }
        if (query.contains("$CONDITION")) {
            query = query.replace("$CONDITION", condition.toString());
        }
        return query;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateDbMappings() throws OutputEventAdapterException {
        String batchSize;
        String timeInterval;
        String dbName = null;
        this.dbTypeMappings = new HashMap<String, String>();
        Connection con = null;
        try {
            CarbonDataSource carbonDataSource = RDBMSEventAdapterServiceValueHolder.getDataSourceService().getDataSource((String)this.eventAdapterConfiguration.getStaticProperties().get("datasource.name"));
            if (carbonDataSource == null) {
                throw new OutputEventAdapterException("There is no data-source called " + (String)this.eventAdapterConfiguration.getStaticProperties().get("datasource.name"));
            }
            con = ((DataSource)carbonDataSource.getDSObject()).getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            dbName = databaseMetaData.getDatabaseProductName();
            if ((dbName = dbName.toLowerCase()).equals("microsoft sql server")) {
                dbName = "mssql";
            }
            this.cleanupConnections(null, con);
        }
        catch (DataSourceException e) {
            try {
                log.error((Object)("There is no data-source found by the name: " + (String)this.eventAdapterConfiguration.getStaticProperties().get("datasource.name")), (Throwable)e);
                throw new ConnectionUnavailableException(e.getMessage(), (Throwable)e);
                catch (SQLException e2) {
                    throw new ConnectionUnavailableException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnections(null, con);
                throw throwable;
            }
        }
        String[] staticAttributes = new String[]{"string", "double", "integer", "long", "float", "boolean", "createTable", "insertDataToTable", "isTableExist", "updateTableRow", "selectAllColumnsDataTypeInTable", "selectFromTable", "comma", "questionMark", "equal", "and"};
        String attribute = null;
        HashMap<String, String> defaultMappings = new HashMap<String, String>();
        for (String staticAttribute : staticAttributes) {
            Boolean staticAttributeExist = false;
            for (Map.Entry<String, String> entry : this.globalProperties.entrySet()) {
                attribute = staticAttribute;
                if (!staticAttribute.equals(entry.getKey())) continue;
                staticAttributeExist = true;
                defaultMappings.put(entry.getKey(), entry.getValue());
                break;
            }
            if (staticAttributeExist.booleanValue()) continue;
            throw new OutputEventAdapterRuntimeException("A mandatory attribute " + (String)attribute + " does not exist");
        }
        for (Map.Entry defaultMap : defaultMappings.entrySet()) {
            Boolean valueExist = false;
            for (Map.Entry entry : this.globalProperties.entrySet()) {
                if (!((String)entry.getKey()).contains(dbName) || !((String)entry.getKey()).contains((CharSequence)defaultMap.getKey())) continue;
                this.dbTypeMappings.put((String)defaultMap.getKey(), (String)entry.getValue());
                valueExist = true;
                break;
            }
            if (valueExist.booleanValue()) continue;
            this.dbTypeMappings.put((String)defaultMap.getKey(), (String)defaultMap.getValue());
        }
        String batchInsertionEnabled = this.globalProperties.get("isBatchInsertionEnabled");
        if (batchInsertionEnabled != null && "TRUE".equalsIgnoreCase(batchInsertionEnabled)) {
            this.isBatchInsertionEnabled = true;
        }
        if ((timeInterval = this.globalProperties.get("timeInterval")) != null) {
            this.timeInterval = Integer.parseInt(timeInterval);
        }
        if ((batchSize = this.globalProperties.get("batchSize")) != null) {
            this.batchSize = Integer.parseInt(batchSize);
        }
    }

    public void disconnect() {
        if (this.dataSource != null) {
            this.dataSource = null;
        }
        if (this.executionInfo != null) {
            this.executionInfo.setTableExist(false);
        }
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
    }

    public void destroy() {
        if (this.executionInfo != null) {
            this.executionInfo = null;
        }
        if (this.dataSource != null) {
            this.dataSource = null;
        }
    }

    public boolean isPolled() {
        return false;
    }

    private void startScheduler() {
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                if (RDBMSEventAdapter.this.events.size() > 0) {
                    try {
                        RDBMSEventAdapter.this.executeBatchProcessActions((ConcurrentLinkedQueue)RDBMSEventAdapter.this.events, RDBMSEventAdapter.this.tableName);
                    }
                    catch (OutputEventAdapterException e) {
                        log.error((Object)(e.getMessage() + " Hence Event is dropped."), (Throwable)e);
                    }
                }
            }
        };
        ((ScheduledExecutorService)this.scheduler).scheduleAtFixedRate(writer, 0L, this.timeInterval, TimeUnit.MILLISECONDS);
    }

    private Map<String, String> extractAttributeTypes(String attributeDefinition) {
        if (attributeDefinition == null || attributeDefinition.trim().length() == 0) {
            return null;
        }
        String[] entries = attributeDefinition.split(",");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String attributeWithType : entries) {
            try {
                String[] keyValue = attributeWithType.split(":", 2);
                result.put(keyValue[0].trim(), keyValue[1].trim());
            }
            catch (Exception e) {
                log.warn((Object)("Attribute with type '" + attributeWithType + "' is not defined in the correct format."), (Throwable)e);
            }
        }
        return result;
    }
}

