/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.oidc.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authenticator.oidc.OpenIDConnectAuthenticator;
import org.wso2.carbon.identity.application.authenticator.oidc.internal.OpenIDConnectAuthenticatorDataHolder;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.application.authenticator.oidc.component", immediate=true)
public class OpenIDConnectAuthenticatorServiceComponent {
    private static final Log log = LogFactory.getLog(OpenIDConnectAuthenticatorServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            OpenIDConnectAuthenticator openIDConnectAuthenticator = new OpenIDConnectAuthenticator();
            ctxt.getBundleContext().registerService(ApplicationAuthenticator.class.getName(), (Object)openIDConnectAuthenticator, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"OpenID Connect Authenticator bundle is activated");
            }
        }
        catch (Throwable e) {
            log.fatal((Object)" Error while activating oidc authenticator ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"OpenID Connect Authenticator bundle is deactivated");
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        OpenIDConnectAuthenticatorDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Realm Service");
        }
        OpenIDConnectAuthenticatorDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="claim.manager.listener.service", service=ClaimMetadataManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimManagementService")
    protected void setClaimManagementService(ClaimMetadataManagementService claimMetadataManagementService) {
        OpenIDConnectAuthenticatorDataHolder.getInstance().setClaimMetadataManagementService(claimMetadataManagementService);
    }

    protected void unsetClaimManagementService(ClaimMetadataManagementService claimMetadataManagementService) {
        OpenIDConnectAuthenticatorDataHolder.getInstance().setClaimMetadataManagementService(null);
    }
}

