/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.oidc;

import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONArray;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAuthzResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.wso2.carbon.identity.application.authentication.framework.AbstractApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStateInfo;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authenticator.oidc.internal.OpenIDConnectAuthenticatorDataHolder;
import org.wso2.carbon.identity.application.authenticator.oidc.model.OIDCStateInfo;
import org.wso2.carbon.identity.application.authenticator.oidc.util.OIDCErrorConstants;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class OpenIDConnectAuthenticator
extends AbstractApplicationAuthenticator
implements FederatedApplicationAuthenticator {
    private static final long serialVersionUID = -4154255583070524018L;
    private static final Log log = LogFactory.getLog(OpenIDConnectAuthenticator.class);
    private static final String OIDC_DIALECT = "http://wso2.org/oidc/claim";
    private static final String DYNAMIC_PARAMETER_LOOKUP_REGEX = "\\$\\{(\\w+)\\}";
    private static Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");

    protected void processLogoutResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        if (log.isDebugEnabled()) {
            if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                log.debug((Object)("Handled logout response from service provider " + request.getParameter("sp") + " in tenant domain " + IdentityTenantUtil.getTenantDomainFromContext()));
            } else {
                log.debug((Object)("Handled logout response from service provider " + request.getParameter("sp") + " in tenant domain " + request.getParameter("tenantDomain")));
            }
        }
    }

    public boolean canHandle(HttpServletRequest request) {
        String code;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Inside OpenIDConnectAuthenticator.canHandle()");
        }
        return StringUtils.isNotBlank((String)(code = request.getParameter("code"))) && "OIDC".equals(this.getLoginType(request));
    }

    protected String getAuthorizationServerEndpoint(Map<String, String> authenticatorProperties) {
        return null;
    }

    protected String getCallbackUrl(Map<String, String> authenticatorProperties) {
        String callbackUrl = authenticatorProperties.get("callbackUrl");
        if (StringUtils.isBlank((String)callbackUrl)) {
            try {
                callbackUrl = ServiceURLBuilder.create().addPath(new String[]{"commonauth"}).build().getAbsolutePublicURL();
            }
            catch (URLBuilderException e) {
                throw new RuntimeException("Error occurred while building URL in tenant qualified mode.", e);
            }
        }
        return callbackUrl;
    }

    protected String getLogoutUrl(Map<String, String> authenticatorProperties) {
        return authenticatorProperties.get("OIDCLogoutEPUrl");
    }

    protected String getTokenEndpoint(Map<String, String> authenticatorProperties) {
        return authenticatorProperties.get("OAuth2TokenEPUrl");
    }

    protected String getState(String state, Map<String, String> authenticatorProperties) {
        return state;
    }

    protected String getScope(String scope, Map<String, String> authenticatorProperties) {
        if (StringUtils.isBlank((String)scope)) {
            scope = "openid";
        }
        return scope;
    }

    protected boolean requiredIDToken(Map<String, String> authenticatorProperties) {
        return true;
    }

    protected String getAuthenticateUser(AuthenticationContext context, Map<String, Object> oidcClaims, OAuthClientResponse oidcResponse) {
        return (String)oidcClaims.get("sub");
    }

    protected String getCallBackURL(Map<String, String> authenticatorProperties) {
        return this.getCallbackUrl(authenticatorProperties);
    }

    protected String getQueryString(Map<String, String> authenticatorProperties) {
        return authenticatorProperties.get("commonAuthQueryParams");
    }

    protected String getUserInfoEndpoint(OAuthClientResponse token, Map<String, String> authenticatorProperties) {
        return authenticatorProperties.get("UserInfoUrl");
    }

    protected Map<ClaimMapping, String> getSubjectAttributes(OAuthClientResponse token, Map<String, String> authenticatorProperties) {
        HashMap<ClaimMapping, String> claims = new HashMap<ClaimMapping, String>();
        try {
            String accessToken = token.getParam("access_token");
            String url = this.getUserInfoEndpoint(token, authenticatorProperties);
            String json = this.sendRequest(url, accessToken);
            if (StringUtils.isBlank((String)json)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Empty JSON response from user info endpoint. Unable to fetch user claims. Proceeding without user claims");
                }
                return claims;
            }
            Map jsonObject = JSONUtils.parseJSON((String)json);
            for (Map.Entry data : jsonObject.entrySet()) {
                String key = (String)data.getKey();
                Object valueObject = data.getValue();
                if (valueObject != null) {
                    String value = valueObject instanceof Object[] ? StringUtils.join((Object[])((Object[])valueObject), (String)FrameworkUtils.getMultiAttributeSeparator()) : valueObject.toString();
                    claims.put(ClaimMapping.build((String)key, (String)key, null, (boolean)false), value);
                }
                if (!log.isDebugEnabled() || !IdentityUtil.isTokenLoggable((String)"UserClaims") || jsonObject.get(key) == null) continue;
                log.debug((Object)("Adding claims from end-point data mapping : " + key + " - " + jsonObject.get(key).toString()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Communication error occurred while accessing user info endpoint", (Throwable)e);
        }
        return claims;
    }

    protected void initiateAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        try {
            String loginPage;
            Map authenticatorProperties = context.getAuthenticatorProperties();
            if (authenticatorProperties != null) {
                String clientId = (String)authenticatorProperties.get("ClientId");
                String authorizationEP = this.getOIDCAuthzEndpoint(authenticatorProperties);
                String callbackurl = this.getCallbackUrl(authenticatorProperties);
                String state = this.getStateParameter(context, authenticatorProperties);
                String queryString = this.getQueryString(authenticatorProperties);
                queryString = this.interpretQueryString(context, queryString, request.getParameterMap());
                HashMap<String, String> paramValueMap = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)queryString)) {
                    String[] params;
                    for (String param : params = queryString.split("&")) {
                        String[] intParam = param.split("=");
                        if (intParam.length < 2) continue;
                        paramValueMap.put(intParam[0], intParam[1]);
                    }
                    context.setProperty("oidc:param.map", paramValueMap);
                }
                queryString = this.getEvaluatedQueryString(paramValueMap);
                String scope = (String)paramValueMap.get("scope");
                scope = this.getScope(scope, authenticatorProperties);
                OAuthClientRequest authzRequest = StringUtils.isNotBlank((String)queryString) && queryString.toLowerCase().contains("scope=") && queryString.toLowerCase().contains("redirect_uri=") ? OAuthClientRequest.authorizationLocation((String)authorizationEP).setClientId(clientId).setResponseType("code").setState(state).buildQueryMessage() : (StringUtils.isNotBlank((String)queryString) && queryString.toLowerCase().contains("scope=") ? OAuthClientRequest.authorizationLocation((String)authorizationEP).setClientId(clientId).setRedirectURI(callbackurl).setResponseType("code").setState(state).buildQueryMessage() : (StringUtils.isNotBlank((String)queryString) && queryString.toLowerCase().contains("redirect_uri=") ? OAuthClientRequest.authorizationLocation((String)authorizationEP).setClientId(clientId).setResponseType("code").setScope("openid").setState(state).buildQueryMessage() : OAuthClientRequest.authorizationLocation((String)authorizationEP).setClientId(clientId).setRedirectURI(callbackurl).setResponseType("code").setScope(scope).setState(state).buildQueryMessage()));
                loginPage = authzRequest.getLocationUri();
                String domain = request.getParameter("domain");
                if (StringUtils.isNotBlank((String)domain)) {
                    loginPage = loginPage + "&fidp=" + domain;
                }
                if (StringUtils.isNotBlank((String)queryString)) {
                    loginPage = !queryString.startsWith("&") ? loginPage + "&" + queryString : loginPage + queryString;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)OIDCErrorConstants.ErrorMessages.RETRIEVING_AUTHENTICATOR_PROPERTIES_FAILED.getMessage());
                }
                throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.RETRIEVING_AUTHENTICATOR_PROPERTIES_FAILED.getCode(), OIDCErrorConstants.ErrorMessages.RETRIEVING_AUTHENTICATOR_PROPERTIES_FAILED.getMessage());
            }
            response.sendRedirect(loginPage);
        }
        catch (UnsupportedEncodingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while encoding the additional query parameters", (Throwable)e);
            }
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.BUILDING_AUTHORIZATION_CODE_REQUEST_FAILED.getCode(), e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.IO_ERROR.getCode(), e.getMessage(), (Throwable)e);
        }
        catch (OAuthSystemException e) {
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.BUILDING_AUTHORIZATION_CODE_REQUEST_FAILED.getCode(), e.getMessage(), (Throwable)e);
        }
    }

    private String getStateParameter(AuthenticationContext context, Map<String, String> authenticatorProperties) {
        String state = context.getContextIdentifier() + "," + "OIDC";
        return this.getState(state, authenticatorProperties);
    }

    private String getOIDCAuthzEndpoint(Map<String, String> authenticatorProperties) {
        String authorizationEP = this.getAuthorizationServerEndpoint(authenticatorProperties);
        if (StringUtils.isBlank((String)authorizationEP)) {
            authorizationEP = authenticatorProperties.get("OAuth2AuthzEPUrl");
        }
        return authorizationEP;
    }

    protected void processAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        try {
            AuthenticatedUser authenticatedUser;
            OAuthAuthzResponse authzResponse = OAuthAuthzResponse.oauthCodeAuthzResponse((HttpServletRequest)request);
            OAuthClientRequest accessTokenRequest = this.getAccessTokenRequest(context, authzResponse);
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthClientResponse oAuthResponse = this.getOauthResponse(oAuthClient, accessTokenRequest);
            String accessToken = oAuthResponse.getParam("access_token");
            if (StringUtils.isBlank((String)accessToken)) {
                throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.ACCESS_TOKEN_EMPTY_OR_NULL.getCode(), OIDCErrorConstants.ErrorMessages.ACCESS_TOKEN_EMPTY_OR_NULL.getMessage());
            }
            String idToken = oAuthResponse.getParam("id_token");
            Map authenticatorProperties = context.getAuthenticatorProperties();
            if (StringUtils.isBlank((String)idToken) && this.requiredIDToken(authenticatorProperties)) {
                throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.ID_TOKEN_MISSED_IN_OIDC_RESPONSE.getCode(), String.format(OIDCErrorConstants.ErrorMessages.ID_TOKEN_MISSED_IN_OIDC_RESPONSE.getMessage(), this.getTokenEndpoint(authenticatorProperties), authenticatorProperties.get("ClientId")));
            }
            OIDCStateInfo stateInfoOIDC = new OIDCStateInfo();
            stateInfoOIDC.setIdTokenHint(idToken);
            context.setStateInfo((AuthenticatorStateInfo)stateInfoOIDC);
            context.setProperty("access_token", (Object)accessToken);
            HashMap<ClaimMapping, String> claims = new HashMap<ClaimMapping, String>();
            Map<Object, Object> jsonObject = new HashMap();
            if (StringUtils.isNotBlank((String)idToken)) {
                jsonObject = this.getIdTokenClaims(context, idToken);
                if (jsonObject == null) {
                    String errorMessage = OIDCErrorConstants.ErrorMessages.DECODED_JSON_OBJECT_IS_NULL.getMessage();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage);
                    }
                    throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.DECODED_JSON_OBJECT_IS_NULL.getCode(), errorMessage);
                }
                if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"UserIdToken")) {
                    log.debug((Object)("Retrieved the User Information:" + jsonObject));
                }
                String authenticatedUserId = this.getAuthenticatedUserId(context, oAuthResponse, jsonObject);
                String attributeSeparator = this.getMultiAttributeSeparator(context, authenticatedUserId);
                for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                    this.buildClaimMappings(claims, entry, attributeSeparator);
                }
                authenticatedUser = AuthenticatedUser.createFederateAuthenticatedUserFromSubjectIdentifier((String)authenticatedUserId);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The IdToken is null");
                }
                authenticatedUser = AuthenticatedUser.createFederateAuthenticatedUserFromSubjectIdentifier((String)this.getAuthenticateUser(context, jsonObject, oAuthResponse));
            }
            claims.putAll(this.getSubjectAttributes(oAuthResponse, authenticatorProperties));
            authenticatedUser.setUserAttributes(claims);
            context.setSubject(authenticatedUser);
        }
        catch (OAuthProblemException e) {
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.AUTHENTICATION_PROCESS_FAILED.getCode(), OIDCErrorConstants.ErrorMessages.AUTHENTICATION_PROCESS_FAILED.getMessage(), (User)context.getSubject(), (Throwable)e);
        }
    }

    protected void initiateLogoutRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws LogoutFailedException {
        if (this.isLogoutEnabled(context)) {
            String logoutUrl = this.getLogoutUrl(context.getAuthenticatorProperties());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String idTokenHint = this.getIdTokenHint(context);
            if (StringUtils.isNotBlank((String)idTokenHint)) {
                paramMap.put("id_token_hint", idTokenHint);
            }
            String callback = this.getCallbackUrl(context.getAuthenticatorProperties());
            paramMap.put("post_logout_redirect_uri", callback);
            String sessionID = this.getStateParameter(context, context.getAuthenticatorProperties());
            paramMap.put("state", sessionID);
            try {
                logoutUrl = FrameworkUtils.buildURLWithQueryParams((String)logoutUrl, paramMap);
                response.sendRedirect(logoutUrl);
            }
            catch (IOException e) {
                String idpName = context.getExternalIdP().getName();
                String tenantDomain = context.getTenantDomain();
                throw new LogoutFailedException("Error occurred while initiating the logout request to IdP: " + idpName + " of tenantDomain: " + tenantDomain, (Throwable)e);
            }
        } else {
            super.initiateLogoutRequest(request, response, context);
        }
    }

    private boolean isLogoutEnabled(AuthenticationContext context) {
        String logoutUrl = this.getLogoutUrl(context.getAuthenticatorProperties());
        return StringUtils.isNotBlank((String)logoutUrl);
    }

    private String getIdTokenHint(AuthenticationContext context) {
        if (context.getStateInfo() instanceof OIDCStateInfo) {
            return ((OIDCStateInfo)context.getStateInfo()).getIdTokenHint();
        }
        return null;
    }

    private Map<String, Object> getIdTokenClaims(AuthenticationContext context, String idToken) {
        context.setProperty("id_token", (Object)idToken);
        String base64Body = idToken.split("\\.")[1];
        byte[] decoded = Base64.decodeBase64((byte[])base64Body.getBytes());
        Set jwtAttributeSet = new HashSet();
        try {
            jwtAttributeSet = JSONObjectUtils.parseJSONObject((String)new String(decoded)).entrySet();
        }
        catch (ParseException e) {
            log.error((Object)"Error occurred while parsing JWT provided by federated IDP: ", (Throwable)e);
        }
        HashMap<String, Object> jwtAttributeMap = new HashMap<String, Object>();
        for (Map.Entry entry : jwtAttributeSet) {
            jwtAttributeMap.put((String)entry.getKey(), entry.getValue());
        }
        return jwtAttributeMap;
    }

    private String getMultiAttributeSeparator(AuthenticationContext context, String authenticatedUserId) throws AuthenticationFailedException {
        String attributeSeparator = null;
        try {
            String tenantDomain = context.getTenantDomain();
            if (StringUtils.isBlank((String)tenantDomain)) {
                tenantDomain = "carbon.super";
            }
            int tenantId = OpenIDConnectAuthenticatorDataHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            UserRealm userRealm = OpenIDConnectAuthenticatorDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
            if (userRealm != null) {
                UserStoreManager userStore = (UserStoreManager)userRealm.getUserStoreManager();
                attributeSeparator = userStore.getRealmConfiguration().getUserStoreProperty("MultiAttributeSeparator");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("For the claim mapping: " + attributeSeparator + " is used as the attributeSeparator in tenant: " + tenantDomain));
                }
            }
        }
        catch (UserStoreException e) {
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.RETRIEVING_MULTI_ATTRIBUTE_SEPARATOR_FAILED.getCode(), OIDCErrorConstants.ErrorMessages.RETRIEVING_MULTI_ATTRIBUTE_SEPARATOR_FAILED.getMessage(), (User)AuthenticatedUser.createFederateAuthenticatedUserFromSubjectIdentifier((String)authenticatedUserId), (Throwable)e);
        }
        return attributeSeparator;
    }

    private String getAuthenticatedUserId(AuthenticationContext context, OAuthClientResponse oAuthResponse, Map<String, Object> idTokenClaims) throws AuthenticationFailedException {
        String authenticatedUserId;
        if (this.isUserIdFoundAmongClaims(context)) {
            authenticatedUserId = this.getSubjectFromUserIDClaimURI(context, idTokenClaims);
            if (StringUtils.isNotBlank((String)authenticatedUserId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authenticated user id: " + authenticatedUserId + " was found among id_token claims."));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Subject claim could not be found amongst id_token claims. Defaulting to the 'sub' attribute in id_token as authenticated user id.");
                }
                authenticatedUserId = this.getAuthenticateUser(context, idTokenClaims, oAuthResponse);
            }
        } else {
            authenticatedUserId = this.getAuthenticateUser(context, idTokenClaims, oAuthResponse);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authenticated user id: " + authenticatedUserId + " retrieved from the 'sub' claim."));
            }
        }
        if (authenticatedUserId == null) {
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.USER_ID_NOT_FOUND_IN_ID_TOKEN_SENT_BY_FEDERATED_IDP.getCode(), OIDCErrorConstants.ErrorMessages.USER_ID_NOT_FOUND_IN_ID_TOKEN_SENT_BY_FEDERATED_IDP.getMessage());
        }
        return authenticatedUserId;
    }

    private boolean isUserIdFoundAmongClaims(AuthenticationContext context) {
        return Boolean.parseBoolean((String)context.getAuthenticatorProperties().get("IsUserIdInClaims"));
    }

    protected void buildClaimMappings(Map<ClaimMapping, String> claims, Map.Entry<String, Object> entry, String separator) {
        StringBuilder claimValue = null;
        if (StringUtils.isBlank((String)separator)) {
            separator = ",,,";
        }
        if (entry.getValue() instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)entry.getValue();
            if (jsonArray != null && !jsonArray.isEmpty()) {
                Iterator attributeIterator = jsonArray.iterator();
                while (attributeIterator.hasNext()) {
                    if (claimValue == null) {
                        claimValue = new StringBuilder(attributeIterator.next().toString());
                        continue;
                    }
                    claimValue.append(separator).append(attributeIterator.next().toString());
                }
            }
        } else {
            claimValue = entry.getValue() != null ? new StringBuilder(entry.getValue().toString()) : new StringBuilder();
        }
        claims.put(ClaimMapping.build((String)entry.getKey(), (String)entry.getKey(), null, (boolean)false), claimValue != null ? claimValue.toString() : "");
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"UserClaims")) {
            log.debug((Object)("Adding claim mapping : " + entry.getKey() + " <> " + entry.getKey() + " : " + claimValue));
        }
    }

    protected OAuthClientRequest getAccessTokenRequest(AuthenticationContext context, OAuthAuthzResponse authzResponse) throws AuthenticationFailedException {
        OAuthClientRequest accessTokenRequest;
        Map authenticatorProperties = context.getAuthenticatorProperties();
        String clientId = (String)authenticatorProperties.get("ClientId");
        String clientSecret = (String)authenticatorProperties.get("ClientSecret");
        String tokenEndPoint = this.getTokenEndpoint(authenticatorProperties);
        String callbackUrl = this.getCallbackUrlFromInitialRequestParamMap(context);
        if (StringUtils.isBlank((String)callbackUrl)) {
            callbackUrl = this.getCallbackUrl(authenticatorProperties);
        }
        boolean isHTTPBasicAuth = Boolean.parseBoolean((String)authenticatorProperties.get("IsBasicAuthEnabled"));
        try {
            if (isHTTPBasicAuth) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authenticating to token endpoint: " + tokenEndPoint + " with HTTP basic authentication scheme."));
                }
                accessTokenRequest = OAuthClientRequest.tokenLocation((String)tokenEndPoint).setGrantType(GrantType.AUTHORIZATION_CODE).setRedirectURI(callbackUrl).setCode(authzResponse.getCode()).buildBodyMessage();
                String base64EncodedCredential = new String(Base64.encodeBase64((byte[])(clientId + ":" + clientSecret).getBytes()));
                accessTokenRequest.addHeader("Authorization", "Basic " + base64EncodedCredential);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authenticating to token endpoint: " + tokenEndPoint + " including client credentials in request body."));
                }
                accessTokenRequest = OAuthClientRequest.tokenLocation((String)tokenEndPoint).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(callbackUrl).setCode(authzResponse.getCode()).buildBodyMessage();
            }
            if (accessTokenRequest != null) {
                String serverURL = ServiceURLBuilder.create().build().getAbsolutePublicURL();
                accessTokenRequest.addHeader("Origin", serverURL);
            }
        }
        catch (OAuthSystemException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(OIDCErrorConstants.ErrorMessages.BUILDING_ACCESS_TOKEN_REQUEST_FAILED.getMessage(), tokenEndPoint), (Throwable)e);
            }
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.BUILDING_ACCESS_TOKEN_REQUEST_FAILED.getCode(), (Throwable)e);
        }
        catch (URLBuilderException e) {
            throw new RuntimeException("Error occurred while building URL in tenant qualified mode.", e);
        }
        return accessTokenRequest;
    }

    protected OAuthClientResponse getOauthResponse(OAuthClient oAuthClient, OAuthClientRequest accessRequest) throws AuthenticationFailedException {
        OAuthJSONAccessTokenResponse oAuthResponse;
        try {
            oAuthResponse = oAuthClient.accessToken(accessRequest);
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)OIDCErrorConstants.ErrorMessages.REQUESTING_ACCESS_TOKEN_FAILED.getMessage(), e);
            }
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.REQUESTING_ACCESS_TOKEN_FAILED.getCode(), e.getMessage(), e);
        }
        return oAuthResponse;
    }

    public String getContextIdentifier(HttpServletRequest request) {
        String state;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Inside OpenIDConnectAuthenticator.getContextIdentifier()");
        }
        if ((state = request.getParameter("state")) != null) {
            return state.split(",")[0];
        }
        return null;
    }

    private String getLoginType(HttpServletRequest request) {
        String[] stateElements;
        String state = request.getParameter("state");
        if (state != null && (stateElements = state.split(",")).length > 1) {
            return stateElements[1];
        }
        return null;
    }

    public String getFriendlyName() {
        return "openidconnect";
    }

    public String getName() {
        return "OpenIDConnectAuthenticator";
    }

    public String getClaimDialectURI() {
        return OIDC_DIALECT;
    }

    public List<Property> getConfigurationProperties() {
        ArrayList<Property> configProperties = new ArrayList<Property>();
        Property clientId = new Property();
        clientId.setName("ClientId");
        clientId.setDisplayName("Client Id");
        clientId.setRequired(true);
        clientId.setDescription("Enter OAuth2/OpenID Connect client identifier value");
        clientId.setType("string");
        clientId.setDisplayOrder(1);
        configProperties.add(clientId);
        Property clientSecret = new Property();
        clientSecret.setName("ClientSecret");
        clientSecret.setDisplayName("Client Secret");
        clientSecret.setRequired(true);
        clientSecret.setDescription("Enter OAuth2/OpenID Connect client secret value");
        clientSecret.setType("string");
        clientSecret.setDisplayOrder(2);
        clientSecret.setConfidential(true);
        configProperties.add(clientSecret);
        Property authzEpUrl = new Property();
        authzEpUrl.setName("OAuth2AuthzEPUrl");
        authzEpUrl.setDisplayName("Authorization Endpoint URL");
        authzEpUrl.setRequired(true);
        authzEpUrl.setDescription("Enter OAuth2/OpenID Connect authorization endpoint URL value");
        authzEpUrl.setType("string");
        authzEpUrl.setDisplayOrder(3);
        configProperties.add(authzEpUrl);
        Property tokenEpUrl = new Property();
        tokenEpUrl.setName("OAuth2TokenEPUrl");
        tokenEpUrl.setDisplayName("Token Endpoint URL");
        tokenEpUrl.setRequired(true);
        tokenEpUrl.setDescription("Enter OAuth2/OpenID Connect token endpoint URL value");
        tokenEpUrl.setType("string");
        tokenEpUrl.setDisplayOrder(4);
        configProperties.add(tokenEpUrl);
        Property callBackUrl = new Property();
        callBackUrl.setName("callbackUrl");
        callBackUrl.setDisplayName("Callback Url");
        callBackUrl.setRequired(false);
        callBackUrl.setDescription("Enter value corresponding to callback url");
        callBackUrl.setType("string");
        callBackUrl.setDisplayOrder(5);
        configProperties.add(callBackUrl);
        Property userInfoUrl = new Property();
        userInfoUrl.setName("UserInfoUrl");
        userInfoUrl.setDisplayName("Userinfo Endpoint URL");
        userInfoUrl.setRequired(false);
        userInfoUrl.setDescription("Enter value corresponding to userinfo endpoint url");
        userInfoUrl.setType("string");
        userInfoUrl.setDisplayOrder(6);
        configProperties.add(userInfoUrl);
        Property userIdLocation = new Property();
        userIdLocation.setName("IsUserIdInClaims");
        userIdLocation.setDisplayName("OpenID Connect User ID Location");
        userIdLocation.setRequired(false);
        userIdLocation.setDescription("Specifies the location to find the user identifier in the ID token assertion");
        userIdLocation.setType("boolean");
        userIdLocation.setDisplayOrder(7);
        configProperties.add(userIdLocation);
        Property additionalParams = new Property();
        additionalParams.setName("commonAuthQueryParams");
        additionalParams.setDisplayName("Additional Query Parameters");
        additionalParams.setRequired(false);
        additionalParams.setDescription("Additional query parameters. e.g: paramName1=value1");
        additionalParams.setType("string");
        additionalParams.setDisplayOrder(8);
        configProperties.add(additionalParams);
        Property enableBasicAuth = new Property();
        enableBasicAuth.setName("IsBasicAuthEnabled");
        enableBasicAuth.setDisplayName("Enable HTTP basic auth for client authentication");
        enableBasicAuth.setRequired(false);
        enableBasicAuth.setDescription("Specifies that HTTP basic authentication should be used for client authentication, else client credentials will be included in the request body");
        enableBasicAuth.setType("boolean");
        enableBasicAuth.setDisplayOrder(9);
        configProperties.add(enableBasicAuth);
        return configProperties;
    }

    protected String getSubjectFromUserIDClaimURI(AuthenticationContext context) {
        String subject;
        block2: {
            subject = null;
            try {
                subject = FrameworkUtils.getFederatedSubjectFromClaims((AuthenticationContext)context, (String)this.getClaimDialectURI());
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Couldn't find the subject claim from claim mappings ", (Throwable)e);
            }
        }
        return subject;
    }

    protected String getSubjectFromUserIDClaimURI(AuthenticationContext context, Map<String, Object> idTokenClaims) throws AuthenticationFailedException {
        boolean useLocalClaimDialect = context.getExternalIdP().useDefaultLocalIdpDialect();
        String userIdClaimUri = context.getExternalIdP().getUserIdClaimUri();
        String spTenantDomain = context.getTenantDomain();
        try {
            Object subject;
            String userIdClaimUriInOIDCDialect;
            block11: {
                block9: {
                    block10: {
                        userIdClaimUriInOIDCDialect = null;
                        if (!useLocalClaimDialect) break block9;
                        if (!StringUtils.isNotBlank((String)userIdClaimUri)) break block10;
                        userIdClaimUriInOIDCDialect = this.getUserIdClaimUriInOIDCDialect(userIdClaimUri, spTenantDomain);
                        break block11;
                    }
                    if (!log.isDebugEnabled()) break block11;
                    String idpName = context.getExternalIdP().getIdPName();
                    log.debug((Object)("User ID Claim URI is not configured for IDP: " + idpName + ". Cannot retrieve subject using user id claim URI."));
                    break block11;
                }
                Object[] claimMappings = context.getExternalIdP().getClaimMappings();
                if (!ArrayUtils.isEmpty((Object[])claimMappings)) {
                    for (Object claimMapping : claimMappings) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Evaluating " + claimMapping.getRemoteClaim().getClaimUri() + " against " + userIdClaimUri));
                        }
                        if (!StringUtils.equals((String)claimMapping.getRemoteClaim().getClaimUri(), (String)userIdClaimUri)) continue;
                        String userIdClaimUriInLocalDialect = claimMapping.getLocalClaim().getClaimUri();
                        userIdClaimUriInOIDCDialect = this.getUserIdClaimUriInOIDCDialect(userIdClaimUriInLocalDialect, spTenantDomain);
                        break;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("using userIdClaimUriInOIDCDialect to get subject from idTokenClaims: " + userIdClaimUriInOIDCDialect));
            }
            if ((subject = idTokenClaims.get(userIdClaimUriInOIDCDialect)) instanceof String) {
                return (String)subject;
            }
            if (subject != null) {
                log.warn((Object)("Unable to map subject claim (non-String type): " + subject));
            }
        }
        catch (ClaimMetadataException ex) {
            throw new AuthenticationFailedException(OIDCErrorConstants.ErrorMessages.EXECUTING_CLAIM_TRANSFORMATION_FOR_IDP_FAILED.getCode(), String.format(OIDCErrorConstants.ErrorMessages.EXECUTING_CLAIM_TRANSFORMATION_FOR_IDP_FAILED.getMessage(), context.getExternalIdP().getIdPName()), (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Couldn't find the subject claim among id_token claims for IDP: " + context.getExternalIdP().getIdPName()));
        }
        return null;
    }

    private String getUserIdClaimUriInOIDCDialect(String userIdClaimInLocalDialect, String spTenantDomain) throws ClaimMetadataException {
        List externalClaims = OpenIDConnectAuthenticatorDataHolder.getInstance().getClaimMetadataManagementService().getExternalClaims(OIDC_DIALECT, spTenantDomain);
        String userIdClaimUri = null;
        ExternalClaim oidcUserIdClaim = null;
        for (ExternalClaim externalClaim : externalClaims) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Evaluating " + userIdClaimInLocalDialect + " against " + externalClaim.getMappedLocalClaim()));
            }
            if (!userIdClaimInLocalDialect.equals(externalClaim.getMappedLocalClaim())) continue;
            oidcUserIdClaim = externalClaim;
        }
        if (oidcUserIdClaim != null) {
            userIdClaimUri = oidcUserIdClaim.getClaimURI();
        }
        return userIdClaimUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendRequest(String url, String accessToken) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Claim URL: " + url));
        }
        if (url == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = null;){
            URL obj = new URL(url);
            HttpURLConnection urlConnection = (HttpURLConnection)obj.openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.setRequestProperty("Authorization", "Bearer " + accessToken);
            reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            String inputLine = reader.readLine();
            while (inputLine != null) {
                builder.append(inputLine).append("\n");
                inputLine = reader.readLine();
            }
        }
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"UserIdToken")) {
            log.debug((Object)("response: " + builder.toString()));
        }
        return builder.toString();
    }

    private String interpretQueryString(AuthenticationContext context, String queryString, Map<String, String[]> parameters) {
        if (StringUtils.isBlank((String)queryString)) {
            return null;
        }
        if (queryString.contains("$authparam")) {
            queryString = this.getQueryStringWithAuthenticatorParam(context, queryString);
        }
        Matcher matcher = pattern.matcher(queryString);
        while (matcher.find()) {
            String name = matcher.group(1);
            String[] values = parameters.get(name);
            String value = "";
            if (values != null && values.length > 0) {
                value = values[0];
            }
            try {
                value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error while encoding the query param: " + name + " with value: " + value), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("InterpretQueryString name: " + name + ", value: " + value));
            }
            queryString = queryString.replaceAll("\\$\\{" + name + "}", Matcher.quoteReplacement(value));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Output QueryString: " + queryString));
        }
        return queryString;
    }

    private String getEvaluatedQueryString(Map<String, String> paramMap) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        if (paramMap.isEmpty()) {
            return queryString.toString();
        }
        for (Map.Entry<String, String> param : paramMap.entrySet()) {
            queryString.append((Object)param.getKey()).append("=").append(URLEncoder.encode(param.getValue().toString(), StandardCharsets.UTF_8.toString())).append("&");
        }
        return queryString.substring(0, queryString.length() - 1);
    }

    private String getQueryStringWithAuthenticatorParam(AuthenticationContext context, String queryString) {
        Matcher matcher = Pattern.compile("\\$authparam\\{(\\w+)\\}").matcher(queryString);
        String value = "";
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (StringUtils.isNotEmpty((String)((String)this.getRuntimeParams(context).get(paramName)))) {
                value = (String)this.getRuntimeParams(context).get(paramName);
            }
            try {
                value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("InterpretQueryString with authenticator param: " + paramName + ", value: " + value));
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error while encoding the authenticator param: " + paramName + " with value: " + value), (Throwable)e);
            }
            queryString = queryString.replaceAll("\\$authparam\\{" + paramName + "}", Matcher.quoteReplacement(value));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Output QueryString with Authenticator Params : " + queryString));
        }
        return queryString;
    }

    private String getCallbackUrlFromInitialRequestParamMap(AuthenticationContext context) {
        Map paramValueMap = (Map)context.getProperty("oidc:param.map");
        if (MapUtils.isNotEmpty((Map)paramValueMap) && paramValueMap.containsKey("redirect_uri")) {
            return (String)paramValueMap.get("redirect_uri");
        }
        return null;
    }
}

