/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.registration.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="usermgt.registration.component", immediate=true)
public class UserRegistrationDSComponent {
    private static final Log log = LogFactory.getLog(UserRegistrationDSComponent.class);
    private static RegistryService registryService = null;
    private static RealmService realmService = null;

    public static RegistryService getRegistryService() {
        return registryService;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        UserRegistrationDSComponent.registryService = registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        UserRegistrationDSComponent.realmService = realmService;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"UserRegistration bundle is activated ");
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"UserRegistration bundle is deactivated ");
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        UserRegistrationDSComponent.registryService = null;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        UserRegistrationDSComponent.realmService = null;
    }
}

