/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.registration;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.base.IdentityConstants;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.registration.UserRegistrationException;
import org.wso2.carbon.identity.user.registration.dto.PasswordRegExDTO;
import org.wso2.carbon.identity.user.registration.dto.TenantRegistrationConfig;
import org.wso2.carbon.identity.user.registration.dto.UserDTO;
import org.wso2.carbon.identity.user.registration.dto.UserFieldDTO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserRegistrationService {
    private static final Log log = LogFactory.getLog(UserRegistrationService.class);

    public PasswordRegExDTO[] getPasswordRegularExpressions() throws IdentityException {
        UserRealm realm = null;
        realm = IdentityTenantUtil.getRealm(null, null);
        ArrayList<PasswordRegExDTO> passwordRegExList = new ArrayList<PasswordRegExDTO>();
        try {
            for (UserStoreManager manager = realm.getUserStoreManager(); manager != null; manager = manager.getSecondaryUserStoreManager()) {
                String domainName = manager.getRealmConfiguration().getUserStoreProperty("DomainName");
                String regEx = manager.getRealmConfiguration().getUserStoreProperty("PasswordJavaScriptRegEx");
                if (regEx == null || regEx.length() <= 0) continue;
                PasswordRegExDTO passwordRegEx = new PasswordRegExDTO();
                passwordRegEx.setDomainName(domainName);
                passwordRegEx.setRegEx(regEx);
                passwordRegExList.add(passwordRegEx);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            throw IdentityException.error((String)"Error occured while loading password validation regular expressions.");
        }
        return passwordRegExList.toArray(new PasswordRegExDTO[passwordRegExList.size()]);
    }

    public UserFieldDTO[] readUserFieldsForUserRegistration(String dialect) throws IdentityException {
        IdentityClaimManager claimManager = null;
        Claim[] claims = null;
        ArrayList<UserFieldDTO> claimList = null;
        UserRealm realm = null;
        claimManager = IdentityClaimManager.getInstance();
        claims = claimManager.getAllSupportedClaims(dialect, realm = IdentityTenantUtil.getRealm(null, null));
        if (claims == null || claims.length == 0) {
            return new UserFieldDTO[0];
        }
        claimList = new ArrayList<UserFieldDTO>();
        for (Claim claim : claims) {
            if (claim.getDisplayTag() == null || IdentityConstants.PPID_DISPLAY_VALUE.equals(claim.getDisplayTag()) || "http://wso2.org/claims/identity/accountLock".equals(claim.getClaimUri()) || claim.isReadOnly()) continue;
            claimList.add(this.getUserFieldDTO(claim.getClaimUri(), claim.getDisplayTag(), claim.isRequired(), claim.getDisplayOrder(), claim.getRegEx(), claim.isSupportedByDefault()));
        }
        return claimList.toArray(new UserFieldDTO[claimList.size()]);
    }

    public void addUser(UserDTO user) throws Exception {
        UserFieldDTO[] userFieldDTOs = null;
        HashMap<String, String> userClaims = null;
        userFieldDTOs = user.getUserFields();
        userClaims = new HashMap<String, String>();
        if (userFieldDTOs != null) {
            for (UserFieldDTO userFieldDTO : userFieldDTOs) {
                userClaims.put(userFieldDTO.getClaimUri(), userFieldDTO.getFieldValue());
            }
        }
        UserRealm realm = null;
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)user.getUserName());
        String tenantName = MultitenantUtils.getTenantDomain((String)user.getUserName());
        realm = IdentityTenantUtil.getRealm((String)tenantName, null);
        this.addUser(tenantAwareUserName, user.getPassword(), userClaims, null, realm);
    }

    public boolean isAddUserEnabled() throws Exception {
        UserStoreManager userStoreManager;
        UserRealm userRealm = IdentityTenantUtil.getRealm(null, null);
        if (userRealm != null && (userStoreManager = userRealm.getUserStoreManager()) != null) {
            return !userStoreManager.isReadOnly();
        }
        return false;
    }

    public boolean isAddUserWithOpenIDEnabled() throws Exception {
        return false;
    }

    public boolean isAddUserWithInfoCardEnabled() throws Exception {
        return false;
    }

    public boolean isUserExist(String username) throws UserRegistrationException {
        try {
            return CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().isExistingUser(username);
        }
        catch (UserStoreException e) {
            log.error((Object)"Unable to connect to the user store.", (Throwable)e);
            throw new UserRegistrationException("Internal error occurred while connecting to the user store.", e);
        }
    }

    private UserFieldDTO getUserFieldDTO(String claimUri, String displayName, boolean isRequired, int displayOrder, String regex, boolean isSupportedByDefault) {
        UserFieldDTO fieldDTO = null;
        fieldDTO = new UserFieldDTO();
        fieldDTO.setClaimUri(claimUri);
        fieldDTO.setFieldName(displayName);
        fieldDTO.setRequired(isRequired);
        fieldDTO.setDisplayOrder(displayOrder);
        fieldDTO.setSupportedByDefault(isSupportedByDefault);
        fieldDTO.setRegEx(regex);
        return fieldDTO;
    }

    private void addUser(String userName, String password, Map<String, String> claimList, String profileName, UserRealm realm) throws IdentityException {
        UserStoreManager admin = null;
        Permission permission = null;
        try {
            TenantRegistrationConfig tenantConfig = this.getTenantSignUpConfig(realm.getUserStoreManager().getTenantId());
            if (tenantConfig != null && !"".equals(tenantConfig.getSignUpDomain())) {
                int index = userName.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
                userName = index > 0 ? tenantConfig.getSignUpDomain().toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR + userName.substring(index + 1) : tenantConfig.getSignUpDomain().toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR + userName;
            }
            admin = realm.getUserStoreManager();
            if (!this.isUserNameWithAllowedDomainName(userName, realm)) {
                throw IdentityException.error((String)"Domain does not permit self registration");
            }
            admin.addUser(userName, (Object)password, null, claimList, profileName);
            List<String> roleNamesArr = this.getRoleName(userName, tenantConfig);
            if (claimList.get("http://wso2.org/claims/signuprole") != null) {
                if (tenantConfig != null) {
                    roleNamesArr.add(tenantConfig.getSignUpDomain().toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR + claimList.get("http://wso2.org/claims/signuprole"));
                } else {
                    roleNamesArr.add("Internal" + UserCoreConstants.DOMAIN_SEPARATOR + claimList.get("http://wso2.org/claims/signuprole"));
                }
            }
            String[] identityRoleNames = roleNamesArr.toArray(new String[roleNamesArr.size()]);
            for (int i = 0; i < identityRoleNames.length; ++i) {
                this.doAddUser(i, admin, identityRoleNames, userName, permission);
            }
        }
        catch (UserStoreException e) {
            throw IdentityException.error((String)("Error occurred while adding user : " + userName + ". " + e.getMessage()), (Throwable)e);
        }
    }

    private void doAddUser(int i, UserStoreManager admin, String[] identityRoleNames, String userName, Permission permission) throws IdentityException, UserStoreException {
        try {
            if (!admin.isExistingRole(identityRoleNames[i], false)) {
                permission = new Permission("/permission/admin/login", "ui.execute");
                admin.addRole(identityRoleNames[i], new String[]{userName}, (org.wso2.carbon.user.api.Permission[])new Permission[]{permission}, false);
            } else {
                admin.updateUserListOfRole(identityRoleNames[i], new String[0], new String[]{userName});
            }
        }
        catch (UserStoreException e) {
            admin.deleteUser(userName);
            throw IdentityException.error((String)("Error occurred while adding user : " + userName + ". " + e.getMessage()), (Throwable)e);
        }
    }

    private boolean isUserNameWithAllowedDomainName(String userName, UserRealm realm) throws IdentityException {
        int index = userName.indexOf("/");
        if (index > 0) {
            try {
                return !realm.getRealmConfiguration().isRestrictedDomainForSlefSignUp(userName.substring(0, index));
            }
            catch (UserStoreException e) {
                throw IdentityException.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private List<String> getRoleName(String userName, TenantRegistrationConfig tenantConfig) {
        if (tenantConfig != null) {
            ArrayList<String> roleNamesArr = new ArrayList<String>();
            Map<String, Boolean> roles = tenantConfig.getRoles();
            for (Map.Entry<String, Boolean> entry : roles.entrySet()) {
                String roleName = entry.getValue() != false ? tenantConfig.getSignUpDomain().toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR + entry.getKey() : "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + entry.getKey();
                roleNamesArr.add(roleName);
            }
            return roleNamesArr;
        }
        String roleName = IdentityUtil.getProperty((String)"SelfSignUp.SignUpRole.Name");
        boolean externalRole = Boolean.parseBoolean(IdentityUtil.getProperty((String)"SelfSignUp.SignUpRole.External"));
        String domainName = "Internal";
        if (externalRole) {
            domainName = IdentityUtil.extractDomainFromName((String)userName);
        }
        if (roleName == null || roleName.trim().length() == 0) {
            roleName = "identity";
        }
        if (domainName != null && domainName.trim().length() > 0) {
            roleName = domainName.toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR + roleName;
        }
        return new ArrayList<String>(Arrays.asList(roleName));
    }

    private TenantRegistrationConfig getTenantSignUpConfig(int tenantId) throws IdentityException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            Registry registry = (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            if (registry.resourceExists("/repository/identity/sign-up-config")) {
                Resource resource = registry.get("/repository/identity/sign-up-config");
                DocumentBuilder builder = this.getSecuredDocumentBuilder();
                String configXml = new String((byte[])resource.getContent());
                InputSource configInputSource = new InputSource();
                configInputSource.setCharacterStream(new StringReader(configXml.trim()));
                Document doc = builder.parse(configInputSource);
                NodeList nodes = doc.getElementsByTagName("SelfSignUp");
                if (nodes.getLength() > 0) {
                    TenantRegistrationConfig config = new TenantRegistrationConfig();
                    config.setSignUpDomain(((Element)nodes.item(0)).getElementsByTagName("SignUpDomain").item(0).getTextContent());
                    NodeList rolesEl = ((Element)nodes.item(0)).getElementsByTagName("SignUpRole");
                    for (int i = 0; i < rolesEl.getLength(); ++i) {
                        Element tmpEl = (Element)rolesEl.item(i);
                        String tmpRole = tmpEl.getElementsByTagName("RoleName").item(0).getTextContent();
                        boolean tmpIsExternal = Boolean.parseBoolean(tmpEl.getElementsByTagName("IsExternalRole").item(0).getTextContent());
                        config.getRoles().put(tmpRole, tmpIsExternal);
                    }
                    TenantRegistrationConfig tenantRegistrationConfig = config;
                    return tenantRegistrationConfig;
                }
                TenantRegistrationConfig tenantRegistrationConfig = null;
                return tenantRegistrationConfig;
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)("Error retrieving sign up config from registry " + e.getMessage()), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw IdentityException.error((String)("Error parsing tenant sign up configuration " + e.getMessage()), (Throwable)e);
        }
        catch (SAXException e) {
            throw IdentityException.error((String)("Error parsing tenant sign up configuration " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw IdentityException.error((String)("Error parsing tenant sign up configuration " + e.getMessage()), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return null;
    }

    private DocumentBuilder getSecuredDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }
}

