/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class ConsentDBInitializer {
    private static final String DB_CHECK_SQL = "SELECT * FROM CM_PURPOSE_CATEGORY";
    private static final Log log = LogFactory.getLog(ConsentDBInitializer.class);
    private Statement statement;
    private DataSource dataSource;
    private String delimiter = ";";

    public ConsentDBInitializer(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static String getDatabaseType(Connection conn) {
        String type;
        block13: {
            type = null;
            try {
                if (conn == null || conn.isClosed()) break block13;
                DatabaseMetaData metaData = conn.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                if (databaseProductName.matches("(?i).*hsql.*")) {
                    type = "hsql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*derby.*")) {
                    type = "derby";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*mysql.*")) {
                    type = "mysql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*mariadb.*")) {
                    type = "mariadb";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*oracle.*")) {
                    type = "oracle";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*microsoft.*")) {
                    type = "mssql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*h2.*")) {
                    type = "h2";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*db2.*")) {
                    type = "db2";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*postgresql.*")) {
                    type = "postgresql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*openedge.*")) {
                    type = "openedge";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*informix.*")) {
                    type = "informix";
                    break block13;
                }
                throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_DB, databaseProductName);
            }
            catch (SQLException e) {
                throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_GET_DB_TYPE, null, e);
            }
        }
        return type;
    }

    private boolean checkStringBufferEndsWith(StringBuffer buffer, String suffix) {
        if (suffix.length() > buffer.length()) {
            return false;
        }
        int bufferIndex = buffer.length() - 1;
        for (int endIndex = suffix.length() - 1; endIndex >= 0; --endIndex) {
            if (buffer.charAt(bufferIndex) != suffix.charAt(endIndex)) {
                return false;
            }
            --bufferIndex;
        }
        return true;
    }

    public void createConsentDatabase() {
        if (!this.isDatabaseStructureCreated()) {
            Connection conn = null;
            try {
                conn = this.dataSource.getConnection();
                conn.setAutoCommit(false);
                this.statement = conn.createStatement();
                this.executeSQLScript();
                conn.commit();
                log.debug((Object)"Consent tables are created successfully.");
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_ROLL_BACK_CONNECTION, null, e1);
                }
                throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_CREATE_DB_TABLES, null, e);
            }
            finally {
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Failed to close statement.", (Throwable)e);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Failed to close database connection.", (Throwable)e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consent Database already exists. Not creating a new database.");
        }
    }

    private boolean isDatabaseStructureCreated() {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            if (log.isDebugEnabled()) {
                log.debug((Object)"Running a query to test the database tables existence");
            }
            try (ResultSet ignored = statement.executeQuery(DB_CHECK_SQL);){
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Consent database already exists.");
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private void executeSQLScript() {
        String databaseType;
        try (Connection connection = this.dataSource.getConnection();){
            databaseType = ConsentDBInitializer.getDatabaseType(connection);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Identified database type from data source as: " + databaseType));
            }
        }
        catch (SQLException e) {
            throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_DATABASE_CONNECTION, null, e);
        }
        boolean keepFormat = false;
        if ("oracle".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("db2".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("openedge".equals(databaseType)) {
            this.delimiter = "/";
            keepFormat = true;
        }
        String dbScriptLocation = this.getDbScriptLocation(databaseType);
        StringBuffer sql = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new FileReader(dbScriptLocation));){
            String line;
            while ((line = reader.readLine()) != null) {
                String token;
                StringTokenizer st;
                line = line.trim();
                if (!keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
                sql.append(keepFormat ? "\n" : " ").append(line);
                if (!keepFormat && line.contains("--")) {
                    sql.append("\n");
                }
                if (!this.checkStringBufferEndsWith(sql, this.delimiter)) continue;
                this.executeSQL(sql.substring(0, sql.length() - this.delimiter.length()));
                sql.replace(0, sql.length(), "");
            }
            if (sql.length() > 0) {
                this.executeSQL(sql.toString());
            }
        }
        catch (FileNotFoundException e) {
            throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_NO_SQL_SCRIPT, dbScriptLocation, e);
        }
        catch (IOException e) {
            throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_RUN_SQL_SCRIPT, null, e);
        }
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = databaseType + ".sql";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading database script from: " + scriptName));
        }
        String carbonHome = CarbonUtils.getCarbonHome();
        return Paths.get(carbonHome, "dbscripts", "consent", scriptName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(String sql) {
        block27: {
            if (StringUtils.isBlank((String)sql)) {
                return;
            }
            ResultSet resultSet = null;
            Connection conn = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing SQL: " + sql));
                }
                int updateCountTotal = 0;
                boolean ret = this.statement.execute(sql);
                int updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
                do {
                    if (!ret && updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                    if (!(ret = this.statement.getMoreResults())) continue;
                    updateCount = this.statement.getUpdateCount();
                    resultSet = this.statement.getResultSet();
                } while (ret);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sql + " : " + updateCountTotal + " rows affected."));
                }
                conn = this.dataSource.getConnection();
                for (SQLWarning warning = conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.debug((Object)(warning + " sql warning."));
                }
                conn.clearWarnings();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0Y32") || e.getSQLState().equals("42710")) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)"Table Already Exists. Hence, skipping table creation.");
                    }
                    break block27;
                }
                throw ConsentUtils.handleRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_RUN_SQL_QUERY, sql, e);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing result set.", (Throwable)e);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing sql connection.", (Throwable)e);
                    }
                }
            }
        }
    }
}

