/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementRuntimeException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ConsentConfigParser {
    private static final String DATA_SOURCE_NAME = "DataSource.Name";
    private static Map<String, Object> configuration = new HashMap<String, Object>();
    private static SecretResolver secretResolver;
    private static final Log log;
    private OMElement rootElement;

    public ConsentConfigParser() {
        this.buildConfiguration();
    }

    public Map<String, Object> getConfiguration() {
        return configuration;
    }

    public String getConsentDataSource() {
        return configuration.get(DATA_SOURCE_NAME) == null ? null : configuration.get(DATA_SOURCE_NAME).toString();
    }

    private void buildConfiguration() {
        InputStream inStream = null;
        try {
            String configurationFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "consent-mgt-config.xml";
            File consentConfigXml = new File(configurationFilePath);
            if (consentConfigXml.exists()) {
                inStream = new FileInputStream(consentConfigXml);
            }
            if (inStream == null) {
                String message = "Consent configuration not found";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new FileNotFoundException(message);
            }
            StAXOMBuilder builder = new StAXOMBuilder(inStream);
            this.rootElement = builder.getDocumentElement();
            Stack<String> nameStack = new Stack<String>();
            secretResolver = SecretResolverFactory.create((OMElement)this.rootElement, (boolean)true);
            this.readChildElements(this.rootElement, nameStack);
        }
        catch (IOException | XMLStreamException e) {
            throw new ConsentManagementRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_BUILDING_CONFIG.getMessage(), ConsentConstants.ErrorMessages.ERROR_CODE_BUILDING_CONFIG.getCode(), e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error closing the input stream for consent-mgt-config.xml", (Throwable)e);
            }
        }
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                Object currentObject = configuration.get(key);
                String value = this.replaceSystemProperty(element.getText());
                if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(key)) {
                    value = secretResolver.resolve(key);
                }
                if (currentObject == null) {
                    configuration.put(key, value);
                } else if (currentObject instanceof ArrayList) {
                    ArrayList list = (ArrayList)currentObject;
                    if (!list.contains(value)) {
                        list.add(value);
                        configuration.put(key, list);
                    }
                } else if (!value.equals(currentObject)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(currentObject);
                    arrayList.add(value);
                    configuration.put(key, arrayList);
                }
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    private String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        StringBuilder textBuilder = new StringBuilder(text);
        while (indexOfStartingChars < textBuilder.indexOf("${") && (indexOfStartingChars = textBuilder.indexOf("${")) != -1 && (indexOfClosingBrace = textBuilder.indexOf("}")) != -1) {
            String sysProp = textBuilder.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                textBuilder = new StringBuilder(textBuilder.substring(0, indexOfStartingChars) + propValue + textBuilder.substring(indexOfClosingBrace + 1));
            }
            if (!sysProp.equals("carbon.home") || !System.getProperty("carbon.home").equals(".")) continue;
            textBuilder.insert(0, new File(".").getAbsolutePath() + File.separator);
        }
        text = textBuilder.toString();
        return text;
    }

    public OMElement getConfigElement(String localPart) {
        return this.rootElement.getFirstChildWithName(new QName("http://wso2.org/carbon/consent/management", localPart));
    }

    public QName getQNameWithConsentNS(String localPart) {
        return new QName("http://wso2.org/carbon/consent/management", localPart);
    }

    static {
        log = LogFactory.getLog(ConsentConfigParser.class);
    }
}

