/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.model;

import java.util.HashMap;
import java.util.List;
import org.wso2.carbon.consent.mgt.core.connector.ConsentMgtInterceptor;
import org.wso2.carbon.consent.mgt.core.model.ConsentMessage;
import org.wso2.carbon.consent.mgt.core.model.ConsentMessageContext;
import org.wso2.carbon.consent.mgt.core.model.OperationDelegate;
import org.wso2.carbon.consent.mgt.core.model.PropertyBinder;
import org.wso2.carbon.consent.mgt.core.util.LambdaExceptionUtils;

public class ConsentInterceptorTemplate<T, X extends Exception> {
    private List<ConsentMgtInterceptor> consentMgtInterceptors;
    private ConsentMessageContext context;
    private T result;

    public ConsentInterceptorTemplate(List<ConsentMgtInterceptor> consentMgtInterceptors, ConsentMessageContext context) {
        this.consentMgtInterceptors = consentMgtInterceptors;
        this.context = context;
    }

    public ConsentInterceptorTemplate<T, X> executeWith(OperationDelegate<T> delegate) throws X {
        this.result = delegate.execute();
        return this;
    }

    public ConsentInterceptorTemplate<T, X> intercept(String operation, PropertyBinder binder) throws X {
        HashMap<String, Object> operationProperties = new HashMap<String, Object>();
        binder.bind(operationProperties);
        if (this.result != null) {
            operationProperties.put("RESULT", this.result);
        }
        this.consentMgtInterceptors.forEach(LambdaExceptionUtils.rethrowConsumer(interceptor -> interceptor.intercept(new ConsentMessage(operation, operationProperties, this.context))));
        return this;
    }

    public T getResult() {
        return this.result;
    }
}

