/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.dao.impl;

import java.util.List;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.dao.PIICategoryDAO;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementServerException;
import org.wso2.carbon.consent.mgt.core.model.PIICategory;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.consent.mgt.core.util.JdbcUtils;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;

public class PIICategoryDAOImpl
implements PIICategoryDAO {
    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public PIICategory addPIICategory(PIICategory piiCategory) throws ConsentManagementException {
        int insertedId;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            insertedId = jdbcTemplate.executeInsert("INSERT INTO CM_PII_CATEGORY (NAME, DESCRIPTION,IS_SENSITIVE, TENANT_ID, DISPLAY_NAME) VALUES (?,?,?,?,?)", preparedStatement -> {
                preparedStatement.setString(1, piiCategory.getName());
                preparedStatement.setString(2, piiCategory.getDescription());
                preparedStatement.setInt(3, piiCategory.getSensitive() != false ? 1 : 0);
                preparedStatement.setInt(4, piiCategory.getTenantId());
                preparedStatement.setString(5, piiCategory.getDisplayName());
            }, (Object)piiCategory, true);
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_PII_CATEGORY, piiCategory.getName(), e);
        }
        PIICategory purposeResult = new PIICategory(insertedId, piiCategory.getName(), piiCategory.getDescription(), piiCategory.getSensitive(), piiCategory.getTenantId(), piiCategory.getDisplayName());
        return purposeResult;
    }

    @Override
    public PIICategory getPIICategoryById(int id) throws ConsentManagementException {
        PIICategory piiCategory;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            piiCategory = (PIICategory)jdbcTemplate.fetchSingleRecord("SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE, TENANT_ID, DISPLAY_NAME FROM CM_PII_CATEGORY WHERE ID = ?", (resultSet, rowNumber) -> new PIICategory(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4) == 1, resultSet.getInt(5), resultSet.getString(6)), preparedStatement -> preparedStatement.setInt(1, id));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PII_CATEGORY_BY_ID, String.valueOf(id), e);
        }
        return piiCategory;
    }

    @Override
    public List<PIICategory> listPIICategories(int limit, int offset, int tenantId) throws ConsentManagementException {
        List piiCategories;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            int initialOffset;
            String query;
            if (JdbcUtils.isH2MySqlOrPostgresDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE, TENANT_ID,DISPLAY_NAME FROM CM_PII_CATEGORY WHERE TENANT_ID = ? ORDER BY ID ASC LIMIT ? OFFSET ?";
            } else if (JdbcUtils.isDB2DB()) {
                query = "SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE,TENANT_ID,DISPLAY_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY ID) AS rn, p.*  FROM CM_PII_CATEGORY AS p) WHERE TENANT_ID =? AND rn BETWEEN ? AND ?";
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            } else if (JdbcUtils.isMSSqlDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE,TENANT_ID,DISPLAY_NAME FROM (SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE,TENANT_ID,DISPLAY_NAME, ROW_NUMBER() OVER (ORDER BY ID) AS RowNum FROM CM_PII_CATEGORY) AS P WHERE P.TENANT_ID = ? AND P.RowNum BETWEEN ? AND ?";
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
            } else if (JdbcUtils.isInformixDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE, TENANT_ID,DISPLAY_NAME FROM CM_PII_CATEGORY WHERE TENANT_ID = ? ORDER BY ID ASC LIMIT ? OFFSET ?";
            } else {
                query = "SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE,TENANT_ID,DISPLAY_NAME FROM (SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE,TENANT_ID,DISPLAY_NAME, rownum AS rnum FROM (SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE, TENANT_ID,DISPLAY_NAME FROM CM_PII_CATEGORY ORDER BY ID) WHERE TENANT_ID =? AND rownum <= ?) WHERE  rnum > ?";
                limit = offset + limit;
            }
            int finalLimit = limit;
            int finalOffset = offset;
            piiCategories = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new PIICategory(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4) == 1, resultSet.getInt(5), resultSet.getString(6)), preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setInt(2, finalLimit);
                preparedStatement.setInt(3, finalOffset);
            });
        }
        catch (DataAccessException e) {
            throw new ConsentManagementServerException(String.format(ConsentConstants.ErrorMessages.ERROR_CODE_LIST_PII_CATEGORY.getMessage(), limit, offset), ConsentConstants.ErrorMessages.ERROR_CODE_LIST_PII_CATEGORY.getCode(), e);
        }
        return piiCategories;
    }

    @Override
    public int deletePIICategory(int id) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_PII_CATEGORY WHERE ID = ?", preparedStatement -> preparedStatement.setInt(1, id));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_PII_CATEGORY, String.valueOf(id), e);
        }
        return id;
    }

    @Override
    public void deletePIICategoriesByTenantId(int tenantId) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_PII_CATEGORY WHERE TENANT_ID = ?", preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_PII_CATEGORIES_BY_TENANT_ID, String.valueOf(tenantId), e);
        }
    }

    @Override
    public PIICategory getPIICategoryByName(String name, int tenantId) throws ConsentManagementException {
        PIICategory piiCategory;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            piiCategory = (PIICategory)jdbcTemplate.fetchSingleRecord("SELECT ID, NAME, DESCRIPTION, IS_SENSITIVE, TENANT_ID,DISPLAY_NAME FROM CM_PII_CATEGORY WHERE NAME = ? AND TENANT_ID = ? ", (resultSet, rowNumber) -> new PIICategory(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4) == 1, resultSet.getInt(5), resultSet.getString(6)), preparedStatement -> {
                preparedStatement.setString(1, name);
                preparedStatement.setInt(2, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PII_CATEGORY_BY_NAME, name, e);
        }
        return piiCategory;
    }

    @Override
    public boolean isPIICategoryUsed(int id) throws ConsentManagementException {
        try {
            return this.isPiiCategoryUsedInPurpose(id) || this.isPiiCategoryUsedInSP(id);
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_SP_PURPOSE_ASSOCIATED_WITH_PIICATERY, String.valueOf(id), e);
        }
    }

    private boolean isPiiCategoryUsedInPurpose(int id) throws DataAccessException {
        return this.isAssociationExists(id, "SELECT COUNT(*) FROM CM_PURPOSE_PII_CAT_ASSOC WHERE CM_PII_CATEGORY_ID=?");
    }

    private boolean isPiiCategoryUsedInSP(int id) throws DataAccessException {
        return this.isAssociationExists(id, "SELECT COUNT(*) FROM CM_SP_PURPOSE_PII_CAT_ASSOC WHERE PII_CATEGORY_ID=?");
    }

    private boolean isAssociationExists(int id, String query) throws DataAccessException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        Integer count = (Integer)jdbcTemplate.fetchSingleRecord(query, (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> preparedStatement.setInt(1, id));
        if (count == null) {
            return false;
        }
        return count > 0;
    }
}

