/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.dto.UserDTO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    private Utils() {
    }

    public static UserDTO processUserId(String userId) throws IdentityException {
        if (userId == null || userId.trim().length() < 1) {
            throw IdentityException.error((String)"Can not proceed with out a user id");
        }
        UserDTO userDTO = new UserDTO(userId);
        if (!IdentityMgtConfig.getInstance().isSaasEnabled()) {
            Utils.validateTenant(userDTO);
        }
        userDTO.setTenantId(Utils.getTenantId(userDTO.getTenantDomain()));
        return userDTO;
    }

    public static void validateTenant(UserDTO user) throws IdentityException {
        if (user.getTenantDomain() != null && !user.getTenantDomain().isEmpty()) {
            if (!user.getTenantDomain().equals(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain())) {
                throw IdentityException.error((String)"Failed access to unauthorized tenant domain");
            }
            user.setTenantId(Utils.getTenantId(user.getTenantDomain()));
        }
    }

    public static int getVerifiedChallenges(UserDTO userDTO) throws IdentityException {
        int noOfChallenges = 0;
        try {
            Resource resource;
            String property;
            UserRegistry registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(-1234);
            String identityKeyMgtPath = "/repository/components/org.wso2.carbon.identity.mgt/challenges/" + userDTO.getUserId() + "/" + userDTO.getUserId();
            if (registry.resourceExists(identityKeyMgtPath) && (property = (resource = registry.get(identityKeyMgtPath)).getProperty("verifiedChallenges")) != null) {
                return Integer.parseInt(property);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while processing userKey", (Throwable)e);
        }
        return noOfChallenges;
    }

    public static int getTenantId(String domain) throws IdentityException {
        int tenantId;
        TenantManager tenantManager = IdentityMgtServiceComponent.getRealmService().getTenantManager();
        if ("carbon.super".equals(domain)) {
            tenantId = -1234;
            if (log.isDebugEnabled()) {
                String msg = "Domain is not defined implicitly. So it is Super Tenant domain.";
                log.debug((Object)msg);
            }
        } else {
            try {
                tenantId = tenantManager.getTenantId(domain);
                if (tenantId < 1 && tenantId != -1234) {
                    String msg = "This action can not be performed by the users in non-existing domains.";
                    log.error((Object)msg);
                    throw IdentityException.error((String)msg);
                }
            }
            catch (UserStoreException e) {
                String msg = "Error in retrieving tenant id of tenant domain: " + domain + ".";
                log.error((Object)msg, (Throwable)e);
                throw IdentityException.error((String)msg, (Throwable)e);
            }
        }
        return tenantId;
    }

    public static String getClaimFromUserStoreManager(String userName, int tenantId, String claim) throws IdentityException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        RealmService realmService = IdentityMgtServiceComponent.getRealmService();
        String claimValue = "";
        try {
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (Exception e) {
            String msg = "Error retrieving the user store manager for tenant id : " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
        try {
            Map claimsMap;
            if (userStoreManager != null && (claimsMap = userStoreManager.getUserClaimValues(userName, new String[]{claim}, "default")) != null && !claimsMap.isEmpty()) {
                claimValue = (String)claimsMap.get(claim);
            }
            return claimValue;
        }
        catch (Exception e) {
            String msg = "Unable to retrieve the claim for user : " + userName;
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
    }

    public static Map<String, String> getClaimsFromUserStoreManager(String userName, int tenantId, String[] claims) throws IdentityException {
        Map<String, String> claimValues = new HashMap<String, String>();
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        RealmService realmService = IdentityMgtServiceComponent.getRealmService();
        try {
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (UserStoreException e) {
            throw IdentityException.error((String)("Error retrieving the user store manager for tenant id : " + tenantId), (Throwable)e);
        }
        try {
            if (userStoreManager != null) {
                claimValues = userStoreManager.getUserClaimValues(userName, claims, "default");
            }
        }
        catch (Exception e) {
            throw IdentityException.error((String)("Unable to retrieve the claim for user : " + userName), (Throwable)e);
        }
        return claimValues;
    }

    public static String getEmailAddressForUser(String userName, int tenantId) {
        String email = null;
        try {
            Tenant tenant;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrieving email address from user profile.");
            }
            if ((tenant = IdentityMgtServiceComponent.getRealmService().getTenantManager().getTenant(tenantId)) != null && tenant.getAdminName().equals(userName)) {
                email = tenant.getEmail();
            }
            if (email == null || email.trim().length() < 1) {
                email = Utils.getClaimFromUserStoreManager(userName, tenantId, "http://wso2.org/claims/emailaddress");
            }
            if ((email == null || email.trim().length() < 1) && MultitenantUtils.isEmailUserName()) {
                email = UserCoreUtil.removeDomainFromName((String)userName);
            }
        }
        catch (Exception e) {
            String msg = "Unable to retrieve an email address associated with the given user : " + userName;
            log.warn((Object)msg, (Throwable)e);
        }
        return email;
    }

    public static boolean updatePassword(String userId, int tenantId, String password) throws IdentityException {
        String tenantDomain = null;
        if (userId == null || userId.trim().length() < 1 || password == null || password.trim().length() < 1) {
            String msg = "Unable to find the required information for updating password";
            log.error((Object)msg);
            throw IdentityException.error((String)msg);
        }
        try {
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            userStoreManager.updateCredentialByAdmin(userId, (Object)password);
            if (log.isDebugEnabled()) {
                String msg = "Password is updated for  user: " + userId;
                log.debug((Object)msg);
            }
            return true;
        }
        catch (UserStoreException e) {
            String msg = "Error in changing the password, user name: " + userId + "  domain: " + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
    }

    public static String doHash(String value) throws UserStoreException {
        try {
            String digsestFunction = "SHA-256";
            MessageDigest dgst = MessageDigest.getInstance(digsestFunction);
            byte[] byteValue = dgst.digest(value.getBytes());
            return Base64.encode((byte[])byteValue);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setClaimInUserStoreManager(String userName, int tenantId, String claim, String value) throws IdentityException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        RealmService realmService = IdentityMgtServiceComponent.getRealmService();
        try {
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (Exception e) {
            String msg = "Error retrieving the user store manager for the tenant";
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
        try {
            String oldValue;
            if (!(userStoreManager == null || (oldValue = userStoreManager.getUserClaimValue(userName, claim, null)) != null && oldValue.equals(value))) {
                HashMap<String, String> claimMap = new HashMap<String, String>();
                claimMap.put(claim, value);
                userStoreManager.setUserClaimValues(userName, claimMap, "default");
            }
        }
        catch (Exception e) {
            String msg = "Unable to set the claim for user : " + userName;
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
    }

    public static String getUserStoreDomainName(String userName) {
        int index = userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        String userDomain = index >= 0 ? userName.substring(0, index) : "PRIMARY";
        return userDomain;
    }

    public static String[] getChallengeUris() {
        return new String[]{"http://wso2.org/claims/challengeQuestion1", "http://wso2.org/claims/challengeQuestion2"};
    }

    public static Policy getSecurityPolicy() {
        String policyString = "        <wsp:Policy wsu:Id=\"UTOverTransport\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"\n                    xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">\n          <wsp:ExactlyOne>\n            <wsp:All>\n              <sp:TransportBinding xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">\n                <wsp:Policy>\n                  <sp:TransportToken>\n                    <wsp:Policy>\n                      <sp:HttpsToken RequireClientCertificate=\"true\"/>\n                    </wsp:Policy>\n                  </sp:TransportToken>\n                  <sp:AlgorithmSuite>\n                    <wsp:Policy>\n                      <sp:Basic256/>\n                    </wsp:Policy>\n                  </sp:AlgorithmSuite>\n                  <sp:Layout>\n                    <wsp:Policy>\n                      <sp:Lax/>\n                    </wsp:Policy>\n                  </sp:Layout>\n                  <sp:IncludeTimestamp/>\n                </wsp:Policy>\n              </sp:TransportBinding>\n            </wsp:All>\n          </wsp:ExactlyOne>\n        </wsp:Policy>";
        return PolicyEngine.getPolicy((InputStream)new ByteArrayInputStream(policyString.getBytes()));
    }
}

