/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtEventListener;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.beans.UserIdentityMgtBean;
import org.wso2.carbon.identity.mgt.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.constants.IdentityMgtConstants;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionDTO;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionIdsDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesCollectionDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesDTO;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimDTO;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimsDO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDataDO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.store.JDBCUserRecoveryDataStore;
import org.wso2.carbon.identity.mgt.store.UserIdentityDataStore;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserIdentityManagementUtil {
    private static final String EXISTING_USER = "Username already exists in the system";
    private static final String INVALID_CLAIM_URL = "InvalidClaimUrl";
    private static final String EXISTING_ROLE = "RoleExisting";
    private static final String READ_ONLY_STORE = "User store is read only";
    private static final String READ_ONLY_PRIMARY_STORE = "ReadOnlyPrimaryUserStoreManager";
    private static final String INVALID_ROLE = "InvalidRole";
    private static final String ANONYMOUS_USER = "AnonymousUser";
    private static final String INVALID_OPERATION = "InvalidOperation";
    private static final String NO_READ_WRITE_PERMISSIONS = "NoReadWritePermission";
    private static final String PASSWORD_INVALID = "Credential must be a non null string";
    private static final String SHARED_USER_ROLES = "SharedUserRoles";
    private static final String REMOVE_ADMIN_USER = "RemoveAdminUser";
    private static final String LOGGED_IN_USER = "LoggedInUser";
    private static final String ADMIN_USER = "AdminUser";
    private static final String INVALID_USER_NAME = "InvalidUserName";
    private static final String PASSWORD_POLICY_VIOLATION = "Password at least should have";
    private static VerificationBean vBean = new VerificationBean();
    private static ChallengeQuestionIdsDTO idsDTO = new ChallengeQuestionIdsDTO();
    private static UserChallengesDTO userChallengesDTO = new UserChallengesDTO();
    private static UserChallengesCollectionDTO userChallengesCollectionDTO = new UserChallengesCollectionDTO();
    private static Log log = LogFactory.getLog(UserIdentityManagementUtil.class);

    private UserIdentityManagementUtil() {
    }

    public static UserRecoveryDTO getUserIdentityRecoveryData(String userName, UserStoreManager userStoreManager, int tenantId) throws IdentityException {
        UserRecoveryDTO registrationDTO = new UserRecoveryDTO(userName);
        return registrationDTO;
    }

    public static void lockUserAccount(String userName, UserStoreManager userStoreManager) throws IdentityException {
        if (!UserIdentityManagementUtil.isIdentityMgtListenerEnable()) {
            throw IdentityException.error((String)"Cannot lock account, IdentityMgtEventListener is not enabled.");
        }
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        try {
            if (!userStoreManager.isExistingUser(userName)) {
                log.error((Object)("User " + userName + " does not exist in tenant " + userStoreManager.getTenantId()));
                throw IdentityException.error((String)("No user account found for user " + userName));
            }
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put("http://wso2.org/claims/identity/accountLocked", "true");
            claims.put("http://wso2.org/claims/identity/unlockTime", "0");
            userStoreManager.setUserClaimValues(userName, claims, null);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while reading/storing user identity data", (Throwable)e);
            throw IdentityException.error((String)("Error while lock user account : " + userName));
        }
    }

    public static void disableUserAccount(String userName, UserStoreManager userStoreManager) throws IdentityException {
        if (!UserIdentityManagementUtil.isIdentityMgtListenerEnable()) {
            throw IdentityException.error((String)"Cannot lock account, IdentityMgtEventListener is not enabled.");
        }
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        try {
            if (!userStoreManager.isExistingUser(userName)) {
                log.error((Object)("User " + userName + " does not exist in tenant " + userStoreManager.getTenantId()));
                throw IdentityException.error((String)("No user account found for user " + userName + "to disable"));
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while reading user identity data", (Throwable)e);
            throw IdentityException.error((String)("Error while disabling user account : " + userName));
        }
        UserIdentityDataStore store = IdentityMgtConfig.getInstance().getIdentityDataStore();
        UserIdentityClaimsDO userIdentityDO = store.load(UserCoreUtil.removeDomainFromName((String)userName), userStoreManager);
        if (userIdentityDO == null) {
            throw IdentityException.error((String)("No user account found for user " + userName));
        }
        userIdentityDO.setAccountDisabled(true);
        store.store(userIdentityDO, userStoreManager);
    }

    public static void enableUserAccount(String userName, UserStoreManager userStoreManager) throws IdentityException {
        if (!UserIdentityManagementUtil.isIdentityMgtListenerEnable()) {
            throw IdentityException.error((String)"Cannot enable account, IdentityMgtEventListener is not enabled.");
        }
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        try {
            if (!userStoreManager.isExistingUser(userName)) {
                log.error((Object)("User " + userName + " does not exist in tenant " + userStoreManager.getTenantId()));
                throw IdentityException.error((String)("No user account found for user " + userName + "to enable"));
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while reading user identity data", (Throwable)e);
            throw IdentityException.error((String)("Error while enabling user account " + userName));
        }
        UserIdentityDataStore store = IdentityMgtConfig.getInstance().getIdentityDataStore();
        UserIdentityClaimsDO userIdentityDO = store.load(UserCoreUtil.removeDomainFromName((String)userName), userStoreManager);
        if (userIdentityDO == null) {
            throw IdentityException.error((String)("No user account found for user " + userName));
        }
        userIdentityDO.setAccountDisabled(false);
        store.store(userIdentityDO, userStoreManager);
    }

    private static boolean isIdentityMgtListenerEnable() {
        IdentityEventListenerConfig identityEventListenerConfig;
        String listenerClassName = IdentityMgtConfig.getInstance().getProperty("Identity.Listener.Class");
        if (StringUtils.isBlank((String)listenerClassName)) {
            listenerClassName = IdentityMgtEventListener.class.getName();
        }
        if ((identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)UserOperationEventListener.class.getName(), (String)listenerClassName)) == null) {
            return true;
        }
        if (StringUtils.isNotBlank((String)identityEventListenerConfig.getEnable())) {
            return Boolean.parseBoolean(identityEventListenerConfig.getEnable());
        }
        return true;
    }

    public static void unlockUserAccount(String userName, UserStoreManager userStoreManager) throws IdentityException {
        if (!UserIdentityManagementUtil.isIdentityMgtListenerEnable()) {
            throw IdentityException.error((String)"Cannot unlock account, IdentityMgtEventListener is not enabled.");
        }
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        try {
            if (!userStoreManager.isExistingUser(userName)) {
                log.error((Object)("User " + userName + " does not exist in tenant " + userStoreManager.getTenantId()));
                throw IdentityException.error((String)("No user account found for user " + userName));
            }
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put("http://wso2.org/claims/identity/accountLocked", "false");
            claims.put("http://wso2.org/claims/identity/unlockTime", "0");
            userStoreManager.setUserClaimValues(userName, claims, null);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while reading/storing user identity data", (Throwable)e);
            throw IdentityException.error((String)("Error while unlock user account " + userName));
        }
    }

    public static String[] getPrimaryQuestions(int tenantId) throws IdentityException {
        JDBCUserRecoveryDataStore store = new JDBCUserRecoveryDataStore();
        UserRecoveryDataDO[] metadata = store.load("TENANT", tenantId);
        if (metadata.length < 1) {
            return new String[0];
        }
        ArrayList validSecurityQuestions = new ArrayList();
        String[] questionsList = new String[validSecurityQuestions.size()];
        return validSecurityQuestions.toArray(questionsList);
    }

    public static void addPrimaryQuestions(String[] primarySecurityQuestion, int tenantId) throws IdentityException {
        JDBCUserRecoveryDataStore store = new JDBCUserRecoveryDataStore();
        UserRecoveryDataDO[] metadata = new UserRecoveryDataDO[primarySecurityQuestion.length];
        int i = 0;
        for (String secQuestion : primarySecurityQuestion) {
            if (!secQuestion.contains("http://wso2.org/claims/identity/challengeQuestion")) {
                throw IdentityException.error((String)"One or more security questions does not contain the namespace http://wso2.org/claims/identity/challengeQuestion");
            }
            metadata[i++] = new UserRecoveryDataDO("TENANT", tenantId, "PRIMARAY_SEC_QUESTION", secQuestion);
        }
        store.store(metadata);
    }

    public static void removePrimaryQuestions(String[] primarySecurityQuestion, int tenantId) throws IdentityException {
        UserRecoveryDataDO[] metadata = new UserRecoveryDataDO[primarySecurityQuestion.length];
        int i = 0;
        for (String secQuestion : primarySecurityQuestion) {
            if (!secQuestion.contains("http://wso2.org/claims/identity/challengeQuestion")) {
                throw IdentityException.error((String)"One or more security questions does not contain the namespace http://wso2.org/claims/identity/challengeQuestion");
            }
            metadata[i++] = new UserRecoveryDataDO("TENANT", tenantId, "PRIMARAY_SEC_QUESTION", secQuestion);
        }
    }

    public static void updateUserSecurityQuestions(String userName, UserIdentityClaimDTO[] securityQuestion, UserStoreManager userStoreManager) throws IdentityException {
        UserIdentityDataStore store = IdentityMgtConfig.getInstance().getIdentityDataStore();
        UserIdentityClaimsDO userIdentityDO = store.load(userName, userStoreManager);
        if (userIdentityDO == null) {
            throw IdentityException.error((String)("No user account found for user " + userName));
        }
        userIdentityDO.updateUserSequeiryQuestions(securityQuestion);
        store.store(userIdentityDO, userStoreManager);
    }

    public static UserIdentityClaimDTO[] getUserSecurityQuestions(String userName, UserStoreManager userStoreManager) throws IdentityMgtServiceException {
        UserIdentityDataStore store = IdentityMgtConfig.getInstance().getIdentityDataStore();
        UserIdentityClaimsDO userIdentityDO = store.load(userName, userStoreManager);
        if (userIdentityDO != null) {
            return userIdentityDO.getUserSequeiryQuestions();
        }
        throw new IdentityMgtServiceException("No user account found for user " + userName);
    }

    public static void updateUserIdentityClaims(String userName, UserStoreManager userStoreManager, UserIdentityClaimDTO[] userIdentityRecoveryData) throws IdentityException {
        UserIdentityDataStore store = IdentityMgtConfig.getInstance().getIdentityDataStore();
        UserIdentityClaimsDO userIdentityDO = store.load(userName, userStoreManager);
        if (userIdentityDO == null) {
            throw IdentityException.error((String)("No user account found for user " + userName));
        }
        userIdentityDO.updateUserIdentityRecoveryData(userIdentityRecoveryData);
        store.store(userIdentityDO, userStoreManager);
    }

    public static UserIdentityClaimDTO[] getUserIdentityClaims(String userName, UserStoreManager userStoreManager) throws IdentityException {
        UserIdentityDataStore store = IdentityMgtConfig.getInstance().getIdentityDataStore();
        UserIdentityClaimsDO userIdentityDO = store.load(userName, userStoreManager);
        if (userIdentityDO != null) {
            return userIdentityDO.getUserIdentityRecoveryData();
        }
        throw IdentityException.error((String)("No user account found for user " + userName));
    }

    public static boolean isValidIdentityMetadata(String userName, int tenantId, String metadataType, String metadata) throws IdentityException {
        return false;
    }

    public static void invalidateUserIdentityMetadata(String userName, int tenantId, String metadataType, String metadata) throws IdentityException {
        JDBCUserRecoveryDataStore store = new JDBCUserRecoveryDataStore();
        UserRecoveryDataDO metadataDO = new UserRecoveryDataDO(userName, tenantId, metadataType, metadata);
        store.invalidate(metadataDO);
    }

    public static void storeUserIdentityMetadata(UserRecoveryDataDO metadata) throws IdentityException {
        JDBCUserRecoveryDataStore store = new JDBCUserRecoveryDataStore();
        metadata.setValid(true);
        store.store(metadata);
    }

    public static void storeUserIdentityClaims(UserIdentityClaimsDO identityClaims, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws IdentityException {
        IdentityMgtConfig.getInstance().getIdentityDataStore().store(identityClaims, (UserStoreManager)userStoreManager);
    }

    public static UserRecoveryDataDO getUserIdentityMetadata(String userName, int tenantId, String metadataType) {
        return null;
    }

    public static UserIdentityClaimDTO[] getAllUserIdentityClaims(String userName) throws IdentityMgtServiceException {
        int tenantId = 0;
        try {
            tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            Claim[] claims = userStoreManager.getUserClaimValues(userName, null);
            ArrayList<UserIdentityClaimDTO> allDefaultClaims = new ArrayList<UserIdentityClaimDTO>();
            for (Claim claim : claims) {
                if (!claim.getClaimUri().contains("http://wso2.org/claims")) continue;
                UserIdentityClaimDTO claimDTO = new UserIdentityClaimDTO();
                claimDTO.setClaimUri(claim.getClaimUri());
                claimDTO.setClaimValue(claim.getValue());
                allDefaultClaims.add(claimDTO);
            }
            UserIdentityClaimDTO[] claimDTOs = new UserIdentityClaimDTO[allDefaultClaims.size()];
            return allDefaultClaims.toArray(claimDTOs);
        }
        catch (UserStoreException e) {
            throw new IdentityMgtServiceException("Error while getting user identity claims", e);
        }
    }

    public static void notifyViaEmail(UserIdentityMgtBean bean) {
    }

    public static void notifyWithEmail(UserRecoveryDTO notificationBean) {
    }

    public static char[] generateTemporaryPassword() {
        IdentityMgtConfig config = IdentityMgtConfig.getInstance();
        return config.getPasswordGenerator().generatePassword();
    }

    public static String generateRandomConfirmationCode() {
        return new String(UserIdentityManagementUtil.generateTemporaryPassword());
    }

    public static String getUsernameByClaims(UserIdentityClaimDTO[] claims, int tenantId) throws IdentityMgtServiceException {
        if (claims == null || claims.length < 1) {
            throw new IdentityMgtServiceException("No fields found for user search");
        }
        String userName = null;
        String[] tempUserList = null;
        for (int i = 0; i < claims.length; ++i) {
            UserIdentityClaimDTO claim = claims[i];
            if (claim.getClaimUri() == null || claim.getClaimValue() == null) continue;
            String[] userList = UserIdentityManagementUtil.getUserList(tenantId, claim.getClaimUri(), claim.getClaimValue(), null);
            if (userList != null && userList.length > 0) {
                if (userList.length == 1) {
                    return userList[0];
                }
                if (tempUserList != null) {
                    for (int j = 0; j < tempUserList.length; ++j) {
                        for (int x = 0; x < userList.length; ++x) {
                            if (!tempUserList[j].equals(userList[x])) continue;
                            return userList[x];
                        }
                    }
                }
                tempUserList = userList;
                continue;
            }
            throw new IdentityMgtServiceException("No associated user is found for given claim values");
        }
        return userName;
    }

    private static String[] getUserList(int tenantId, String claim, String value, String profileName) throws IdentityMgtServiceException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        String[] userList = null;
        RealmService realmService = IdentityMgtServiceComponent.getRealmService();
        try {
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (Exception e) {
            String msg = "Error retrieving the user store manager for the tenant";
            throw new IdentityMgtServiceException(msg, e);
        }
        try {
            if (userStoreManager != null) {
                userList = userStoreManager.getUserList(claim, value, profileName);
            }
            return userList;
        }
        catch (Exception e) {
            String msg = "Unable to retrieve the claim for the given tenant";
            throw new IdentityMgtServiceException(msg, e);
        }
    }

    public static VerificationBean getCustomErrorMessagesWhenRegistering(Exception e, String userName) {
        if (e.getMessage() != null) {
            if (e.getMessage().contains(PASSWORD_INVALID)) {
                vBean = UserIdentityManagementUtil.handleError("17002 Credential not valid. Credential must be a non null for the user : " + userName, e);
            } else if (e.getMessage().contains(EXISTING_USER)) {
                vBean = UserIdentityManagementUtil.handleError("18003 Username '" + userName + "' already exists in the system. Please enter another username.", e);
            } else if (e.getMessage().contains(INVALID_CLAIM_URL)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Invalid claim uri has been provided.", e);
            } else if (e.getMessage().contains(INVALID_USER_NAME)) {
                vBean = UserIdentityManagementUtil.handleError("18003 Username " + userName + " is not valid. User name must be a non null", e);
            } else if (e.getMessage().contains(READ_ONLY_STORE)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Read-only UserStoreManager. Roles cannot be added or modified.", e);
            } else if (e.getMessage().contains(READ_ONLY_PRIMARY_STORE)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Cannot add role to Read Only user store unless it is primary.", e);
            } else if (e.getMessage().contains(INVALID_ROLE)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Invalid role name. Role name must be a non null string.", e);
            } else if (e.getMessage().contains(NO_READ_WRITE_PERMISSIONS)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Role cannot be added. User store is read only or cannot write groups.", e);
            } else if (e.getMessage().contains(EXISTING_ROLE)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Role already exists in the system. Please enter another role name.", e);
            } else if (e.getMessage().contains(SHARED_USER_ROLES)) {
                vBean = UserIdentityManagementUtil.handleError("18013 User store doesn't support shared user roles functionality.", e);
            } else if (e.getMessage().contains(REMOVE_ADMIN_USER)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Cannot remove Admin user from Admin role.", e);
            } else if (e.getMessage().contains(LOGGED_IN_USER)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Cannot remove Admin user from Admin role.", e);
            } else if (e.getMessage().contains(ADMIN_USER)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Cannot remove Admin user from Admin role.", e);
            } else if (e.getMessage().contains(ANONYMOUS_USER)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Cannot delete anonymous user.", e);
            } else if (e.getMessage().contains(INVALID_OPERATION)) {
                vBean = UserIdentityManagementUtil.handleError("18013 Invalid operation. User store is read only.", e);
            } else if (e.getMessage().contains(PASSWORD_POLICY_VIOLATION)) {
                vBean = UserIdentityManagementUtil.handleError("18013 " + e.getMessage(), e);
            } else {
                vBean = UserIdentityManagementUtil.handleError("18013 Error occurred while adding user : " + userName, e);
                return vBean;
            }
            return vBean;
        }
        vBean = UserIdentityManagementUtil.handleError("18013 Error occurred while adding user : " + userName, e);
        return vBean;
    }

    public static VerificationBean getCustomErrorMessagesToVerifyCode(IdentityException e, String userName) {
        if (e.getMessage() != null) {
            if (e.getMessage().contains("18002")) {
                vBean = UserIdentityManagementUtil.handleError("18002 The code is expired", (Exception)((Object)e));
            } else if (e.getMessage().contains(" Invalid confirmation code ")) {
                vBean = UserIdentityManagementUtil.handleError("18001  Invalid confirmation code ", (Exception)((Object)e));
            } else if (e.getMessage().contains("18014")) {
                vBean = UserIdentityManagementUtil.handleError("18014 Error loading data for user : " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Error occurred while getting external code for user : ")) {
                vBean = UserIdentityManagementUtil.handleError("18001 Error occurred while getting external code for user : : " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Notification sending failure. Notification address is not defined for user:")) {
                vBean = UserIdentityManagementUtil.handleError("18015 Notification sending failure. Notification address is not defined for user:: " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Error occurred while loading email templates for user : ")) {
                vBean = UserIdentityManagementUtil.handleError("18015: Error occurred while loading email templates for user :  " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Error occurred while getting external code for user : ")) {
                vBean = UserIdentityManagementUtil.handleError("18001: Error occurred while getting external code for user :  " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Error occurred while creating notification for user : ")) {
                vBean = UserIdentityManagementUtil.handleError("18015: Error occurred while creating notification for user :  " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("18014")) {
                vBean = UserIdentityManagementUtil.handleError("18014 Error loading data for user : " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains(" No user account found for user ")) {
                vBean = UserIdentityManagementUtil.handleError("18001 No user account found for user", (Exception)((Object)e));
            }
            return vBean;
        }
        vBean = UserIdentityManagementUtil.handleError("18001 No user account found for user", (Exception)((Object)e));
        return vBean;
    }

    public static ChallengeQuestionIdsDTO getCustomErrorMessagesForChallengeQuestionIds(Exception e, String userName) {
        if (e.getMessage() != null) {
            if (e.getMessage().contains("18002")) {
                idsDTO = UserIdentityManagementUtil.handleChallengeIdError("18002 The code is expired", e);
            } else if (e.getMessage().contains(" Invalid confirmation code ")) {
                idsDTO = UserIdentityManagementUtil.handleChallengeIdError("18001  Invalid confirmation code ", e);
            } else if (e.getMessage().contains("Error occurred while getting external code for user : ")) {
                idsDTO = UserIdentityManagementUtil.handleChallengeIdError("18001 Error occurred while getting external code for user : " + userName, e);
            } else if (e.getMessage().contains("18014")) {
                idsDTO = UserIdentityManagementUtil.handleChallengeIdError("18014 Error loading data for user :  " + userName, e);
            }
            return idsDTO;
        }
        idsDTO = UserIdentityManagementUtil.handleChallengeIdError("18014 Error loading data for user :  " + userName, e);
        return idsDTO;
    }

    public static UserChallengesDTO getCustomErrorMessagesForChallengQuestions(IdentityException e, String userName) {
        if (e.getMessage() != null) {
            if (e.getMessage().contains("18002")) {
                userChallengesDTO = UserIdentityManagementUtil.handleChallengesError("18002 The code is expired", (Exception)((Object)e));
            } else if (e.getMessage().contains(" Invalid confirmation code ")) {
                userChallengesDTO = UserIdentityManagementUtil.handleChallengesError("18001  Invalid confirmation code ", (Exception)((Object)e));
            } else if (e.getMessage().contains("18014")) {
                userChallengesDTO = UserIdentityManagementUtil.handleChallengesError("18014 Error loading data for user : " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Error occurred while getting external code for user : ")) {
                userChallengesDTO = UserIdentityManagementUtil.handleChallengesError("18001 Error occurred while getting external code for user : : " + userName, (Exception)((Object)e));
            }
            return userChallengesDTO;
        }
        userChallengesDTO = UserIdentityManagementUtil.handleChallengesError("18001 Error occurred while getting external code for user : : " + userName, (Exception)((Object)e));
        return userChallengesDTO;
    }

    public static UserChallengesCollectionDTO getCustomErrorMessagesForChallengeQuestionSet(IdentityException e, String userName) {
        if (e.getMessage() != null) {
            if (e.getMessage().contains("18002")) {
                userChallengesCollectionDTO = UserIdentityManagementUtil.handleChallengeQuestionSetError("18002 The code is expired", (Exception)((Object)e));
            } else if (e.getMessage().contains(" Invalid confirmation code ")) {
                userChallengesCollectionDTO = UserIdentityManagementUtil.handleChallengeQuestionSetError("18001  Invalid confirmation code ", (Exception)((Object)e));
            } else if (e.getMessage().contains("18014")) {
                userChallengesCollectionDTO = UserIdentityManagementUtil.handleChallengeQuestionSetError("18014 Error loading data for user : " + userName, (Exception)((Object)e));
            } else if (e.getMessage().contains("Error occurred while getting external code for user : ")) {
                userChallengesCollectionDTO = UserIdentityManagementUtil.handleChallengeQuestionSetError("18001 Error occurred while getting external code for user : : " + userName, (Exception)((Object)e));
            }
        } else {
            userChallengesCollectionDTO = UserIdentityManagementUtil.handleChallengeQuestionSetError("18001 Error occurred while getting external code for user : : " + userName, (Exception)((Object)e));
        }
        return userChallengesCollectionDTO;
    }

    private static UserChallengesDTO handleChallengesError(String error, Exception e) {
        UserChallengesDTO bean = new UserChallengesDTO();
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e);
        }
        return bean;
    }

    private static ChallengeQuestionIdsDTO handleChallengeIdError(String error, Exception e) {
        ChallengeQuestionIdsDTO bean = new ChallengeQuestionIdsDTO();
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e);
        }
        return bean;
    }

    public static UserChallengesCollectionDTO handleChallengeQuestionSetError(String error, Exception e) {
        UserChallengesCollectionDTO bean = new UserChallengesCollectionDTO();
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bean;
    }

    private static VerificationBean handleError(String error, Exception e) {
        VerificationBean bean = new VerificationBean();
        bean.setVerified(false);
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e);
        }
        return bean;
    }

    public static void loadDefaultChallenges() {
        ChallengeQuestionDTO dto;
        ArrayList<ChallengeQuestionDTO> questionSetDTOs = new ArrayList<ChallengeQuestionDTO>();
        for (String challenge : IdentityMgtConstants.getSecretQuestionsSet01()) {
            dto = new ChallengeQuestionDTO();
            dto.setQuestion(challenge);
            dto.setPromoteQuestion(true);
            dto.setQuestionSetId("http://wso2.org/claims/challengeQuestion1");
            questionSetDTOs.add(dto);
        }
        for (String challenge : IdentityMgtConstants.getSecretQuestionsSet02()) {
            dto = new ChallengeQuestionDTO();
            dto.setQuestion(challenge);
            dto.setPromoteQuestion(true);
            dto.setQuestionSetId("http://wso2.org/claims/challengeQuestion2");
            questionSetDTOs.add(dto);
        }
        try {
            IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor().setChallengeQuestions(questionSetDTOs.toArray(new ChallengeQuestionDTO[questionSetDTOs.size()]));
        }
        catch (IdentityException e) {
            log.error((Object)"Error while promoting default challenge questions", (Throwable)e);
        }
    }
}

