/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimsDO;
import org.wso2.carbon.identity.mgt.store.InMemoryIdentityDataStore;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.ldap.ActiveDirectoryUserStoreManager;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserStoreBasedIdentityDataStore
extends InMemoryIdentityDataStore {
    private static Log log = LogFactory.getLog(UserStoreBasedIdentityDataStore.class);
    private static final String TRUE_STRING = "TRUE";
    private static final String FALSE_STRING = "FALSE";
    private static ThreadLocal<String> userStoreInvoked = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UserStoreBasedIdentityDataStore.FALSE_STRING;
        }
    };

    @Override
    public void store(UserIdentityClaimsDO userIdentityDTO, UserStoreManager userStoreManager) throws IdentityException {
        block9: {
            int tenantId;
            UserIdentityClaimsDO newIdentityClaimDO = new UserIdentityClaimsDO(userIdentityDTO.getUserName(), userIdentityDTO.getUserDataMap());
            try {
                tenantId = userStoreManager.getTenantId();
            }
            catch (UserStoreException e) {
                throw IdentityException.error((String)"Error while getting tenant Id.", (Throwable)e);
            }
            newIdentityClaimDO.setTenantId(tenantId);
            super.store(newIdentityClaimDO, userStoreManager);
            if (userIdentityDTO.getUserName() == null) {
                log.error((Object)"Error while persisting user data.  Null user name is provided.");
                return;
            }
            String username = UserCoreUtil.removeDomainFromName((String)userIdentityDTO.getUserName());
            try {
                if (userStoreManager.isReadOnly()) {
                    log.warn((Object)"User store is read only. Changes to identities are only stored in memory, and not updated in user store.");
                    return;
                }
                this.setUserClaimsValuesInUserStore(userStoreManager, username, new HashMap<String, String>(userIdentityDTO.getUserDataMap()), null);
            }
            catch (UserStoreException e) {
                String domain;
                if (!e.getMessage().startsWith("UserNotFound")) {
                    throw IdentityException.error((String)"Error while persisting identity user data in to user store", (Throwable)e);
                }
                if (!log.isDebugEnabled()) break block9;
                String message = null;
                if (userStoreManager instanceof AbstractUserStoreManager && (domain = ((AbstractUserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName")) != null) {
                    message = "User: " + username + " does not exist in " + domain;
                }
                if (message == null) {
                    message = "User: " + username + " does not exist";
                }
                log.debug(message);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityClaimsDO load(String userName, UserStoreManager userStoreManager) {
        HashMap<String, String> userDataMap;
        UserIdentityClaimsDO userIdentityDTO;
        block20: {
            userIdentityDTO = super.load(userName, userStoreManager);
            if (userIdentityDTO != null) {
                return userIdentityDTO;
            }
            if (TRUE_STRING.equals(userStoreInvoked.get())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"UserStoreBasedIdentityDataStore.load() already been called in the stack.Hence returning without processing load() again.");
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Set flag to indicate method UserStoreBasedIdentityDataStore.load() been called");
            }
            userStoreInvoked.set(TRUE_STRING);
            userDataMap = new HashMap<String, String>();
            try {
                Claim[] claims = ((AbstractUserStoreManager)userStoreManager).getUserClaimValues(userName, null);
                if (claims != null) {
                    for (Claim claim : claims) {
                        String claimUri = claim.getClaimUri();
                        if (!claimUri.contains("http://wso2.org/claims/identity") && !claimUri.contains("http://wso2.org/claims/identity/challengeQuestion")) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding UserIdentityClaim : " + claimUri + " with the value : " + claim.getValue()));
                        }
                        userDataMap.put(claimUri, claim.getValue());
                    }
                    break block20;
                }
                UserIdentityClaimsDO userIdentityClaimsDO = null;
                return userIdentityClaimsDO;
            }
            catch (UserStoreException e) {
                String message;
                if (!e.getMessage().startsWith("UserNotFound")) {
                    log.error((Object)"Error while reading identity user data from user store", (Throwable)e);
                } else if (log.isDebugEnabled()) {
                    String domain;
                    message = null;
                    if (userStoreManager instanceof AbstractUserStoreManager && (domain = ((AbstractUserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName")) != null) {
                        message = "User: " + userName + " does not exist in " + domain;
                    }
                    if (message == null) {
                        message = "User: " + userName + " does not exist";
                    }
                    log.debug(message);
                }
                message = null;
                return message;
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Reset flag to indicate method UserStoreBasedIdentityDataStore.load() being completing");
                }
                userStoreInvoked.set(FALSE_STRING);
            }
        }
        userIdentityDTO = new UserIdentityClaimsDO(userName, userDataMap);
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        userIdentityDTO.setTenantId(tenantId);
        org.wso2.carbon.user.core.UserStoreManager store = (org.wso2.carbon.user.core.UserStoreManager)userStoreManager;
        String domainName = store.getRealmConfiguration().getUserStoreProperty("DomainName");
        try {
            super.store(userIdentityDTO, userStoreManager);
        }
        catch (IdentityException e) {
            log.error((Object)"Error while reading user identity data", (Throwable)e);
        }
        return userIdentityDTO;
    }

    protected void setUserClaimsValuesInUserStore(UserStoreManager userStoreManager, String username, Map<String, String> claims, String profile) throws IdentityException {
        block5: {
            try {
                if (userStoreManager instanceof JDBCUserStoreManager) {
                    ((JDBCUserStoreManager)userStoreManager).doSetUserClaimValues(username, claims, null);
                    break block5;
                }
                if (userStoreManager instanceof ActiveDirectoryUserStoreManager) {
                    ((ActiveDirectoryUserStoreManager)userStoreManager).doSetUserClaimValues(username, claims, null);
                    break block5;
                }
                if (userStoreManager instanceof ReadWriteLDAPUserStoreManager) {
                    ((ReadWriteLDAPUserStoreManager)userStoreManager).doSetUserClaimValues(username, claims, null);
                    break block5;
                }
                String msg = "Cannot persist identity data to userstore for user:%s. Unsupported userstore type:%s to be used as UserStoreBasedIdentityDataStore.";
                throw IdentityException.error((String)String.format(msg, username, userStoreManager.getClass().getName()));
            }
            catch (UserStoreException e) {
                throw IdentityException.error((String)("Error while persisting identity user data in to user store for user: " + username), (Throwable)e);
            }
        }
    }
}

