/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.mgt.dto.IdentityMetadataDO;

public class UserIdentityMetadataStore {
    public void invalidateMetadata(IdentityMetadataDO metadata) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_IDENTITY_META_DATA SET VALID = 'false' WHERE USER_NAME = ? AND TENANT_ID = ? AND METADATA_TYPE = ? AND METADATA = ?");
            prepStmt.setString(1, metadata.getUserName());
            prepStmt.setInt(2, metadata.getTenantId());
            prepStmt.setString(3, metadata.getMetadataType());
            prepStmt.setString(4, metadata.getMetadata());
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)"Error while storing user identity data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void invalidateMetadataSet(IdentityMetadataDO[] metadataSet) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("UPDATE IDN_IDENTITY_META_DATA SET VALID = 'false' WHERE USER_NAME = ? AND TENANT_ID = ? AND METADATA_TYPE = ? AND METADATA = ?");
            for (IdentityMetadataDO metadata : metadataSet) {
                prepStmt.setString(1, metadata.getUserName());
                prepStmt.setInt(2, metadata.getTenantId());
                prepStmt.setString(3, metadata.getMetadataType());
                prepStmt.setString(4, metadata.getMetadata());
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)"Error while invalidating user identity data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void storeMetadata(IdentityMetadataDO metadata) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_IDENTITY_META_DATA (USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID)VALUES (?,?,?,?,?)");
            prepStmt.setString(1, metadata.getUserName());
            prepStmt.setInt(2, metadata.getTenantId());
            prepStmt.setString(3, metadata.getMetadataType());
            prepStmt.setString(4, metadata.getMetadata());
            prepStmt.setString(5, Boolean.toString(metadata.isValid()));
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)"Error while storing user identity data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void storeMetadataSet(IdentityMetadataDO[] metadataSet) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_IDENTITY_META_DATA (USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID)VALUES (?,?,?,?,?)");
            for (IdentityMetadataDO metadata : metadataSet) {
                prepStmt.setString(1, metadata.getUserName());
                prepStmt.setInt(2, metadata.getTenantId());
                prepStmt.setString(3, metadata.getMetadataType());
                prepStmt.setString(4, metadata.getMetadata());
                prepStmt.setString(5, Boolean.toString(metadata.isValid()));
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)"Error while storing user identity data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public IdentityMetadataDO loadMetadata(String userName, int tenantId, String metadataType, String metadata) throws IdentityException {
        IdentityMetadataDO identityMetadataDO;
        ResultSet results;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            results = null;
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID = ? AND METADATA_TYPE = ? AND METADATA = ?");
            prepStmt.setString(1, userName);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, metadataType);
            prepStmt.setString(4, metadata);
            results = prepStmt.executeQuery();
            if (!results.next()) break block6;
            IdentityMetadataDO identityMetadataDO2 = new IdentityMetadataDO(results.getString(1), results.getInt(2), results.getString(3), results.getString(4), Boolean.parseBoolean(results.getString(5)));
            IdentityDatabaseUtil.closeResultSet((ResultSet)results);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            return identityMetadataDO2;
        }
        try {
            if (results.next()) {
                throw IdentityException.error((String)("Duplicate entry found for " + metadataType));
            }
            identityMetadataDO = null;
        }
        catch (SQLException e) {
            try {
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return identityMetadataDO;
    }

    public IdentityMetadataDO[] loadMetadata(String userName, int tenantId) throws IdentityException {
        IdentityMetadataDO[] identityMetadataDOArray;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet results = null;
        try {
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID = ? ");
            prepStmt.setString(1, userName);
            prepStmt.setInt(2, IdentityTenantUtil.getTenantIdOfUser((String)userName));
            results = prepStmt.executeQuery();
            ArrayList<IdentityMetadataDO> metada = new ArrayList<IdentityMetadataDO>();
            while (results.next()) {
                metada.add(new IdentityMetadataDO(results.getString(1), results.getInt(2), results.getString(3), results.getString(4), Boolean.parseBoolean(results.getString(5))));
            }
            IdentityMetadataDO[] resultMetadata = new IdentityMetadataDO[metada.size()];
            identityMetadataDOArray = metada.toArray(resultMetadata);
        }
        catch (SQLException e) {
            try {
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return identityMetadataDOArray;
    }

    public IdentityMetadataDO[] loadMetadata(String userName, int tenantId, String metadataType) throws IdentityException {
        IdentityMetadataDO[] identityMetadataDOArray;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet results = null;
        try {
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE TENANT_ID = ? AND METADATA_TYPE = ?");
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, metadataType);
            results = prepStmt.executeQuery();
            ArrayList<IdentityMetadataDO> metada = new ArrayList<IdentityMetadataDO>();
            while (results.next()) {
                metada.add(new IdentityMetadataDO(results.getString(1), results.getInt(2), results.getString(3), results.getString(4), Boolean.parseBoolean(results.getString(5))));
            }
            IdentityMetadataDO[] resultMetadata = new IdentityMetadataDO[metada.size()];
            identityMetadataDOArray = metada.toArray(resultMetadata);
        }
        catch (SQLException e) {
            try {
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return identityMetadataDOArray;
    }

    private static class SQLQuery {
        public static final String LOAD_META_DATA = "SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID = ? AND METADATA_TYPE = ? AND METADATA = ?";
        public static final String LOAD_USER_METADATA = "SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID = ? ";
        public static final String LOAD_TENANT_METADATA = "SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE TENANT_ID = ? AND METADATA_TYPE = ?";
        public static final String STORE_META_DATA = "INSERT INTO IDN_IDENTITY_META_DATA (USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID)VALUES (?,?,?,?,?)";
        public static final String INVALIDATE_METADATA = "UPDATE IDN_IDENTITY_META_DATA SET VALID = 'false' WHERE USER_NAME = ? AND TENANT_ID = ? AND METADATA_TYPE = ? AND METADATA = ?";

        private SQLQuery() {
        }
    }
}

