/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDataDO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.store.ArtifactDeleteThread;
import org.wso2.carbon.identity.mgt.store.UserRecoveryDataStore;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.RegistryConfigLoader;

public class RegistryRecoveryDataStore
implements UserRecoveryDataStore {
    private static final Log log = LogFactory.getLog(RegistryRecoveryDataStore.class);
    private static final String USE_HASHED_USERNAME_PROPERTY = "UserInfoRecovery.UseHashedUserNames";
    private static final String USERNAME_HASH_ALG_PROPERTY = "UserInfoRecovery.UsernameHashAlg";
    private static final String REGISTRY_SEARCH_FIELD_PROPERTY_NAME = "propertyName";
    private static final String REGISTRT_SEARCH_FIELD_RIGHT_PROPERTY_VALUE = "rightPropertyValue";
    private static final String REGISTRY_SEARCH_FIELD_RIGHT_OP = "rightOp";
    private static final String REGISTRY_SEARCH_FIELD_RIGHT_OP_EQ = "eq";
    private static final String REGISTRY_INDEXING_ENABLED = "Identity.Mgt.Registry.Indexing";

    @Override
    public void store(UserRecoveryDataDO recoveryDataDO) throws IdentityException {
        UserRegistry registry = null;
        try {
            String tenantDomain = IdentityTenantUtil.getTenantDomain((int)recoveryDataDO.getTenantId());
            IdentityTenantUtil.initializeRegistry((int)recoveryDataDO.getTenantId());
            registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            registry.beginTransaction();
            Resource resource = registry.newResource();
            resource.setProperty("secretKey", recoveryDataDO.getSecret());
            resource.setProperty("userId", recoveryDataDO.getUserName().toLowerCase());
            resource.setProperty("expireTime", recoveryDataDO.getExpireTime());
            resource.setVersionableChange(false);
            String confirmationKeyPath = "/repository/components/org.wso2.carbon.identity.mgt/data/" + recoveryDataDO.getCode().toLowerCase();
            registry.put(confirmationKeyPath, resource);
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw IdentityException.error((String)("Error while persisting user recovery data for user : " + recoveryDataDO.getUserName()));
        }
        finally {
            if (registry != null) {
                try {
                    registry.commitTransaction();
                }
                catch (RegistryException e) {
                    log.error((Object)"Error while processing registry transaction", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void store(UserRecoveryDataDO[] recoveryDataDOs) throws IdentityException {
    }

    @Override
    public UserRecoveryDataDO load(String code) throws IdentityException {
        UserRecoveryDataDO dataDO;
        block17: {
            UserRegistry registry = null;
            dataDO = new UserRecoveryDataDO();
            try {
                int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
                String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
                IdentityTenantUtil.initializeRegistry((int)tenantId);
                registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                registry.beginTransaction();
                String secretKeyPath = "/repository/components/org.wso2.carbon.identity.mgt/data/" + code.toLowerCase();
                if (registry.resourceExists(secretKeyPath)) {
                    Resource resource = registry.get(secretKeyPath);
                    Properties props = resource.getProperties();
                    for (Object o : props.keySet()) {
                        String key = (String)o;
                        if (key.equals("userId")) {
                            dataDO.setUserName(resource.getProperty(key));
                            continue;
                        }
                        if (key.equals("secretKey")) {
                            dataDO.setSecret(resource.getProperty(key));
                            continue;
                        }
                        if (!key.equals("expireTime")) continue;
                        String time = resource.getProperty(key);
                        dataDO.setExpireTime(time);
                        if (System.currentTimeMillis() > Long.parseLong(time)) {
                            dataDO.setValid(false);
                            break block17;
                        }
                        dataDO.setValid(true);
                    }
                    break block17;
                }
                UserRecoveryDataDO userRecoveryDataDO = null;
                return userRecoveryDataDO;
            }
            catch (RegistryException e) {
                log.error((Object)e);
                throw IdentityException.error((String)("Error while loading user recovery data for code : " + code));
            }
            finally {
                if (registry != null) {
                    try {
                        registry.commitTransaction();
                    }
                    catch (RegistryException e) {
                        log.error((Object)"Error while processing registry transaction", (Throwable)e);
                    }
                }
            }
        }
        return dataDO;
    }

    @Override
    public void invalidate(String code) throws IdentityException {
        UserRegistry registry = null;
        try {
            registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            registry.beginTransaction();
            String secretKeyPath = "/repository/components/org.wso2.carbon.identity.mgt/data/" + code.toLowerCase();
            if (registry.resourceExists(secretKeyPath)) {
                registry.delete(secretKeyPath);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw IdentityException.error((String)("Error while invalidating user recovery data for code : " + code));
        }
        finally {
            if (registry != null) {
                try {
                    registry.commitTransaction();
                }
                catch (RegistryException e) {
                    log.error((Object)"Error while processing registry transaction", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void invalidate(UserRecoveryDataDO recoveryDataDO) throws IdentityException {
        UserRegistry registry = null;
        try {
            registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            registry.beginTransaction();
            String dataPath = "/repository/components/org.wso2.carbon.identity.mgt/data";
            Collection dataItems = (Collection)registry.get(dataPath);
            for (int i = 0; i < dataItems.getChildren().length; ++i) {
                Resource currentResource;
                try {
                    currentResource = registry.get(dataItems.getChildren()[i]);
                }
                catch (ResourceNotFoundException exception) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Resource :" + dataItems.getChildren()[i] + " is already deleted"));
                    continue;
                }
                if (currentResource instanceof Collection) {
                    String[] currentResourceChildren = ((Collection)currentResource).getChildren();
                    for (int j = 0; j < currentResourceChildren.length; ++j) {
                        Resource innerResource;
                        try {
                            innerResource = registry.get(currentResourceChildren[i]);
                        }
                        catch (ResourceNotFoundException exception) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource :" + registry.get(currentResourceChildren[i]) + " is already deleted"));
                            continue;
                        }
                        if (!innerResource.getProperty("secretKey").equals(recoveryDataDO.getSecret())) continue;
                        registry.delete(currentResourceChildren[j]);
                        return;
                    }
                    continue;
                }
                if (!currentResource.getProperty("secretKey").equals(recoveryDataDO.getSecret())) continue;
                registry.delete(dataItems.getChildren()[i]);
                return;
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)"Error while deleting resource after loading", (Throwable)e);
        }
        finally {
            if (registry != null) {
                try {
                    registry.commitTransaction();
                }
                catch (RegistryException e) {
                    log.error((Object)"Error while deleting resource after loading.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void invalidate(String userId, int tenantId) throws IdentityException {
        UserRegistry registry = null;
        try {
            registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            if (IdentityMgtConfig.getInstance().getPoolSize() <= 0) {
                this.deleteOldResourcesIfFound((Registry)registry, userId, "/repository/components/org.wso2.carbon.identity.mgt/data");
            } else {
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                if (!"updatePassword".equals(stackTraceElements[2].getMethodName())) {
                    ArtifactDeleteThread artifactDeleteThread = new ArtifactDeleteThread((Registry)registry, userId, "/repository/components/org.wso2.carbon.identity.mgt/data", tenantId, false);
                    IdentityMgtConfig.getInstance().getExecutors().submit(artifactDeleteThread);
                } else {
                    ArtifactDeleteThread artifactDeleteThread = new ArtifactDeleteThread((Registry)registry, userId, "/repository/components/org.wso2.carbon.identity.mgt/data", tenantId, true);
                    IdentityMgtConfig.getInstance().getExecutors().submit(artifactDeleteThread);
                }
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)"Error while deleting the old confirmation code.", (Throwable)e);
        }
    }

    @Override
    public UserRecoveryDataDO[] load(String userName, int tenantId) throws IdentityException {
        return new UserRecoveryDataDO[0];
    }

    private void deleteOldResourcesIfFound(Registry registry, String userName, String secretKeyPath) {
        boolean useRegistryIndexing = Boolean.parseBoolean(IdentityMgtConfig.getInstance().getProperty(REGISTRY_INDEXING_ENABLED));
        if (useRegistryIndexing && RegistryConfigLoader.getInstance().IsStartIndexing()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Property: Identity.Mgt.Registry.Indexing is enabled. Switching to registry search mode to delete old confirmation codes.");
            }
            this.deleteOldConfirmationCodesByRegistrySearch(registry, userName, secretKeyPath);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting old confirmation codes iterating over registry resource collection at: " + secretKeyPath));
            }
            this.deleteOldConfirmationCodesByResourceIteration(registry, userName, secretKeyPath);
        }
    }

    private void deleteOldConfirmationCodesByRegistrySearch(Registry registry, String username, String confirmationCodePath) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(REGISTRY_SEARCH_FIELD_PROPERTY_NAME, "userId");
        fields.put(REGISTRT_SEARCH_FIELD_RIGHT_PROPERTY_VALUE, username.toLowerCase());
        fields.put(REGISTRY_SEARCH_FIELD_RIGHT_OP, REGISTRY_SEARCH_FIELD_RIGHT_OP_EQ);
        Object[] searchResults = null;
        try {
            searchResults = (ResourceData[])IdentityMgtServiceComponent.getAttributeSearchService().search(fields);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while deleting the old confirmation code. Unable to search resources in registry for: [propertyName - userId, rightPropertyValue - " + username + ", " + REGISTRY_SEARCH_FIELD_RIGHT_OP + " - " + REGISTRY_SEARCH_FIELD_RIGHT_OP_EQ + "]"), (Throwable)e);
        }
        if (searchResults != null && !ArrayUtils.isEmpty((Object[])searchResults)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found: " + searchResults.length + " no of resources for search: [" + REGISTRY_SEARCH_FIELD_PROPERTY_NAME + " - " + "userId" + ", " + REGISTRT_SEARCH_FIELD_RIGHT_PROPERTY_VALUE + " - " + username + ", " + REGISTRY_SEARCH_FIELD_RIGHT_OP + " - " + REGISTRY_SEARCH_FIELD_RIGHT_OP_EQ + "]"));
            }
            for (Object resource : searchResults) {
                String resourcePath = resource.getResourcePath();
                if (resourcePath == null || !resourcePath.contains(confirmationCodePath)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matching resource found for user: " + username + " at resource path : " + resource.getResourcePath()));
                }
                String resourcePathRelativeToConfigRegistry = resource.getResourcePath().substring("/_system/config".length());
                this.deleteRegistryResource(registry, resourcePathRelativeToConfigRegistry);
            }
        } else if (log.isDebugEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("No registry resource found for search: [propertyName - userId, rightPropertyValue - " + username + ", " + REGISTRY_SEARCH_FIELD_RIGHT_OP + " - " + REGISTRY_SEARCH_FIELD_RIGHT_OP_EQ + "]"));
        }
    }

    private void deleteOldConfirmationCodesByResourceIteration(Registry registry, String username, String confirmationCodePath) {
        Collection collection = null;
        try {
            collection = (Collection)registry.get(confirmationCodePath.toLowerCase());
        }
        catch (RegistryException e) {
            log.error((Object)("Error while deleting the old confirmation code for user: " + username + ". Cannot find resource collection at resource path: " + confirmationCodePath), (Throwable)e);
        }
        if (collection != null) {
            String userNameToValidate = username;
            String useHashedUserName = IdentityMgtConfig.getInstance().getProperty(USE_HASHED_USERNAME_PROPERTY);
            if (Boolean.parseBoolean(useHashedUserName)) {
                String hashAlg = IdentityMgtConfig.getInstance().getProperty(USERNAME_HASH_ALG_PROPERTY);
                try {
                    userNameToValidate = this.hashString(username, hashAlg);
                }
                catch (NoSuchAlgorithmException e) {
                    log.error((Object)("Invalid hash algorithm " + hashAlg), (Throwable)e);
                }
            }
            try {
                String[] resources;
                for (String resource : resources = collection.getChildren()) {
                    String[] splittedResource = resource.split("___");
                    if (splittedResource.length == 3) {
                        if (!resource.contains("___" + userNameToValidate.toLowerCase() + "___")) continue;
                        this.deleteRegistryResource(registry, resource);
                        continue;
                    }
                    if (splittedResource.length != 2) continue;
                    this.deleteOldResourcesIfFound(registry, username, resource);
                }
            }
            catch (RegistryException e) {
                log.error((Object)("Error while deleting the old confirmation code for user: " + username + " at resource path: " + confirmationCodePath), (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No registry resource found at path: " + confirmationCodePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRegistryResource(Registry registry, String resourcePathRelativeToRegistry) {
        boolean isTransactionSucceeded = false;
        try {
            registry.beginTransaction();
            if (registry.resourceExists(resourcePathRelativeToRegistry)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting registry resource: " + resourcePathRelativeToRegistry));
                }
                registry.delete(resourcePathRelativeToRegistry);
                isTransactionSucceeded = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Registry resource: " + resourcePathRelativeToRegistry + " is already deleted."));
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error while deleting resource: " + resourcePathRelativeToRegistry), (Throwable)e);
        }
        finally {
            try {
                if (isTransactionSucceeded) {
                    registry.commitTransaction();
                } else {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException e) {
                log.error((Object)("Error while committing registry transaction for resource: " + resourcePathRelativeToRegistry), (Throwable)e);
            }
        }
    }

    private String hashString(String userName, String alg) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(alg);
        byte[] in = messageDigest.digest(userName.getBytes());
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }
}

