/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;

public class RegistryCleanUpService {
    private static final int NUM_THREADS = 1;
    private static final Log log = LogFactory.getLog(RegistryCleanUpService.class);
    private final ScheduledExecutorService scheduler;
    private final long initialDelay;
    private final long delayBetweenRuns;

    public RegistryCleanUpService(long initialDelay, long delayBetweenRuns) {
        this.initialDelay = initialDelay;
        this.delayBetweenRuns = delayBetweenRuns;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public void activateCleanUp() {
        if (this.delayBetweenRuns == 0L) {
            return;
        }
        RegistryCleanUpTask registryCleanUpTask = new RegistryCleanUpTask();
        this.scheduler.scheduleWithFixedDelay(registryCleanUpTask, this.initialDelay, this.delayBetweenRuns, TimeUnit.MINUTES);
    }

    private static final class RegistryCleanUpTask
    implements Runnable {
        private static final String CONFIRMATION_REGISTRY_RESOURCE_PATH = "/repository/components/org.wso2.carbon.identity.mgt/data";
        private static final String EXPIRE_TIME_PROPERTY = "expireTime";

        private RegistryCleanUpTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start running the Identity-Management registry Data cleanup task.");
                }
                try {
                    Tenant[] tenants = IdentityMgtServiceComponent.getRealmService().getTenantManager().getAllTenants();
                    for (int i = 0; i < tenants.length + 1; ++i) {
                        Tenant tenant;
                        if (i == tenants.length) {
                            tenant = new Tenant();
                            tenant.setDomain("carbon.super");
                            tenant.setId(-1234);
                        } else {
                            tenant = tenants[i];
                        }
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenant.getDomain());
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenant.getId());
                        try {
                            UserRegistry registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                            String[] identityResourcesPaths = new String[]{};
                            if (registry.resourceExists(CONFIRMATION_REGISTRY_RESOURCE_PATH)) {
                                Collection identityDataResource = (Collection)registry.get(CONFIRMATION_REGISTRY_RESOURCE_PATH);
                                identityResourcesPaths = identityDataResource.getChildren();
                            }
                            for (int j = 0; j < identityResourcesPaths.length; ++j) {
                                try {
                                    Resource currentResource = registry.get(identityResourcesPaths[j]);
                                    if (currentResource instanceof Collection) {
                                        Collection secondaryStoreCollection = (Collection)currentResource;
                                        String[] secondaryStoreResourcePaths = secondaryStoreCollection.getChildren();
                                        for (int k = 0; k < secondaryStoreResourcePaths.length; ++k) {
                                            RegistryCleanUpTask.checkAndDeleteRegistryResource((Registry)registry, secondaryStoreResourcePaths[k]);
                                        }
                                        continue;
                                    }
                                    RegistryCleanUpTask.checkAndDeleteRegistryResource((Registry)registry, identityResourcesPaths[j]);
                                    continue;
                                }
                                catch (RegistryException e) {
                                    log.error((Object)("Error while retrieving resource at " + identityResourcesPaths[j]), (Throwable)e);
                                }
                            }
                            continue;
                        }
                        catch (ResourceNotFoundException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("No resource found for tenant " + tenant.getDomain()), (Throwable)e);
                            continue;
                        }
                        catch (RegistryException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Error while deleting the expired confirmation code.", (Throwable)e);
                            continue;
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                }
                catch (UserStoreException e) {
                    if (!log.isDebugEnabled()) break block20;
                    log.debug((Object)"Error while getting the tenant manager.", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Finished running the Identity-Management registry Data cleanup task.");
            }
        }

        private static void checkAndDeleteRegistryResource(Registry registry, String resourcePath) throws RegistryException {
            long resourceExpireTime;
            Resource resource = registry.get(resourcePath);
            long currentEpochTime = System.currentTimeMillis();
            if (currentEpochTime > (resourceExpireTime = Long.parseLong(resource.getProperty(EXPIRE_TIME_PROPERTY)))) {
                registry.delete(resource.getId());
            }
        }
    }
}

