/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDataDO;
import org.wso2.carbon.identity.mgt.store.UserRecoveryDataStore;

public class JDBCUserRecoveryDataStore
implements UserRecoveryDataStore {
    @Override
    public void invalidate(UserRecoveryDataDO recoveryDataDO) throws IdentityException {
        this.invalidate(recoveryDataDO.getCode());
    }

    @Override
    public void invalidate(String userId, int tenant) throws IdentityException {
        PreparedStatement prepStmt = null;
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = connection.prepareStatement("DELETE FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID= ?");
            prepStmt.setString(1, userId.toLowerCase());
            prepStmt.setInt(2, tenant);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw IdentityException.error((String)"Error while invalidating user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    @Override
    public void invalidate(String code) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("DELETE FROM IDN_IDENTITY_META_DATA WHERE  METADATA_TYPE = ?");
            prepStmt.setString(1, code.toLowerCase());
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)("Error while invalidating user identity data for code: " + code), (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    public void store(UserRecoveryDataDO recoveryDataDO) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_IDENTITY_META_DATA (USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID)VALUES (?,?,?,?,?)");
            prepStmt.setString(1, recoveryDataDO.getUserName().toLowerCase());
            prepStmt.setInt(2, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            prepStmt.setString(3, recoveryDataDO.getCode().toLowerCase());
            prepStmt.setString(4, recoveryDataDO.getSecret());
            prepStmt.setString(5, recoveryDataDO.getExpireTime());
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)"Error while storing user identity data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    @Deprecated
    public void store(UserRecoveryDataDO[] recoveryDataDOs) throws IdentityException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_IDENTITY_META_DATA (USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID)VALUES (?,?,?,?,?)");
            for (UserRecoveryDataDO dataDO : recoveryDataDOs) {
                prepStmt.setString(1, dataDO.getUserName().toLowerCase());
                prepStmt.setInt(2, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                prepStmt.setString(3, dataDO.getCode().toLowerCase());
                prepStmt.setString(4, dataDO.getSecret());
                prepStmt.setString(5, dataDO.getExpireTime());
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw IdentityException.error((String)"Error while storing user identity data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    @Deprecated
    public UserRecoveryDataDO[] load(String userName, int tenantId) throws IdentityException {
        UserRecoveryDataDO[] userRecoveryDataDOArray;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet results = null;
        try {
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID = ? ");
            prepStmt.setString(1, userName.toLowerCase());
            prepStmt.setInt(2, IdentityTenantUtil.getTenantIdOfUser((String)userName));
            results = prepStmt.executeQuery();
            ArrayList<UserRecoveryDataDO> metada = new ArrayList<UserRecoveryDataDO>();
            while (results.next()) {
                metada.add(new UserRecoveryDataDO(results.getString(1), results.getInt(2), results.getString(3), results.getString(4)));
            }
            UserRecoveryDataDO[] resultMetadata = new UserRecoveryDataDO[metada.size()];
            userRecoveryDataDOArray = metada.toArray(resultMetadata);
        }
        catch (SQLException e) {
            try {
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return userRecoveryDataDOArray;
    }

    @Override
    public UserRecoveryDataDO load(String code) throws IdentityException {
        UserRecoveryDataDO userRecoveryDataDO2;
        ResultSet results;
        PreparedStatement prepStmt;
        Connection connection;
        block7: {
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            results = null;
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE METADATA_TYPE = ? ");
            prepStmt.setString(1, code.toLowerCase());
            results = prepStmt.executeQuery();
            if (!results.next()) break block7;
            UserRecoveryDataDO userRecoveryDataDO2 = new UserRecoveryDataDO(results.getString(1), results.getInt(2), results.getString(3), results.getString(4));
            String time = results.getString(5);
            userRecoveryDataDO2.setExpireTime(time);
            if (System.currentTimeMillis() > Long.parseLong(time)) {
                userRecoveryDataDO2.setValid(false);
            } else {
                userRecoveryDataDO2.setValid(true);
            }
            UserRecoveryDataDO userRecoveryDataDO3 = userRecoveryDataDO2;
            IdentityDatabaseUtil.closeResultSet((ResultSet)results);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            return userRecoveryDataDO3;
        }
        try {
            userRecoveryDataDO2 = null;
        }
        catch (SQLException e) {
            try {
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return userRecoveryDataDO2;
    }

    private static class SQLQuery {
        static final String LOAD_USER_METADATA = "SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID = ? ";
        static final String LOAD_USER_METADATA_FROM_CODE = "SELECT USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID FROM IDN_IDENTITY_META_DATA WHERE METADATA_TYPE = ? ";
        static final String STORE_META_DATA = "INSERT INTO IDN_IDENTITY_META_DATA (USER_NAME, TENANT_ID, METADATA_TYPE, METADATA, VALID)VALUES (?,?,?,?,?)";
        static final String INVALIDATE_METADATA = "DELETE FROM IDN_IDENTITY_META_DATA WHERE USER_NAME = ? AND TENANT_ID= ?";
        static final String INVALIDATE_METADATA_FROM_CODE = "DELETE FROM IDN_IDENTITY_META_DATA WHERE  METADATA_TYPE = ?";

        private SQLQuery() {
        }
    }
}

