/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimsDO;
import org.wso2.carbon.identity.mgt.store.InMemoryIdentityDataStore;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JDBCIdentityDataStore
extends InMemoryIdentityDataStore {
    private static Log log = LogFactory.getLog(JDBCIdentityDataStore.class);

    @Override
    public void store(UserIdentityClaimsDO userIdentityDTO, UserStoreManager userStoreManager) throws IdentityException {
        int tenantId;
        if (userIdentityDTO == null || userIdentityDTO.getUserDataMap().isEmpty()) {
            return;
        }
        String userName = userIdentityDTO.getUserName();
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        userIdentityDTO.setUserName(userName);
        try {
            tenantId = userStoreManager.getTenantId();
        }
        catch (UserStoreException e) {
            throw IdentityException.error((String)"Error while getting tenant Id.", (Throwable)e);
        }
        userIdentityDTO.setTenantId(tenantId);
        super.store(userIdentityDTO, userStoreManager);
        Map<String, String> data = userIdentityDTO.getUserDataMap();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean isUserExists = false;
            try {
                isUserExists = this.isExistingUserDataValue(userName, tenantId, key);
            }
            catch (SQLException e) {
                throw IdentityException.error((String)"Error occurred while checking if user existing", (Throwable)e);
            }
            try {
                if (isUserExists) {
                    this.updateUserDataValue(userName, tenantId, key, value);
                    continue;
                }
                this.addUserDataValue(userName, tenantId, key, value);
            }
            catch (SQLException e) {
                throw IdentityException.error((String)"Error occurred while persisting user data", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistingUserDataValue(String userName, int tenantId, String key) throws SQLException {
        PreparedStatement prepStmt;
        Connection connection;
        block2: {
            boolean bl;
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmt = null;
            boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
            try {
                String query = isUsernameCaseSensitive ? "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ? AND DATA_KEY = ?" : "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?) AND DATA_KEY = ?";
                prepStmt = connection.prepareStatement(query);
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, userName);
                prepStmt.setString(3, key);
                ResultSet results = prepStmt.executeQuery();
                if (!results.next()) break block2;
                bl = true;
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            return bl;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserDataValue(String userName, int tenantId, String key, String value) throws SQLException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_IDENTITY_USER_DATA (TENANT_ID, USER_NAME, DATA_KEY, DATA_VALUE) VALUES (?,?,?,?)");
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, userName);
            prepStmt.setString(3, key);
            prepStmt.setString(4, value);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDataValue(String userName, int tenantId, String key, String value) throws SQLException {
        block5: {
            Connection connection = IdentityDatabaseUtil.getDBConnection();
            PreparedStatement prepStmt = null;
            boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
            try {
                String query = isUsernameCaseSensitive ? "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND USER_NAME=? AND DATA_KEY=?" : "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND LOWER(USER_NAME)=LOWER(?) AND DATA_KEY=?";
                prepStmt = connection.prepareStatement(query);
                prepStmt.setString(1, value);
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, userName);
                prepStmt.setString(4, key);
                prepStmt.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                break block5;
            }
            finally {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
            }
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityClaimsDO load(String userName, UserStoreManager userStoreManager) {
        block11: {
            UserIdentityClaimsDO userIdentityClaimsDO;
            String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
            UserIdentityClaimsDO dto = super.load(userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName), userStoreManager);
            if (dto != null) {
                return dto;
            }
            Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            PreparedStatement prepStmt = null;
            ResultSet results = null;
            try {
                int tenantId = userStoreManager.getTenantId();
                boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
                String query = isUsernameCaseSensitive ? "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?" : "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
                prepStmt = connection.prepareStatement(query);
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, userName);
                results = prepStmt.executeQuery();
                HashMap<String, String> data = new HashMap<String, String>();
                while (results.next()) {
                    data.put(results.getString(1), results.getString(2));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieved identity data for:" + tenantId + ":" + userName));
                    for (Map.Entry entry : data.entrySet()) {
                        log.debug((Object)((String)entry.getKey() + " : " + (String)entry.getValue()));
                    }
                }
                dto = new UserIdentityClaimsDO(userName, data);
                dto.setTenantId(tenantId);
                try {
                    super.store(dto, userStoreManager);
                }
                catch (IdentityException e) {
                    log.error((Object)"Error while reading user identity data", (Throwable)e);
                }
                userIdentityClaimsDO = dto;
                IdentityDatabaseUtil.closeResultSet((ResultSet)results);
            }
            catch (SQLException | UserStoreException e) {
                log.error((Object)"Error while reading user identity data", e);
                break block11;
            }
            finally {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            return userIdentityClaimsDO;
        }
        return null;
    }

    @Override
    public void remove(String userName, UserStoreManager userStoreManager) throws IdentityException {
        super.remove(userName, userStoreManager);
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            int tenantId = userStoreManager.getTenantId();
            boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
            String query = isUsernameCaseSensitive ? "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?" : "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, userName);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException | UserStoreException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    private static class SQLQuery {
        public static final String CHECK_EXIST_USER_DATA = "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ? AND DATA_KEY = ?";
        public static final String CHECK_EXIST_USER_DATA_CASE_INSENSITIVE = "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?) AND DATA_KEY = ?";
        public static final String STORE_USER_DATA = "INSERT INTO IDN_IDENTITY_USER_DATA (TENANT_ID, USER_NAME, DATA_KEY, DATA_VALUE) VALUES (?,?,?,?)";
        public static final String UPDATE_USER_DATA = "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND USER_NAME=? AND DATA_KEY=?";
        public static final String UPDATE_USER_DATA_CASE_INSENSITIVE = "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND LOWER(USER_NAME)=LOWER(?) AND DATA_KEY=?";
        public static final String LOAD_USER_DATA = "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?";
        public static final String LOAD_USER_DATA_CASE_INSENSITIVE = "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
        public static final String DELETE_USER_DATA = "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?";
        public static final String DELETE_USER_DATA_CASE_INSENSITIVE = "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";

        private SQLQuery() {
        }
    }
}

