/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.store;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class ArtifactDeleteThread
implements Runnable {
    private static Log log = LogFactory.getLog(ArtifactDeleteThread.class);
    private static final String USE_HASHED_USERNAME_PROPERTY = "UserInfoRecovery.UseHashedUserNames";
    private static final String USERNAME_HASH_ALG_PROPERTY = "UserInfoRecovery.UsernameHashAlg";
    private Registry registry = null;
    private String userName = null;
    private String secretKeyPath = null;
    private int tenantId = -1234;
    private boolean isDeleteAll = false;

    public ArtifactDeleteThread(Registry registry, String userName, String secretKeyPath, int tenantId, boolean isDeleteAll) {
        this.registry = registry;
        this.userName = userName;
        this.secretKeyPath = secretKeyPath;
        this.tenantId = tenantId;
        this.isDeleteAll = isDeleteAll;
    }

    @Override
    public void run() {
        this.deleteOldResourcesIfFound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldResourcesIfFound() {
        log.debug((Object)"---starting delete old resource task---");
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
        Collection collection = null;
        try {
            collection = (Collection)this.registry.get(this.secretKeyPath.toLowerCase());
        }
        catch (RegistryException e) {
            log.error((Object)"Error while deleting the old confirmation code. Unable to find data collection in registry.", (Throwable)e);
        }
        String userNameToValidate = this.userName;
        String useHashedUserName = IdentityMgtConfig.getInstance().getProperty(USE_HASHED_USERNAME_PROPERTY);
        if (Boolean.parseBoolean(useHashedUserName)) {
            String hashAlg = IdentityMgtConfig.getInstance().getProperty(USERNAME_HASH_ALG_PROPERTY);
            try {
                userNameToValidate = this.hashString(this.userName, hashAlg);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)("Invalid hash algorithm " + hashAlg), (Throwable)e);
            }
        }
        try {
            if (collection != null) {
                String[] resources = collection.getChildren();
                ArrayList<Resource> userResources = new ArrayList<Resource>();
                for (String resource : resources) {
                    String[] splittedResource = resource.split("___");
                    if (splittedResource.length == 3) {
                        if (!resource.contains("___" + userNameToValidate.toLowerCase() + "___")) continue;
                        if (!this.isDeleteAll) {
                            userResources.add(this.registry.get(resource));
                            continue;
                        }
                        this.deleteResource(this.registry.get(resource).getPath());
                        continue;
                    }
                    if (splittedResource.length != 2) continue;
                    this.deleteOldResourcesIfFound();
                }
                if (!this.isDeleteAll) {
                    Collections.sort(userResources, new Comparator<Resource>(){

                        @Override
                        public int compare(Resource r1, Resource r2) {
                            return Long.valueOf(Long.parseLong(r1.getProperty("expireTime"))).compareTo(Long.parseLong(r2.getProperty("expireTime")));
                        }
                    });
                    for (int i = 0; i < userResources.size() - 1; ++i) {
                        this.deleteResource(((Resource)userResources.get(i)).getPath());
                    }
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while deleting the old confirmation code", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        log.debug((Object)"---ending delete old resource task---");
    }

    private String hashString(String userName, String alg) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(alg);
        byte[] in = messageDigest.digest(userName.getBytes());
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    private void deleteResource(String resource) throws RegistryException {
        this.registry.beginTransaction();
        if (this.registry.resourceExists(resource)) {
            this.registry.delete(resource);
            this.registry.commitTransaction();
        } else {
            this.registry.rollbackTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Confirmation code already deleted in path of resource : " + resource));
            }
        }
    }
}

