/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.captcha.mgt.beans.CaptchaInfoBean;
import org.wso2.carbon.captcha.mgt.util.CaptchaUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityConstants;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.ChallengeQuestionProcessor;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtEventListener;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.RecoveryProcessor;
import org.wso2.carbon.identity.mgt.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionDTO;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionIdsDTO;
import org.wso2.carbon.identity.mgt.dto.NotificationDataDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesCollectionDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesDTO;
import org.wso2.carbon.identity.mgt.dto.UserDTO;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDTO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.util.UserIdentityManagementUtil;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserInformationRecoveryService {
    private static final Log log = LogFactory.getLog(UserInformationRecoveryService.class);

    public CaptchaInfoBean getCaptcha() throws IdentityMgtServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User get captcha image request received");
        }
        try {
            CaptchaUtil.cleanOldCaptchas();
            CaptchaInfoBean bean = CaptchaUtil.generateCaptchaImage();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Captcha stored: " + bean.getImagePath()));
                log.debug((Object)"Captcha generated successfully");
            }
            return bean;
        }
        catch (Exception e) {
            String errorMessage = "Error while generating captcha";
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityMgtServiceException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean verifyUser(String username, CaptchaInfoBean captcha) throws IdentityMgtServiceException {
        UserDTO userDTO;
        if (log.isDebugEnabled()) {
            log.debug((Object)("User verification request received with username : " + username));
        }
        if (IdentityMgtConfig.getInstance().isCaptchaVerificationInternallyManaged()) {
            try {
                CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captcha);
            }
            catch (Exception e) {
                VerificationBean bean = this.handleError("18004 Error while validating captcha", e);
                return bean;
            }
        }
        try {
            userDTO = Utils.processUserId(username);
        }
        catch (IdentityException e) {
            VerificationBean bean = this.handleError("18003 invalid user : " + username, (Exception)((Object)e));
            return bean;
        }
        try {
            RecoveryProcessor processor;
            VerificationBean bean;
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            if ((bean = (processor = IdentityMgtServiceComponent.getRecoveryProcessor()).verifyUserForRecovery(1, userDTO)).getError() != null) {
                bean = bean.getError().contains("18003") ? this.handleError("18003 User does not exist : " + username, null) : (bean.getError().contains("17003") ? this.handleError("17003 Account is disabled for user " + username + ". Can not allow to recover.", null) : this.handleError("18013 Error verifying user : " + username, null));
            }
            VerificationBean verificationBean = bean;
            return verificationBean;
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    public VerificationBean sendRecoveryNotification(String username, String key, String notificationType) throws IdentityMgtServiceException {
        return this.sendNotification(username, key, notificationType, "passwordReset");
    }

    public VerificationBean resendNotification(String username, String key, String notificationType) throws IdentityMgtServiceException {
        return this.sendNotification(username, key, notificationType, "resendNotification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerificationBean sendNotification(String username, String key, String notificationType, String notification) {
        UserDTO userDTO = null;
        VerificationBean bean = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("User recovery notification sending request received with username : " + username + " notification type :" + notificationType));
        }
        try {
            userDTO = Utils.processUserId(username);
        }
        catch (IdentityException e) {
            bean = this.handleError("18003 invalid user : " + username, (Exception)((Object)e));
            return bean;
        }
        RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
        try {
            Object carbonContext;
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            if (!(bean = processor.verifyConfirmationCode(1, userDTO.getUserId(), key)).isVerified()) {
                log.error((Object)("Invalid user is trying to recover the password with username : " + username));
                bean = this.handleError("18003 Invalid user is trying to recover the password with username : " + username, null);
                carbonContext = bean;
                return carbonContext;
            }
        }
        catch (IdentityException e1) {
            bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e1, username);
            if (bean.getError() == null) {
                bean = this.handleError("18001 Invalid confirmation code for user : " + username, (Exception)((Object)e1));
            }
            VerificationBean verificationBean = bean;
            return verificationBean;
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        UserRecoveryDTO dto = new UserRecoveryDTO(userDTO);
        dto.setNotification(notification);
        dto.setNotificationType(notificationType);
        NotificationDataDTO dataDTO = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initiating the notification sending process");
            }
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            dataDTO = processor.recoverWithNotification(dto);
            if (!IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) {
                bean.setNotificationData(dataDTO);
            }
        }
        catch (IdentityException e) {
            bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e, username);
            if (bean.getError() == null) {
                bean = this.handleError("18015: 18013 Error when sending recovery message for user: " + username, (Exception)((Object)e));
            }
            VerificationBean verificationBean = bean;
            return verificationBean;
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean verifyConfirmationCode(String username, String code, CaptchaInfoBean captcha) throws IdentityMgtServiceException {
        UserDTO userDTO;
        VerificationBean bean = new VerificationBean();
        if (log.isDebugEnabled()) {
            log.debug((Object)("User confirmation code verification request received with username :" + username));
        }
        if (IdentityMgtConfig.getInstance().isCaptchaVerificationInternallyManaged()) {
            try {
                CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captcha);
            }
            catch (Exception e) {
                bean = this.handleError("18001 Error while validating captcha for user : " + username, e);
                return bean;
            }
        }
        try {
            userDTO = Utils.processUserId(username);
        }
        catch (IdentityException e) {
            bean = this.handleError("18003 invalid user : " + username, (Exception)((Object)e));
            return bean;
        }
        RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
        if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(userDTO.getTenantId());
            carbonContext.setTenantDomain(userDTO.getTenantDomain());
        }
        try {
            bean = processor.verifyConfirmationCode(2, userDTO.getUserId(), code);
            if (bean.isVerified()) {
                bean = processor.updateConfirmationCode(3, userDTO.getUserId(), userDTO.getTenantId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User confirmation code verification successful for user: " + username));
                }
            } else {
                bean.setVerified(false);
                bean.setKey("");
                log.error((Object)bean.getError());
            }
        }
        catch (IdentityException e) {
            bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e, username);
            if (bean.getError() == null) {
                bean = this.handleError("18001 Error verifying confirmation code for user : " + username, (Exception)((Object)e));
            }
            VerificationBean verificationBean = bean;
            return verificationBean;
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean updatePassword(String username, String confirmationCode, String newPassword) throws IdentityMgtServiceException {
        RecoveryProcessor recoveryProcessor = IdentityMgtServiceComponent.getRecoveryProcessor();
        VerificationBean bean = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("User update password request received with username: " + username));
        }
        try {
            UserDTO userDTO = Utils.processUserId(username);
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            TenantManager tenantManager = IdentityMgtServiceComponent.getRealmService().getTenantManager();
            int tenantId = 0;
            try {
                tenantId = tenantManager.getTenantId(userDTO.getTenantDomain());
            }
            catch (UserStoreException e) {
                log.warn((Object)("No Tenant id for tenant domain " + userDTO.getTenantDomain()));
                VerificationBean verificationBean = this.handleError("18016 No Tenant id for tenant domain : " + userDTO.getTenantDomain(), (Exception)((Object)e));
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return verificationBean;
            }
            if (recoveryProcessor.verifyConfirmationCode(30, userDTO.getUserId(), confirmationCode).isVerified()) {
                Utils.updatePassword(userDTO.getUserId(), tenantId, newPassword);
                log.info((Object)("Credential is updated for user : " + userDTO.getUserId() + " and tenant domain : " + userDTO.getTenantDomain()));
                IdentityMgtConfig.getInstance().getRecoveryDataStore().invalidate(userDTO.getUserId(), tenantId);
                bean = new VerificationBean(true);
            } else if (recoveryProcessor.verifyConfirmationCode(3, userDTO.getUserId(), confirmationCode).isVerified()) {
                Utils.updatePassword(userDTO.getUserId(), tenantId, newPassword);
                log.info((Object)("Credential is updated for user : " + userDTO.getUserId() + " and tenant domain : " + userDTO.getTenantDomain()));
                IdentityMgtConfig.getInstance().getRecoveryDataStore().invalidate(userDTO.getUserId(), tenantId);
                bean = new VerificationBean(true);
            } else {
                String msg = "Invalid user tried to update credential with user Id : " + userDTO.getUserId() + " and tenant domain : " + userDTO.getTenantDomain();
                bean = new VerificationBean("18003 " + msg);
                bean.setVerified(false);
                log.error((Object)msg);
            }
        }
        catch (IdentityException e) {
            bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e, username);
            if (bean.getError() == null) {
                bean = this.handleError("18013 Error while updating credential for user: " + username, (Exception)((Object)e));
            }
            VerificationBean verificationBean = bean;
            return verificationBean;
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChallengeQuestionIdsDTO getUserChallengeQuestionIds(String username, String confirmation) throws IdentityMgtServiceException {
        ChallengeQuestionIdsDTO idsDTO;
        block21: {
            UserDTO userDTO = null;
            idsDTO = new ChallengeQuestionIdsDTO();
            if (log.isDebugEnabled()) {
                log.debug((Object)("User challenge questions id request received with username: " + username));
            }
            try {
                userDTO = Utils.processUserId(username);
            }
            catch (IdentityException e) {
                idsDTO = this.handleChallengeIdError("18003 Error validating user : " + username, (Exception)((Object)e));
                return idsDTO;
            }
            try {
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    carbonContext.setTenantId(userDTO.getTenantId());
                    carbonContext.setTenantDomain(userDTO.getTenantDomain());
                }
                RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
                VerificationBean bean = null;
                try {
                    bean = processor.verifyConfirmationCode(1, userDTO.getUserId(), confirmation);
                    if (bean.isVerified()) {
                        bean = processor.updateConfirmationCode(20, userDTO.getUserId(), userDTO.getTenantId());
                    } else {
                        bean.setVerified(false);
                    }
                }
                catch (IdentityException e1) {
                    idsDTO = UserIdentityManagementUtil.getCustomErrorMessagesForChallengeQuestionIds((Exception)((Object)e1), username);
                    if (idsDTO == null) {
                        idsDTO = this.handleChallengeIdError("18013 Error when validating code", (Exception)((Object)e1));
                    }
                    ChallengeQuestionIdsDTO challengeQuestionIdsDTO = idsDTO;
                    if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                    return challengeQuestionIdsDTO;
                }
                if (bean.isVerified()) {
                    try {
                        idsDTO = processor.getQuestionProcessor().getUserChallengeQuestionIds(userDTO.getUserId(), userDTO.getTenantId());
                        idsDTO.setKey(bean.getKey());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("User challenge question response successful for user: " + username));
                        }
                        break block21;
                    }
                    catch (Exception e) {
                        ChallengeQuestionIdsDTO challengeQuestionIdsDTO = idsDTO = this.handleChallengeIdError("18016 Error when getting user challenge questions for user : " + username, e);
                        if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                        return challengeQuestionIdsDTO;
                    }
                }
                String msg = "Verification failed for user. Error : " + bean.getError();
                log.error((Object)msg);
                idsDTO.setError("18013 " + msg);
                idsDTO.setKey("");
            }
            finally {
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        }
        return idsDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserChallengesDTO getUserChallengeQuestion(String userName, String confirmation, String questionId) throws IdentityMgtServiceException {
        UserDTO userDTO = null;
        UserChallengesDTO userChallengesDTO = new UserChallengesDTO();
        if (log.isDebugEnabled()) {
            log.debug((Object)("User challenge question request received with username :" + userName));
        }
        try {
            userDTO = Utils.processUserId(userName);
        }
        catch (IdentityException e) {
            return this.handleChallengesError("18003 Error validating user : " + userName, null);
        }
        try {
            VerificationBean bean;
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
            try {
                bean = processor.verifyConfirmationCode(20, userDTO.getUserId(), confirmation);
                if (bean.isVerified()) {
                    bean = processor.updateConfirmationCode(40, userDTO.getUserId(), userDTO.getTenantId());
                } else if (processor.verifyConfirmationCode(30, userDTO.getUserId(), confirmation).isVerified()) {
                    bean = processor.updateConfirmationCode(40, userDTO.getUserId(), userDTO.getTenantId());
                } else {
                    bean.setVerified(false);
                }
            }
            catch (IdentityException e) {
                userChallengesDTO = UserIdentityManagementUtil.getCustomErrorMessagesForChallengQuestions(e, userName);
                if (userChallengesDTO == null) {
                    userChallengesDTO = this.handleChallengesError("18001 Invalid confirmation code for user : " + userName, (Exception)((Object)e));
                }
                UserChallengesDTO userChallengesDTO2 = userChallengesDTO;
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return userChallengesDTO2;
            }
            if (bean.isVerified()) {
                userChallengesDTO = processor.getQuestionProcessor().getUserChallengeQuestion(userDTO.getUserId(), userDTO.getTenantId(), questionId);
                userChallengesDTO.setKey(bean.getKey());
                userChallengesDTO.setVerfied(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User challenge question retrieved successfully");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Verification failed for user. Error : " + bean.getError()));
                }
                userChallengesDTO.setError("18003 " + bean.getError());
            }
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return userChallengesDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserChallengesCollectionDTO getUserChallengeQuestions(String userName, String confirmation) throws IdentityMgtServiceException {
        UserChallengesCollectionDTO userChallengesCollectionDTO;
        block21: {
            UserDTO userDTO = null;
            userChallengesCollectionDTO = new UserChallengesCollectionDTO();
            if (log.isDebugEnabled()) {
                log.debug((Object)("User challenge question request received with username :" + userName));
            }
            try {
                userDTO = Utils.processUserId(userName);
            }
            catch (IdentityException e) {
                log.error((Object)("Error while validating user " + userName), (Throwable)e);
                return UserIdentityManagementUtil.handleChallengeQuestionSetError("18003 Error validating user : " + userName, null);
            }
            try {
                VerificationBean bean;
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    carbonContext.setTenantId(userDTO.getTenantId());
                    carbonContext.setTenantDomain(userDTO.getTenantDomain());
                }
                RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
                try {
                    bean = processor.verifyConfirmationCode(1, userDTO.getUserId(), confirmation);
                    if (bean.isVerified()) {
                        bean = processor.updateConfirmationCode(20, userDTO.getUserId(), userDTO.getTenantId());
                    } else {
                        bean.setVerified(false);
                    }
                }
                catch (IdentityException e) {
                    log.error((Object)"Error while verifying confirmation code.", (Throwable)e);
                    UserChallengesCollectionDTO userChallengesCollectionDTO2 = UserIdentityManagementUtil.getCustomErrorMessagesForChallengeQuestionSet(e, userName);
                    if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                    return userChallengesCollectionDTO2;
                }
                if (bean.isVerified()) {
                    UserChallengesDTO[] userChallengesDTOs = null;
                    try {
                        userChallengesDTOs = processor.getQuestionProcessor().getUserChallengeQuestions(userDTO.getUserId(), userDTO.getTenantId());
                        userChallengesCollectionDTO.setKey(bean.getKey());
                        userChallengesCollectionDTO.setUserChallengesDTOs(userChallengesDTOs);
                    }
                    catch (IdentityException e) {
                        log.error((Object)("Error while retrieving challenge questions of the user " + userName), (Throwable)e);
                        UserChallengesCollectionDTO userChallengesCollectionDTO3 = UserIdentityManagementUtil.handleChallengeQuestionSetError("18016 No associated challenge questions found for the user : " + userName, null);
                        if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                        return userChallengesCollectionDTO3;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User challenge questions retrieved successfully");
                    }
                    break block21;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Verification failed for user. Error : " + bean.getError()));
                }
                userChallengesCollectionDTO.setError("18003 " + bean.getError());
            }
            finally {
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        }
        return userChallengesCollectionDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean verifyUserChallengeAnswer(String userName, String confirmation, String questionId, String answer) throws IdentityMgtServiceException {
        VerificationBean bean = new VerificationBean();
        bean.setVerified(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User challenge answer request received with username :" + userName));
        }
        if (questionId == null || answer == null) {
            String error = "No challenge question id provided for verification";
            bean.setError(error);
            if (log.isDebugEnabled()) {
                log.debug((Object)error);
            }
            return bean;
        }
        UserDTO userDTO = null;
        try {
            userDTO = Utils.processUserId(userName);
        }
        catch (IdentityException e) {
            bean = this.handleError("18003 Error verifying user: " + userName, (Exception)((Object)e));
            return bean;
        }
        try {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            RecoveryProcessor recoveryProcessor = IdentityMgtServiceComponent.getRecoveryProcessor();
            try {
                bean = recoveryProcessor.verifyConfirmationCode(40, userDTO.getUserId(), confirmation);
                if (bean.isVerified()) {
                    bean = recoveryProcessor.updateConfirmationCode(30, userDTO.getUserId(), userDTO.getTenantId());
                } else {
                    bean.setVerified(false);
                }
            }
            catch (IdentityException e) {
                bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e, userName);
                if (bean == null) {
                    bean = this.handleError("18001  Error verifying confirmation code for user : " + userName, (Exception)((Object)e));
                }
                VerificationBean verificationBean = bean;
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return verificationBean;
            }
            ChallengeQuestionProcessor processor = recoveryProcessor.getQuestionProcessor();
            UserChallengesDTO userChallengesDTO = new UserChallengesDTO();
            userChallengesDTO.setId(questionId);
            userChallengesDTO.setAnswer(answer);
            boolean verification = processor.verifyUserChallengeAnswer(userDTO.getUserId(), userDTO.getTenantId(), userChallengesDTO);
            if (verification) {
                bean.setError("");
                bean.setUserId(userName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User answer verification successful for user: " + userName));
                }
            } else {
                bean.setError("Challenge answer verification failed for user : " + userName);
                bean.setVerified(false);
                bean.setKey("");
                log.error((Object)bean.getError());
            }
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean verifyUserChallengeAnswers(String userName, String confirmation, UserChallengesDTO[] userChallengesDTOs) throws IdentityMgtServiceException {
        UserDTO userDTO;
        VerificationBean bean = new VerificationBean();
        bean.setVerified(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User challenge answers request received with username :" + userName));
        }
        if (ArrayUtils.isEmpty((Object[])userChallengesDTOs)) {
            String errorMsg = "No challenge question id provided for verification";
            bean.setError(errorMsg);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMsg);
            }
            return bean;
        }
        try {
            userDTO = Utils.processUserId(userName);
        }
        catch (IdentityException e) {
            bean = this.handleError("18003 Error verifying user: " + userName, (Exception)((Object)e));
            return bean;
        }
        try {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            RecoveryProcessor recoveryProcessor = IdentityMgtServiceComponent.getRecoveryProcessor();
            try {
                bean = recoveryProcessor.verifyConfirmationCode(20, userDTO.getUserId(), confirmation);
                if (bean.isVerified()) {
                    bean = recoveryProcessor.updateConfirmationCode(30, userDTO.getUserId(), userDTO.getTenantId());
                } else {
                    bean.setVerified(false);
                }
            }
            catch (IdentityException e) {
                log.error((Object)"Error while verifying confirmation code.", (Throwable)e);
                bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e, userName);
                if (bean == null) {
                    bean = this.handleError("18001  Error verifying confirmation code for user : " + userName, (Exception)((Object)e));
                }
                VerificationBean verificationBean = bean;
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return verificationBean;
            }
            ChallengeQuestionProcessor processor = recoveryProcessor.getQuestionProcessor();
            boolean verification = processor.verifyUserChallengeAnswers(userDTO.getUserId(), userDTO.getTenantId(), userChallengesDTOs);
            if (verification) {
                bean.setError("");
                bean.setUserId(userName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User answer verification successful for user: " + userName));
                }
            } else {
                bean.setError("Verification failed for one or more answers provided by user : " + userName);
                bean.setVerified(false);
                bean.setKey("");
                if (log.isDebugEnabled()) {
                    log.debug((Object)bean.getError());
                }
            }
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return bean;
    }

    public ChallengeQuestionDTO[] getAllChallengeQuestions() throws IdentityMgtServiceException {
        ChallengeQuestionProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor();
        List<ChallengeQuestionDTO> questionDTOs = null;
        try {
            questionDTOs = processor.getAllChallengeQuestions();
        }
        catch (IdentityException e) {
            log.error((Object)"Error while loading user challenges", (Throwable)e);
            throw new IdentityMgtServiceException("Error while loading user challenges");
        }
        return questionDTOs.toArray(new ChallengeQuestionDTO[questionDTOs.size()]);
    }

    public UserIdentityClaimDTO[] getUserIdentitySupportedClaims(String dialect) throws IdentityException {
        IdentityClaimManager claimManager = null;
        Claim[] claims = null;
        UserRealm realm = null;
        claimManager = IdentityClaimManager.getInstance();
        claims = claimManager.getAllSupportedClaims(dialect, realm = IdentityTenantUtil.getRealm(null, null));
        if (claims == null || claims.length == 0) {
            log.warn((Object)("Could not find any matching claims for requested dialect : " + dialect));
            return new UserIdentityClaimDTO[0];
        }
        ArrayList<UserIdentityClaimDTO> claimList = new ArrayList<UserIdentityClaimDTO>();
        for (int i = 0; i < claims.length; ++i) {
            if (claims[i].getDisplayTag() == null || IdentityConstants.PPID_DISPLAY_VALUE.equals(claims[i].getDisplayTag()) || "http://wso2.org/claims/identity/accountLock".equals(claims[i].getClaimUri()) || !claims[i].isSupportedByDefault() || claims[i].isReadOnly()) continue;
            UserIdentityClaimDTO claimDto = new UserIdentityClaimDTO();
            claimDto.setClaimUri(claims[i].getClaimUri());
            claimDto.setClaimValue(claims[i].getValue());
            claimDto.setRequired(claims[i].isRequired());
            claimDto.setDisplayName(claims[i].getDisplayTag());
            claimList.add(claimDto);
        }
        return claimList.toArray(new UserIdentityClaimDTO[claimList.size()]);
    }

    public VerificationBean verifyAccount(UserIdentityClaimDTO[] claims, CaptchaInfoBean captcha, String tenantDomain) throws IdentityMgtServiceException {
        VerificationBean vBean = new VerificationBean();
        if (IdentityMgtConfig.getInstance().isCaptchaVerificationInternallyManaged()) {
            try {
                CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captcha);
            }
            catch (Exception e) {
                vBean = this.handleError("18004 Error processing captcha", e);
                return vBean;
            }
        }
        if (!IdentityMgtConfig.getInstance().isSaasEnabled()) {
            String loggedInTenant = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (tenantDomain != null && !tenantDomain.isEmpty() && !loggedInTenant.equals(tenantDomain)) {
                String msg = "Trying to verify account unauthorized tenant space";
                log.error((Object)msg);
                throw new IdentityMgtServiceException(msg);
            }
            if (tenantDomain == null || tenantDomain.isEmpty()) {
                tenantDomain = loggedInTenant;
            }
        }
        try {
            int tenantId = Utils.getTenantId(tenantDomain);
            String userName = UserIdentityManagementUtil.getUsernameByClaims(claims, tenantId);
            if (userName != null) {
                UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
                userDTO.setTenantId(tenantId);
                UserRecoveryDTO dto = new UserRecoveryDTO(userDTO);
                dto.setNotification("accountIdRecovery");
                dto.setNotificationType("EMAIL");
                RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
                NotificationDataDTO notificationDto = processor.notifyWithEmail(dto);
                vBean.setVerified(notificationDto.isNotificationSent());
                if (!IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) {
                    vBean.setNotificationData(notificationDto);
                }
            } else {
                vBean.setError("User not found");
                vBean.setVerified(false);
            }
        }
        catch (Exception e) {
            vBean = this.handleError("18003 Error verifying user account", e);
            return vBean;
        }
        return vBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean registerUser(String userName, String password, UserIdentityClaimDTO[] claims, String profileName, String tenantDomain) throws IdentityMgtServiceException {
        int tenantId;
        VerificationBean vBean = new VerificationBean();
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        Permission permission = null;
        if (!IdentityMgtConfig.getInstance().isSaasEnabled()) {
            String loggedInTenant = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (tenantDomain != null && !tenantDomain.isEmpty() && !loggedInTenant.equals(tenantDomain)) {
                String msg = "Trying to create users in unauthorized tenant space";
                log.error((Object)msg);
                throw new IdentityMgtServiceException(msg);
            }
            if (tenantDomain == null || tenantDomain.isEmpty()) {
                tenantDomain = loggedInTenant;
            }
        }
        RealmService realmService = IdentityMgtServiceComponent.getRealmService();
        try {
            tenantId = Utils.getTenantId(tenantDomain);
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (Exception e) {
            vBean = this.handleError("18013 Error retrieving the user store manager for the tenant", e);
            return vBean;
        }
        try {
            Object carbonContext;
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(tenantId);
                carbonContext.setTenantDomain(tenantDomain);
            }
            if (userStoreManager == null) {
                vBean = new VerificationBean();
                vBean.setVerified(false);
                vBean.setError("18013 Error retrieving the user store manager for the tenant");
                carbonContext = vBean;
                return carbonContext;
            }
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            for (UserIdentityClaimDTO userIdentityClaimDTO : claims) {
                claimsMap.put(userIdentityClaimDTO.getClaimUri(), userIdentityClaimDTO.getClaimValue());
            }
            userStoreManager.addUser(userName, (Object)password, null, claimsMap, profileName);
            String identityRoleName = "Internal" + CarbonConstants.DOMAIN_SEPARATOR + "identity";
            if (!userStoreManager.isExistingRole(identityRoleName, false)) {
                permission = new Permission("/permission/admin/login", "ui.execute");
                userStoreManager.addRole(identityRoleName, new String[]{userName}, (org.wso2.carbon.user.api.Permission[])new Permission[]{permission}, false);
            } else {
                userStoreManager.updateUserListOfRole(identityRoleName, new String[0], new String[]{userName});
            }
            String listenerClassName = IdentityMgtConfig.getInstance().getProperty("Identity.Listener.Class");
            if (StringUtils.isBlank((String)listenerClassName)) {
                listenerClassName = IdentityMgtEventListener.class.getName();
            }
            IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)UserOperationEventListener.class.getName(), (String)listenerClassName);
            boolean isListenerEnable = true;
            if (identityEventListenerConfig != null && StringUtils.isNotBlank((String)identityEventListenerConfig.getEnable())) {
                isListenerEnable = Boolean.parseBoolean(identityEventListenerConfig.getEnable());
            }
            IdentityMgtConfig config = IdentityMgtConfig.getInstance();
            if (isListenerEnable && config.isAuthPolicyAccountLockOnCreation()) {
                UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
                userDTO.setTenantId(tenantId);
                UserRecoveryDTO dto = new UserRecoveryDTO(userDTO);
                dto.setNotification("accountConfirmation");
                dto.setNotificationType("EMAIL");
                RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
                vBean = processor.updateConfirmationCode(1, userName, tenantId);
                dto.setConfirmationCode(vBean.getKey());
                NotificationDataDTO notificationDto = processor.notifyWithEmail(dto);
                vBean.setVerified(notificationDto.isNotificationSent());
                if (!IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) {
                    vBean.setNotificationData(notificationDto);
                }
            } else {
                vBean.setVerified(true);
            }
        }
        catch (IdentityException | UserStoreException e) {
            vBean = UserIdentityManagementUtil.getCustomErrorMessagesWhenRegistering((Exception)e, userName);
            try {
                if (!e.getMessage().contains("UserAlreadyExisting") && userStoreManager.isExistingUser(userName)) {
                    userStoreManager.deleteUser(userName);
                }
            }
            catch (UserStoreException e1) {
                vBean = UserIdentityManagementUtil.getCustomErrorMessagesWhenRegistering((Exception)((Object)e1), userName);
            }
            VerificationBean verificationBean = vBean;
            return verificationBean;
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return vBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean resendSignUpConfiramtionCode(String userName, String code, String profileName, String tenantDomain) throws IdentityMgtServiceException {
        int tenantId;
        VerificationBean vBean = new VerificationBean();
        RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
        if (!IdentityMgtConfig.getInstance().isSaasEnabled()) {
            String loggedInTenant = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (tenantDomain != null && !tenantDomain.isEmpty() && !loggedInTenant.equals(tenantDomain)) {
                String msg = "Trying to resend self sign up code  in unauthorized tenant space";
                log.error((Object)msg);
                throw new IdentityMgtServiceException(msg);
            }
            if (tenantDomain == null || tenantDomain.isEmpty()) {
                tenantDomain = loggedInTenant;
            }
        }
        try {
            tenantId = Utils.getTenantId(tenantDomain);
        }
        catch (IdentityException e) {
            vBean = this.handleError("18013 Error while resending confirmation code", (Exception)((Object)e));
            return vBean;
        }
        try {
            Object carbonContext;
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(tenantId);
                carbonContext.setTenantDomain(tenantDomain);
            }
            try {
                vBean = processor.verifyConfirmationCode(1, userName, code);
                if (!vBean.isVerified()) {
                    vBean.setError("18001");
                    carbonContext = vBean;
                    return carbonContext;
                }
            }
            catch (IdentityException e) {
                VerificationBean verificationBean = vBean = this.handleError("Error while validating confirmation code for user : " + userName, (Exception)((Object)e));
                return verificationBean;
            }
            try {
                String listenerClassName = IdentityMgtConfig.getInstance().getProperty("Identity.Listener.Class");
                if (StringUtils.isBlank((String)listenerClassName)) {
                    listenerClassName = IdentityMgtEventListener.class.getName();
                }
                IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)UserOperationEventListener.class.getName(), (String)listenerClassName);
                boolean isListenerEnable = true;
                if (identityEventListenerConfig != null && StringUtils.isNotBlank((String)identityEventListenerConfig.getEnable())) {
                    isListenerEnable = Boolean.parseBoolean(identityEventListenerConfig.getEnable());
                }
                IdentityMgtConfig config = IdentityMgtConfig.getInstance();
                if (isListenerEnable && config.isAuthPolicyAccountLockOnCreation()) {
                    UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
                    userDTO.setTenantId(tenantId);
                    UserRecoveryDTO dto = new UserRecoveryDTO(userDTO);
                    dto.setNotification("accountConfirmation");
                    dto.setNotificationType("EMAIL");
                    vBean = processor.updateConfirmationCode(1, userName, tenantId);
                    dto.setConfirmationCode(vBean.getKey());
                    NotificationDataDTO notificationDto = processor.notifyWithEmail(dto);
                    vBean.setVerified(notificationDto.isNotificationSent());
                    if (!IdentityMgtConfig.getInstance().isNotificationInternallyManaged()) {
                        vBean.setNotificationData(notificationDto);
                    }
                } else {
                    vBean.setVerified(true);
                }
            }
            catch (IdentityException e) {
                VerificationBean verificationBean = vBean = UserIdentityManagementUtil.getCustomErrorMessagesWhenRegistering((Exception)((Object)e), userName);
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return verificationBean;
            }
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return vBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationBean confirmUserSelfRegistration(String username, String code, CaptchaInfoBean captcha, String tenantDomain) throws IdentityMgtServiceException {
        VerificationBean bean = new VerificationBean();
        if (log.isDebugEnabled()) {
            log.debug((Object)("User registration verification request received with username :" + username));
        }
        if (IdentityMgtConfig.getInstance().isCaptchaVerificationInternallyManaged()) {
            try {
                CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captcha);
            }
            catch (Exception e) {
                bean = this.handleError("18004 Error while validating captcha for user : " + username, e);
                return bean;
            }
        }
        if (!IdentityMgtConfig.getInstance().isSaasEnabled()) {
            String loggedInTenant = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (tenantDomain != null && !tenantDomain.isEmpty() && !loggedInTenant.equals(tenantDomain)) {
                String msg = "Trying to confirm users in unauthorized tenant space";
                log.error((Object)msg);
                return this.handleError("18016 " + msg, null);
            }
            if (tenantDomain == null || tenantDomain.isEmpty()) {
                tenantDomain = loggedInTenant;
            }
        }
        UserDTO userDTO = null;
        try {
            userDTO = Utils.processUserId(username + "@" + tenantDomain);
        }
        catch (IdentityException e) {
            bean = this.handleError("18003 Error verifying user account for user : " + username, (Exception)((Object)e));
            return bean;
        }
        try {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(userDTO.getTenantId());
                carbonContext.setTenantDomain(userDTO.getTenantDomain());
            }
            RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
            org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
            RealmService realmService = IdentityMgtServiceComponent.getRealmService();
            try {
                int tenantId = Utils.getTenantId(tenantDomain);
                if (realmService.getTenantUserRealm(tenantId) != null) {
                    userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
                    if (username != null && username.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                        userStoreManager = userStoreManager.getSecondaryUserStoreManager(Utils.getUserStoreDomainName(username));
                    }
                }
            }
            catch (Exception e) {
                VerificationBean verificationBean = bean = this.handleError("18013Error retrieving the user store manager for the tenant : " + tenantDomain, e);
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return verificationBean;
            }
            try {
                bean = processor.verifyConfirmationCode(1, username, code);
                if (bean.isVerified()) {
                    UserIdentityManagementUtil.unlockUserAccount(username, (UserStoreManager)userStoreManager);
                    bean.setVerified(true);
                } else {
                    bean.setVerified(false);
                    bean.setKey("");
                    log.error((Object)"User verification failed against the given confirmation code");
                }
            }
            catch (IdentityException e) {
                bean = UserIdentityManagementUtil.getCustomErrorMessagesToVerifyCode(e, username);
                if (bean.getError() == null) {
                    bean = this.handleError("Error while validating confirmation code for user : " + username, (Exception)((Object)e));
                }
                VerificationBean verificationBean = bean;
                if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return verificationBean;
            }
        }
        finally {
            if (IdentityMgtConfig.getInstance().isSaasEnabled()) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return bean;
    }

    private VerificationBean handleError(String error, Exception e) {
        VerificationBean bean = new VerificationBean();
        bean.setVerified(false);
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bean;
    }

    private UserChallengesDTO handleChallengesError(String error, Exception e) {
        UserChallengesDTO bean = new UserChallengesDTO();
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bean;
    }

    private ChallengeQuestionIdsDTO handleChallengeIdError(String error, Exception e) {
        ChallengeQuestionIdsDTO bean = new ChallengeQuestionIdsDTO();
        if (error != null) {
            bean.setError(error);
            log.error((Object)error, (Throwable)e);
        } else {
            bean.setError(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bean;
    }
}

