/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.services;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.captcha.mgt.beans.CaptchaInfoBean;
import org.wso2.carbon.captcha.mgt.util.CaptchaUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.ChallengeQuestionProcessor;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.RecoveryProcessor;
import org.wso2.carbon.identity.mgt.beans.UserIdentityMgtBean;
import org.wso2.carbon.identity.mgt.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.dto.NotificationDataDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesDTO;
import org.wso2.carbon.identity.mgt.dto.UserDTO;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDataDO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.util.UserIdentityManagementUtil;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserIdentityManagementService {
    private static final Log log = LogFactory.getLog(UserIdentityManagementService.class);

    public UserIdentityClaimDTO[] authenticateWithTemporaryCredentials(String userName, String tempCredential) throws IdentityMgtServiceException {
        try {
            int tenantId = Utils.getTenantId(MultitenantUtils.getTenantDomain((String)userName));
            boolean isValid = UserIdentityManagementUtil.isValidIdentityMetadata(userName, tenantId, "TEMPORARY_CREDENTIAL", tempCredential);
            if (!isValid) {
                log.warn((Object)("WARNING: Invalidated temporary credential provided by " + userName));
                throw new IdentityMgtServiceException("Invalid temporary credential provided");
            }
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            userStoreManager.authenticate(userName, (Object)tempCredential);
            UserIdentityManagementUtil.invalidateUserIdentityMetadata(userName, tenantId, "TEMPORARY_CREDENTIAL", tempCredential);
            return UserIdentityManagementUtil.getAllUserIdentityClaims(userName);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while authenticating", (Throwable)e);
            throw new IdentityMgtServiceException("Error while authenticating the user");
        }
        catch (IdentityException e) {
            log.error((Object)"Error while authenticating", (Throwable)e);
            throw new IdentityMgtServiceException("Error while authenticating the user");
        }
    }

    public UserIdentityClaimDTO[] confirmUserRegistration(String userName, String confirmationCode) throws IdentityMgtServiceException {
        try {
            int tenantId = Utils.getTenantId(MultitenantUtils.getTenantDomain((String)userName));
            boolean isValid = UserIdentityManagementUtil.isValidIdentityMetadata(userName, tenantId, "CONFIRMATION_CODE", confirmationCode);
            if (!isValid) {
                log.warn((Object)("WARNING: Invalid confirmation code provided by " + userName));
                throw new IdentityMgtServiceException("Invalid confirmation code provided");
            }
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            UserIdentityManagementUtil.unlockUserAccount(userName, userStoreManager);
            UserIdentityManagementUtil.invalidateUserIdentityMetadata(userName, tenantId, "CONFIRMATION_CODE", confirmationCode);
            return UserIdentityManagementUtil.getAllUserIdentityClaims(userName);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while confirming the account", (Throwable)e);
            throw new IdentityMgtServiceException("Error while confirming the account");
        }
        catch (IdentityException e) {
            log.error((Object)"Error while confirming the account", (Throwable)e);
            throw new IdentityMgtServiceException("Error while confirming the account");
        }
    }

    public void recoverUserIdentityWithSecurityQuestions(String userName, UserIdentityClaimDTO[] secQuesAnsweres) throws IdentityMgtServiceException {
        try {
            int tenantId = Utils.getTenantId(MultitenantUtils.getTenantDomain((String)userName));
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            UserIdentityClaimDTO[] storedSecQuesAnswers = UserIdentityManagementUtil.getUserSecurityQuestions(userName, userStoreManager);
            if (secQuesAnsweres.length < storedSecQuesAnswers.length) {
                throw new IdentityMgtServiceException("All questions must be answered");
            }
            int numberOfAnsweredQuestions = 0;
            for (UserIdentityClaimDTO storedSecQues : storedSecQuesAnswers) {
                for (UserIdentityClaimDTO answredSecQues : secQuesAnsweres) {
                    if (!answredSecQues.getClaimUri().trim().equals(storedSecQues.getClaimUri().trim())) continue;
                    if (!answredSecQues.getClaimValue().trim().equals(storedSecQues.getClaimValue().trim())) {
                        throw new IdentityMgtServiceException("Invalid answeres. Identity recovery failed");
                    }
                    ++numberOfAnsweredQuestions;
                }
            }
            if (numberOfAnsweredQuestions < storedSecQuesAnswers.length) {
                throw new IdentityMgtServiceException("All questions must be answered");
            }
            char[] tempPassword = UserIdentityManagementUtil.generateTemporaryPassword();
            userStoreManager.updateCredentialByAdmin(userName, (Object)tempPassword);
            UserRecoveryDataDO metadataDO = new UserRecoveryDataDO();
            metadataDO.setUserName(userName).setTenantId(tenantId).setCode(new String(tempPassword));
            UserIdentityManagementUtil.storeUserIdentityMetadata(metadataDO);
            UserIdentityMgtBean bean = new UserIdentityMgtBean();
            String email = userStoreManager.getUserClaimValue(userName, IdentityMgtConfig.getInstance().getAccountRecoveryClaim(), null);
            log.debug((Object)("Sending email to " + email));
            bean.setUserId(userName).setUserTemporaryPassword(new String(tempPassword)).setEmail(email);
            UserIdentityManagementUtil.notifyViaEmail(bean);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while recovering user identity", (Throwable)e);
            throw new IdentityMgtServiceException("Error while recovering user identity");
        }
        catch (IdentityException e) {
            log.error((Object)"Error while recovering user identity", (Throwable)e);
            throw new IdentityMgtServiceException("Error while recovering user identity");
        }
    }

    public void recoverUserIdentityWithEmail(String userName) throws IdentityMgtServiceException {
        try {
            int tenantId = Utils.getTenantId(MultitenantUtils.getTenantDomain((String)userName));
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            char[] tempPassword = UserIdentityManagementUtil.generateTemporaryPassword();
            userStoreManager.updateCredentialByAdmin(userName, (Object)new String(tempPassword));
            UserIdentityMgtBean bean = new UserIdentityMgtBean();
            String email = userStoreManager.getUserClaimValue(userName, IdentityMgtConfig.getInstance().getAccountRecoveryClaim(), null);
            log.debug((Object)("Sending email to " + email));
            bean.setUserId(userName).setUserTemporaryPassword(new String(tempPassword)).setEmail(email);
            UserIdentityManagementUtil.notifyViaEmail(bean);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while recovering user identity", (Throwable)e);
            throw new IdentityMgtServiceException("Error while recovering user identity");
        }
        catch (IdentityException e) {
            log.error((Object)"Error while recovering user identity", (Throwable)e);
            throw new IdentityMgtServiceException("Error while recovering user identity");
        }
    }

    public String[] getPrimarySecurityQuestions() throws IdentityMgtServiceException {
        try {
            return UserIdentityManagementUtil.getPrimaryQuestions(-1234);
        }
        catch (IdentityException e) {
            throw new IdentityMgtServiceException("Error while reading security questions", e);
        }
    }

    public VerificationBean confirmUserAccount(String confirmationKey) {
        return IdentityMgtServiceComponent.getRecoveryProcessor().verifyConfirmationKey(confirmationKey);
    }

    public boolean processPasswordRecovery(String userId, String confirmationCode, String notificationType) throws IdentityMgtServiceException {
        UserDTO userDTO = null;
        try {
            userDTO = Utils.processUserId(userId);
        }
        catch (IdentityException e) {
            throw new IdentityMgtServiceException("invalid user name", e);
        }
        RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
        VerificationBean bean = processor.verifyConfirmationKey(confirmationCode);
        if (!bean.isVerified()) {
            log.warn((Object)("Invalid user is trying to recover the password : " + userId));
            return false;
        }
        UserRecoveryDTO dto = new UserRecoveryDTO(userDTO);
        dto.setNotification("passwordReset");
        dto.setNotificationType(notificationType);
        NotificationDataDTO dataDTO = null;
        try {
            dataDTO = processor.recoverWithNotification(dto);
        }
        catch (IdentityException e) {
            throw new IdentityMgtServiceException("Error while password recovery.", e);
        }
        return dataDTO.isNotificationSent();
    }

    public UserChallengesDTO[] getChallengeQuestionsForUser(String userName, String confirmation) throws IdentityMgtServiceException {
        UserDTO userDTO = null;
        try {
            userDTO = Utils.processUserId(userName);
        }
        catch (IdentityException e) {
            throw new IdentityMgtServiceException("Invalid user name.", e);
        }
        RecoveryProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor();
        VerificationBean bean = processor.verifyConfirmationKey(confirmation);
        if (bean.isVerified()) {
            try {
                processor.createConfirmationCode(userDTO, confirmation);
            }
            catch (IdentityException e) {
                log.error((Object)"Error in creating confirmation code.", (Throwable)e);
            }
            return processor.getQuestionProcessor().getChallengeQuestionsOfUser(userDTO.getUserId(), userDTO.getTenantId(), false);
        }
        return new UserChallengesDTO[0];
    }

    public VerificationBean verifyChallengeQuestion(String userName, String confirmation, UserChallengesDTO[] userChallengesDTOs) throws IdentityMgtServiceException {
        VerificationBean bean = new VerificationBean();
        bean.setVerified(false);
        RecoveryProcessor recoveryProcessor = IdentityMgtServiceComponent.getRecoveryProcessor();
        if (userChallengesDTOs == null || userChallengesDTOs.length < 1) {
            log.error((Object)"no challenges provided by user for verifications.");
            bean.setError("no challenges provided by user for verifications.");
            return bean;
        }
        UserDTO userDTO = null;
        try {
            userDTO = Utils.processUserId(userName);
        }
        catch (IdentityException e) {
            throw new IdentityMgtServiceException("Invalid user name.", e);
        }
        if (recoveryProcessor.verifyConfirmationKey(confirmation).isVerified()) {
            log.warn((Object)"Invalid user is trying to verify user challenges.");
            bean.setError("Invalid user is trying to verify user challenges.");
            return bean;
        }
        ChallengeQuestionProcessor processor = recoveryProcessor.getQuestionProcessor();
        boolean verification = processor.verifyChallengeQuestion(userDTO.getUserId(), userDTO.getTenantId(), userChallengesDTOs);
        if (verification) {
            String code = UUID.randomUUID().toString();
            try {
                recoveryProcessor.createConfirmationCode(userDTO, code);
            }
            catch (IdentityException e) {
                log.error((Object)"Error while creating confirmation code.", (Throwable)e);
            }
            bean = new VerificationBean(userName, code);
        }
        return bean;
    }

    public VerificationBean updateCredential(String userName, String confirmation, String password, CaptchaInfoBean captchaInfoBean) {
        RecoveryProcessor recoveryProcessor = IdentityMgtServiceComponent.getRecoveryProcessor();
        if (IdentityMgtConfig.getInstance().isCaptchaVerificationInternallyManaged()) {
            try {
                CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captchaInfoBean);
            }
            catch (Exception e) {
                log.error((Object)"Error while processing captcha bean.", (Throwable)e);
                return new VerificationBean("18004");
            }
        }
        try {
            UserDTO userDTO = Utils.processUserId(userName);
            if (recoveryProcessor.verifyConfirmationKey(confirmation).isVerified()) {
                Utils.updatePassword(userDTO.getUserId(), userDTO.getTenantId(), password);
                log.info((Object)("Credential is updated for user : " + userDTO.getUserId() + " and tenant domain : " + userDTO.getTenantDomain()));
                return new VerificationBean(true);
            }
            log.warn((Object)("Invalid user tried to update credential with user Id : " + userDTO.getUserId() + " and tenant domain : " + userDTO.getTenantDomain()));
        }
        catch (Exception e) {
            log.error((Object)("Error while updating credential for user : " + userName), (Throwable)e);
        }
        return new VerificationBean("18013");
    }
}

