/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.ChallengeQuestionProcessor;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.dto.ChallengeQuestionDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesDTO;
import org.wso2.carbon.identity.mgt.dto.UserChallengesSetDTO;
import org.wso2.carbon.identity.mgt.dto.UserDTO;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimDTO;
import org.wso2.carbon.identity.mgt.dto.UserRecoveryDTO;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.util.UserIdentityManagementUtil;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UserIdentityManagementAdminService {
    private static final Log log = LogFactory.getLog(UserIdentityManagementAdminService.class);
    private static final Log audit = CarbonConstants.AUDIT_LOG;
    private static String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ";
    private final String SUCCESS = "Success";

    public void deleteUser(String userName) throws IdentityMgtServiceException {
        try {
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId()).getUserStoreManager();
            userStoreManager.deleteUser(userName);
            log.info((Object)("Deleted user: " + userName));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error occured while deleting user : " + userName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityMgtServiceException(errorMessage);
        }
    }

    public void lockUserAccount(String userName) throws IdentityMgtServiceException {
        try {
            UserStoreManager userStoreManager = this.getUserStore(userName);
            String userNameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
            UserIdentityManagementUtil.lockUserAccount(userNameWithoutDomain, userStoreManager);
            log.info((Object)("User account locked: " + userName));
        }
        catch (IdentityException | org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)("Error occurred while trying to lock the account " + userName), e);
            throw new IdentityMgtServiceException("Error occurred while trying to lock the account " + userName, e);
        }
    }

    public void unlockUserAccount(String userName, String notificationType) throws IdentityMgtServiceException {
        try {
            UserStoreManager userStoreManager = this.getUserStore(userName);
            String userNameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
            UserIdentityManagementUtil.unlockUserAccount(userNameWithoutDomain, userStoreManager);
            int tenantID = userStoreManager.getTenantId();
            String tenantDomain = IdentityMgtServiceComponent.getRealmService().getTenantManager().getDomain(tenantID);
            boolean isNotificationSending = IdentityMgtConfig.getInstance().isNotificationSending();
            if (notificationType != null && isNotificationSending) {
                UserRecoveryDTO dto;
                if ("carbon.super".equals(tenantDomain)) {
                    dto = new UserRecoveryDTO(userName);
                } else {
                    UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
                    userDTO.setTenantId(tenantID);
                    dto = new UserRecoveryDTO(userDTO);
                }
                dto.setNotification("accountUnLock");
                dto.setNotificationType(notificationType);
                IdentityMgtServiceComponent.getRecoveryProcessor().recoverWithNotification(dto);
            }
            log.info((Object)("Account unlocked for: " + userName));
        }
        catch (IdentityException | org.wso2.carbon.user.api.UserStoreException e) {
            String message = "Error occurred while unlocking account for: " + userName;
            log.error((Object)message, e);
            throw new IdentityMgtServiceException(message, e);
        }
    }

    public void disableUserAccount(String userName, String notificationType) throws IdentityMgtServiceException {
        try {
            UserStoreManager userStoreManager = this.getUserStore(userName);
            String userNameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
            UserIdentityManagementUtil.disableUserAccount(userNameWithoutDomain, userStoreManager);
            audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Disable user account", userName, "Notification type :" + notificationType, "Success"));
            int tenantID = userStoreManager.getTenantId();
            String tenantDomain = IdentityMgtServiceComponent.getRealmService().getTenantManager().getDomain(tenantID);
            boolean isNotificationSending = IdentityMgtConfig.getInstance().isAccountDisableNotificationSending();
            if (notificationType != null && isNotificationSending) {
                UserRecoveryDTO dto;
                if ("carbon.super".equals(tenantDomain)) {
                    dto = new UserRecoveryDTO(userName);
                } else {
                    UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
                    userDTO.setTenantId(tenantID);
                    dto = new UserRecoveryDTO(userDTO);
                }
                dto.setNotification("accountDisable");
                dto.setNotificationType(notificationType);
                IdentityMgtServiceComponent.getRecoveryProcessor().recoverWithNotification(dto);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Account enabled notification is sent in " + notificationType));
                }
            }
        }
        catch (IdentityException | org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)("Error occurred while trying to disable the account " + userName), e);
            throw new IdentityMgtServiceException("Error occurred while trying to disable the account " + userName, e);
        }
    }

    private String getUser() {
        String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
        user = user != null ? user + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : "wso2.system.user";
        return user;
    }

    public void enableUserAccount(String userName, String notificationType) throws IdentityMgtServiceException {
        try {
            UserStoreManager userStoreManager = this.getUserStore(userName);
            String userNameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
            UserIdentityManagementUtil.enableUserAccount(userNameWithoutDomain, userStoreManager);
            audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Enable user account", userName, "Notification type :" + notificationType, "Success"));
            int tenantID = userStoreManager.getTenantId();
            String tenantDomain = IdentityMgtServiceComponent.getRealmService().getTenantManager().getDomain(tenantID);
            boolean isNotificationSending = IdentityMgtConfig.getInstance().isAccountEnableNotificationSending();
            if (notificationType != null && isNotificationSending) {
                UserRecoveryDTO dto;
                if ("carbon.super".equals(tenantDomain)) {
                    dto = new UserRecoveryDTO(userName);
                } else {
                    UserDTO userDTO = new UserDTO(UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain));
                    userDTO.setTenantId(tenantID);
                    dto = new UserRecoveryDTO(userDTO);
                }
                dto.setNotification("accountEnable");
                dto.setNotificationType(notificationType);
                IdentityMgtServiceComponent.getRecoveryProcessor().recoverWithNotification(dto);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Account enabled notification is sent in " + notificationType));
                }
            }
        }
        catch (IdentityException | org.wso2.carbon.user.api.UserStoreException e) {
            String message = "Error occurred while enabling account for: " + userName;
            log.error((Object)message, e);
            throw new IdentityMgtServiceException(message, e);
        }
    }

    public void resetUserPassword(String userName, String newPassword) throws IdentityMgtServiceException {
        try {
            UserStoreManager userStoreManager = this.getUserStore(userName);
            String userNameWithoutDomain = UserCoreUtil.removeDomainFromName((String)userName);
            userStoreManager.updateCredentialByAdmin(userNameWithoutDomain, (Object)newPassword);
            log.info((Object)("User password reset for: " + userName));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String message = "Error occurred while resetting password for: " + userName;
            log.error((Object)message, (Throwable)e);
            throw new IdentityMgtServiceException(message, e);
        }
    }

    public UserChallengesDTO[] getChallengeQuestionsOfUser(String userName) throws IdentityMgtServiceException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String loggedInName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (userName != null && !userName.equals(loggedInName)) {
            AuthorizationManager authzManager = null;
            try {
                authzManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityMgtServiceException("Error occurred while retrieving AuthorizationManager for tenant " + tenantDomain, e);
            }
            boolean isAuthorized = false;
            try {
                isAuthorized = authzManager.isUserAuthorized(loggedInName, "/permission/admin/manage/identity/identitymgt/view", "ui.execute");
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityMgtServiceException("Error occurred while checking access level for user " + userName + " in tenant " + tenantDomain, e);
            }
            if (!isAuthorized) {
                throw new IdentityMgtServiceException("Unauthorized access!! Possible violation of confidentiality. User " + loggedInName + " trying to get challenge questions for user " + userName);
            }
        } else if (userName == null) {
            userName = loggedInName;
        }
        ChallengeQuestionProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor();
        return processor.getChallengeQuestionsOfUser(userName, tenantId, true);
    }

    public UserChallengesSetDTO[] getAllPromotedUserChallenge() throws IdentityMgtServiceException {
        ChallengeQuestionProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor();
        ArrayList<UserChallengesSetDTO> challengeQuestionSetDTOs = new ArrayList<UserChallengesSetDTO>();
        List<ChallengeQuestionDTO> questionDTOs = null;
        try {
            questionDTOs = processor.getAllChallengeQuestions();
        }
        catch (IdentityException e) {
            log.error((Object)"Error while loading user challenges", (Throwable)e);
            throw new IdentityMgtServiceException("Error while loading user challenges");
        }
        HashMap listMap = new HashMap();
        for (ChallengeQuestionDTO challengeQuestionDTO : questionDTOs) {
            ArrayList<UserChallengesDTO> dtoList = (ArrayList<UserChallengesDTO>)listMap.get(challengeQuestionDTO.getQuestionSetId());
            if (dtoList == null) {
                dtoList = new ArrayList<UserChallengesDTO>();
            }
            UserChallengesDTO userChallengesDTO = new UserChallengesDTO();
            userChallengesDTO.setId(challengeQuestionDTO.getQuestionSetId());
            userChallengesDTO.setQuestion(challengeQuestionDTO.getQuestion());
            userChallengesDTO.setOrder(challengeQuestionDTO.getOrder());
            dtoList.add(userChallengesDTO);
            listMap.put(challengeQuestionDTO.getQuestionSetId(), dtoList);
        }
        for (Map.Entry entry : listMap.entrySet()) {
            UserChallengesSetDTO dto = new UserChallengesSetDTO();
            dto.setId((String)entry.getKey());
            List dtoList = (List)entry.getValue();
            dto.setChallengesDTOs(dtoList.toArray(new UserChallengesDTO[dtoList.size()]));
            challengeQuestionSetDTOs.add(dto);
        }
        return challengeQuestionSetDTOs.toArray(new UserChallengesSetDTO[challengeQuestionSetDTOs.size()]);
    }

    public ChallengeQuestionDTO[] getAllChallengeQuestions() throws IdentityMgtServiceException {
        ChallengeQuestionProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor();
        List<ChallengeQuestionDTO> questionDTOs = null;
        try {
            questionDTOs = processor.getAllChallengeQuestions();
        }
        catch (IdentityException e) {
            String errorMessage = "Error while loading user challenge questions";
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityMgtServiceException(errorMessage);
        }
        return questionDTOs.toArray(new ChallengeQuestionDTO[questionDTOs.size()]);
    }

    public void setChallengeQuestions(ChallengeQuestionDTO[] challengeQuestionDTOs) throws IdentityMgtServiceException {
        ChallengeQuestionProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor();
        try {
            processor.setChallengeQuestions(challengeQuestionDTOs);
        }
        catch (IdentityException e) {
            log.error((Object)"Error while persisting user challenges", (Throwable)e);
            throw new IdentityMgtServiceException("Error while persisting user challenges");
        }
    }

    public void setChallengeQuestionsOfUser(String userName, UserChallengesDTO[] challengesDTOs) throws IdentityMgtServiceException {
        if (challengesDTOs == null || challengesDTOs.length < 1) {
            log.error((Object)"no challenges provided by user");
            throw new IdentityMgtServiceException("no challenges provided by user");
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String loggedInName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (userName != null && !userName.equals(loggedInName)) {
            AuthorizationManager authzManager = null;
            try {
                authzManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityMgtServiceException("Error occurred while retrieving AuthorizationManager for tenant " + tenantDomain, e);
            }
            boolean isAuthorized = false;
            try {
                isAuthorized = authzManager.isUserAuthorized(loggedInName, "/permission/admin/manage/identity/identitymgt/update", "ui.execute");
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityMgtServiceException("Error occurred while checking access level for user " + userName + " in tenant " + tenantDomain, e);
            }
            if (!isAuthorized) {
                throw new IdentityMgtServiceException("Unauthorized access!! Possible elevation of privilege attack. User " + loggedInName + " trying to change challenge questions for user " + userName);
            }
        } else if (userName == null) {
            userName = loggedInName;
        }
        this.validateSecurityQuestionDuplicate(challengesDTOs);
        ChallengeQuestionProcessor processor = IdentityMgtServiceComponent.getRecoveryProcessor().getQuestionProcessor();
        try {
            List<ChallengeQuestionDTO> challengeQuestionDTOs = processor.getAllChallengeQuestions();
            for (UserChallengesDTO userChallengesDTO : challengesDTOs) {
                boolean found = false;
                for (ChallengeQuestionDTO challengeQuestionDTO : challengeQuestionDTOs) {
                    if (!challengeQuestionDTO.getQuestion().equals(userChallengesDTO.getQuestion()) || !challengeQuestionDTO.getQuestionSetId().equals(userChallengesDTO.getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String errMsg = "Error while persisting user challenges for user : " + userName + ", because these user challengers are not registered with the tenant";
                log.error((Object)errMsg);
                throw new IdentityMgtServiceException(errMsg);
            }
            processor.setChallengesOfUser(userName, tenantId, challengesDTOs);
        }
        catch (IdentityException e) {
            String errorMessage = "Error while persisting user challenges for user : " + userName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityMgtServiceException(errorMessage);
        }
    }

    public void updateUserIdentityClaims(UserIdentityClaimDTO[] userIdentityClaims) throws IdentityMgtServiceException {
        String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId()).getUserStoreManager();
            HashMap<String, String> claims = new HashMap<String, String>();
            for (UserIdentityClaimDTO dto : userIdentityClaims) {
                if (dto.getClaimUri().contains("http://wso2.org/claims/identity")) {
                    log.warn((Object)("WARNING! User " + userName + " tried to alter " + dto.getClaimUri()));
                    throw IdentityException.error((String)("Updates to the claim " + dto.getClaimUri() + " are not allowed"));
                }
                claims.put(dto.getClaimUri(), dto.getClaimValue());
            }
            userStoreManager.setUserClaimValues(userName, claims, null);
        }
        catch (IdentityException | org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error while updating identity recovery data for : " + userName;
            log.error((Object)errorMessage, e);
            throw new IdentityMgtServiceException(errorMessage, e);
        }
    }

    public UserIdentityClaimDTO[] getAllUserIdentityClaims() throws IdentityMgtServiceException {
        String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        return UserIdentityManagementUtil.getAllUserIdentityClaims(userName);
    }

    public void changeUserPassword(String newPassword, String oldPassword) throws IdentityMgtServiceException {
        String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            UserStoreManager userStoreManager = this.getUserStore(userName);
            userName = UserCoreUtil.removeDomainFromName((String)userName);
            userStoreManager.updateCredential(userName, (Object)newPassword, (Object)oldPassword);
            log.info((Object)("Password changed for: " + userName));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String message = "Error while resetting the password for: " + userName;
            log.error((Object)message, (Throwable)e);
            throw new IdentityMgtServiceException(message, e);
        }
    }

    public boolean isReadOnlyUserStore(String userName, String tenantDomain) throws IdentityMgtServiceException {
        boolean isReadOnly = false;
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        if (StringUtils.isEmpty((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        RealmService realmService = IdentityMgtServiceComponent.getRealmService();
        try {
            int tenantId = Utils.getTenantId(tenantDomain);
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)this.getUserStore(userName);
            }
        }
        catch (Exception e) {
            String msg = "Error retrieving the user store manager for the tenant";
            log.error((Object)msg, (Throwable)e);
            throw new IdentityMgtServiceException(msg);
        }
        try {
            isReadOnly = userStoreManager != null && userStoreManager.isReadOnly();
        }
        catch (UserStoreException e) {
            String errorMessage = "Error while retrieving user store manager";
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityMgtServiceException(errorMessage);
        }
        return isReadOnly;
    }

    private UserStoreManager getUserStore(String userName) throws org.wso2.carbon.user.api.UserStoreException {
        UserStoreManager userStoreManager = IdentityMgtServiceComponent.getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId()).getUserStoreManager();
        if (userName != null && userName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            String userStoreDomain = this.getUserStoreDomainName(userName);
            return ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(userStoreDomain);
        }
        return userStoreManager;
    }

    private String getUserStoreDomainName(String userName) {
        String userNameWithoutDomain = userName;
        int index = userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index >= 0) {
            userNameWithoutDomain = userName.substring(0, index);
        }
        return userNameWithoutDomain;
    }

    private void validateSecurityQuestionDuplicate(UserChallengesDTO[] challengesDTOs) throws IdentityMgtServiceException {
        HashSet<String> tmpMap = new HashSet<String>();
        for (int i = 0; i < challengesDTOs.length; ++i) {
            UserChallengesDTO userChallengesDTO = challengesDTOs[i];
            if (tmpMap.contains(userChallengesDTO.getId())) {
                String errMsg = "Error while validating user challenges, because these can't be more than one security challenges for one claim uri";
                log.error((Object)errMsg);
                throw new IdentityMgtServiceException(errMsg);
            }
            tmpMap.add(userChallengesDTO.getId());
        }
    }
}

