/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.services;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigBuilder;
import org.wso2.carbon.identity.mgt.config.ConfigType;
import org.wso2.carbon.identity.mgt.config.EmailConfigTransformer;
import org.wso2.carbon.identity.mgt.config.EmailNotificationConfig;
import org.wso2.carbon.identity.mgt.config.StorageType;
import org.wso2.carbon.identity.mgt.dto.EmailTemplateDTO;

public class AccountCredentialMgtConfigService {
    private static final Log log = LogFactory.getLog(AccountCredentialMgtConfigService.class);

    public void saveEmailConfig(EmailTemplateDTO[] emailTemplates) throws IdentityMgtServiceException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EmailNotificationConfig emailConfig = new EmailNotificationConfig();
        ConfigBuilder configBuilder = ConfigBuilder.getInstance();
        try {
            Properties props = EmailConfigTransformer.transform(emailTemplates);
            emailConfig.setProperties(props);
            configBuilder.saveConfiguration(StorageType.REGISTRY, tenantId, emailConfig);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while saving email configuration", (Throwable)e);
            throw new IdentityMgtServiceException("Error occurred while saving email configuration");
        }
    }

    public EmailTemplateDTO[] getEmailConfig() throws IdentityMgtServiceException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Config emailConfig = null;
        EmailTemplateDTO[] templates = null;
        ConfigBuilder configBuilder = ConfigBuilder.getInstance();
        try {
            emailConfig = configBuilder.loadConfiguration(ConfigType.EMAIL, StorageType.REGISTRY, tenantId);
            if (emailConfig != null) {
                templates = EmailConfigTransformer.transform(emailConfig.getProperties());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while loading email configuration", (Throwable)e);
            throw new IdentityMgtServiceException("Error occurred while loading email configuration");
        }
        return templates;
    }
}

