/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.policy.password;

import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.wso2.carbon.identity.mgt.policy.AbstractPasswordPolicyEnforcer;

public class DefaultPasswordLengthPolicy
extends AbstractPasswordPolicyEnforcer {
    private int MIN_LENGTH = 6;
    private int MAX_LENGTH = 10;

    @Override
    public void init(Map<String, String> params) {
        if (!MapUtils.isEmpty(params)) {
            this.MIN_LENGTH = Integer.parseInt(params.get("min.length"));
            this.MAX_LENGTH = Integer.parseInt(params.get("max.length"));
        }
    }

    @Override
    public boolean enforce(Object ... args) {
        if (args != null) {
            String password = args[0].toString();
            if (password.length() < this.MIN_LENGTH) {
                this.errorMessage = "Password must have at least " + this.MIN_LENGTH + " characters";
                return false;
            }
            if (password.length() > this.MAX_LENGTH) {
                this.errorMessage = "Password cannot have more than " + this.MAX_LENGTH + " characters";
                return false;
            }
            return true;
        }
        return true;
    }
}

