/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.mail;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.mail.EmailNotification;
import org.wso2.carbon.identity.mgt.mail.Notification;
import org.wso2.carbon.identity.mgt.mail.NotificationData;

public class NotificationBuilder {
    private NotificationBuilder() {
    }

    public static Notification createNotification(String notificationType, String template, NotificationData data) throws IdentityMgtServiceException {
        String subject = null;
        String body = null;
        String footer = null;
        EmailNotification notificatoin = null;
        if ("EMAIL".equals(notificationType)) {
            String[] contents = template.split("\\|");
            if (contents.length > 3) {
                throw new IdentityMgtServiceException("Contents must be 3 or less");
            }
            subject = contents[0];
            body = contents[1];
            footer = contents[2];
            Map<String, String> tagsData = data.getTagsData();
            try {
                subject = NotificationBuilder.replaceTags(tagsData, subject);
                body = NotificationBuilder.replaceTags(tagsData, body);
                footer = NotificationBuilder.replaceTags(tagsData, footer);
            }
            catch (UnsupportedEncodingException e) {
                throw new IdentityMgtServiceException("Unsupported encoding while creating notification", e);
            }
            notificatoin = new EmailNotification();
            notificatoin.setSubject(subject);
            notificatoin.setBody(body);
            notificatoin.setFooter(footer);
            notificatoin.setSendFrom(data.getSendFrom());
            notificatoin.setSendTo(data.getSendTo());
        }
        return notificatoin;
    }

    private static String replaceTags(Map<String, String> tagsData, String content) throws UnsupportedEncodingException {
        for (Map.Entry<String, String> entry : tagsData.entrySet()) {
            String data = entry.getValue();
            String key = entry.getKey();
            if (data != null) {
                content = content.replaceAll("\\{url:" + key + "\\}", URLEncoder.encode(tagsData.get(key), "UTF-8"));
                content = content.replaceAll("\\{" + key + "\\}", tagsData.get(key));
                continue;
            }
            content = content.replaceAll("\\{url:" + key + "\\}", "");
            content = content.replaceAll("\\{" + key + "\\}", "");
        }
        return content;
    }
}

