/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.mail;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.identity.mgt.mail.AbstractEmailSendingModule;
import org.wso2.carbon.identity.mgt.mail.EmailConfig;
import org.wso2.carbon.identity.mgt.mail.Notification;

public class DefaultEmailSendingModule
extends AbstractEmailSendingModule {
    public static final String CONF_STRING = "confirmation";
    private static final String SEND_MAIL_PROPERTY = "mailto:";
    private static Log log = LogFactory.getLog(DefaultEmailSendingModule.class);
    private BlockingQueue<Notification> notificationQueue = new LinkedBlockingDeque<Notification>();

    public static String replacePlaceHolders(String text, Map<String, String> userParameters) {
        if (userParameters != null) {
            for (Map.Entry<String, String> entry : userParameters.entrySet()) {
                String key = entry.getKey();
                if (key == null || entry.getValue() == null) continue;
                text = text.replaceAll("\\{" + key + "\\}", entry.getValue());
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEmail() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        try {
            Notification notification = this.notificationQueue.take();
            if (notification == null) {
                throw new IllegalStateException("Notification not set. Please set the notification before sending messages");
            }
            PrivilegedCarbonContext.startTenantFlow();
            if (this.notificationData != null) {
                String tenantDomain = this.notificationData.getDomainName();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(tenantDomain, true);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"notification data not found. Tenant might not be loaded correctly");
            }
            headerMap.put("Subject", notification.getSubject());
            OMElement payload = OMAbstractFactory.getOMFactory().createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER, null);
            StringBuilder contents = new StringBuilder();
            contents.append(notification.getBody()).append(System.getProperty("line.separator")).append(System.getProperty("line.separator")).append(notification.getFooter());
            payload.setText(contents.toString());
            ConfigurationContext configContext = CarbonConfigurationContextFactory.getConfigurationContext();
            ServiceClient serviceClient = configContext != null ? new ServiceClient(configContext, null) : new ServiceClient();
            Options options = new Options();
            options.setProperty("enableREST", (Object)"true");
            options.setProperty("TRANSPORT_HEADERS", headerMap);
            options.setProperty("transport.mail.Format", (Object)"Text");
            options.setTo(new EndpointReference(SEND_MAIL_PROPERTY + notification.getSendTo()));
            serviceClient.setOptions(options);
            log.info((Object)("Sending an email notification to " + notification.getSendTo()));
            serviceClient.fireAndForget(payload);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Email content : " + notification.getBody()));
            }
            log.info((Object)("Email notification has been sent to " + notification.getSendTo()));
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Failed Sending Email", (Throwable)axisFault);
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted while waiting until an element becomes available in the notification queue.", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public String getRequestMessage(EmailConfig emailConfig) {
        StringBuilder msg;
        String targetEpr = emailConfig.getTargetEpr();
        if (emailConfig.getEmailBody().length() == 0) {
            msg = new StringBuilder("Please point your browser to : ");
            msg.append("\n");
            if (this.notificationData.getNotificationCode() != null) {
                msg.append(targetEpr).append("?").append(CONF_STRING).append(this.notificationData.getNotificationCode()).append("\n");
            }
        } else {
            msg = new StringBuilder(emailConfig.getEmailBody());
            msg.append("\n");
        }
        if (emailConfig.getEmailFooter() != null) {
            msg.append("\n").append(emailConfig.getEmailFooter());
        }
        return msg.toString();
    }

    @Override
    public Notification getNotification() {
        return (Notification)this.notificationQueue.peek();
    }

    @Override
    public void setNotification(Notification notification) {
        this.notificationQueue.add(notification);
    }
}

