/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.mail;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.IdentityMgtServiceException;
import org.wso2.carbon.identity.mgt.NotificationSendingModule;
import org.wso2.carbon.identity.mgt.mail.EmailConfig;
import org.wso2.carbon.identity.mgt.util.Utils;

public abstract class AbstractEmailSendingModule
extends NotificationSendingModule {
    private static final Log log = LogFactory.getLog(AbstractEmailSendingModule.class);
    protected String NOTIFICATION_TYPE = "EMAIL";
    private Map<String, EmailConfig> emailConfigs = new HashMap<String, EmailConfig>();

    @Override
    public String getNotificationType() {
        return this.NOTIFICATION_TYPE;
    }

    @Override
    public void init() throws IdentityMgtServiceException {
        this.loadEmailConfigurations();
    }

    @Override
    public String getNotificationAddress(String userName, int tenantId) {
        return Utils.getEmailAddressForUser(userName, tenantId);
    }

    @Override
    public void notifyUser() {
        this.sendEmail();
    }

    public abstract void sendEmail();

    public void loadEmailConfigurations() {
    }
}

