/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.listener;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class UserSessionTerminationListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(UserSessionTerminationListener.class);
    private static final String USER_SESSION_MAPPING_ENABLED = "JDBCPersistenceManager.SessionDataPersist.UserSessionMapping.Enable";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 85;
    }

    public boolean doPostUpdateCredentialByAdmin(String username, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (!IdentityMgtServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Terminating all the active sessions of the password reset user: " + username));
        }
        this.terminateSessionsOfUser(username, userStoreManager);
        return true;
    }

    public boolean doPreDeleteUser(String username, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (!IdentityMgtServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Terminating all the active sessions of the deleted user: " + username));
        }
        this.terminateSessionsOfUser(username, userStoreManager);
        return true;
    }

    public boolean doPreSetUserClaimValues(String username, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (!IdentityMgtServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
            return true;
        }
        if (this.isAccountLocked(claims) || this.isAccountDisabled(claims)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Terminating all the active sessions of the user: " + username));
            }
            this.terminateSessionsOfUser(username, userStoreManager);
        }
        return true;
    }

    private boolean isAccountLocked(Map<String, String> claims) {
        return claims != null && claims.containsKey("http://wso2.org/claims/identity/accountLocked") && Boolean.valueOf(claims.get("http://wso2.org/claims/identity/accountLocked")) != false;
    }

    private boolean isAccountDisabled(Map<String, String> claims) {
        return claims != null && claims.containsKey("http://wso2.org/claims/identity/accountDisabled") && Boolean.valueOf(claims.get("http://wso2.org/claims/identity/accountDisabled")) != false;
    }

    private void terminateSessionsOfUser(String username, UserStoreManager userStoreManager) throws UserStoreException {
        String userStoreDomain = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
        try {
            IdentityMgtServiceComponent.getUserSessionManagementService().terminateSessionsOfUser(username, userStoreDomain, tenantDomain);
        }
        catch (UserSessionException e) {
            log.error((Object)("Failed to terminate active sessions of user: " + username), (Throwable)e);
        }
    }
}

