/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.listener;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.identity.notification.mgt.NotificationManagementException;
import org.wso2.carbon.identity.notification.mgt.NotificationSender;
import org.wso2.carbon.identity.notification.mgt.bean.PublisherEvent;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class UserOperationsNotificationListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(UserOperationsNotificationListener.class);
    private final String eventName = "userOperation";
    private final String usernameLabel = "username";
    private final String operationLabel = "operation";
    private final String EVENT_TYPE_PROFILE_UPDATE = "profileUpdate";
    private final String EVENT_TYPE_ROLE_UPDATE = "roleUpdate";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 80;
    }

    public boolean doPostDeleteUser(String username, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending user delete notification for user " + username));
        }
        this.sendNotification("profileUpdate", username);
        return true;
    }

    public boolean doPostDeleteUserClaimValues(String username, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending user claim value update notification for user " + username));
        }
        this.sendNotification("profileUpdate", username);
        return true;
    }

    public boolean doPostDeleteUserClaimValue(String username, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending user delete update notification for user " + username));
        }
        this.sendNotification("profileUpdate", username);
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String username, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending user role list update notification for user " + username));
        }
        this.sendNotification("roleUpdate", username);
        return true;
    }

    public boolean doPostSetUserClaimValues(String username, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending user claim values update notification for user " + username));
        }
        this.sendNotification("profileUpdate", username);
        return true;
    }

    private void sendNotification(String operation, String username) {
        NotificationSender notificationSender = IdentityMgtServiceComponent.getNotificationSender();
        if (notificationSender != null) {
            try {
                PublisherEvent event = new PublisherEvent("userOperation");
                event.addEventProperty("operation", operation);
                event.addEventProperty("username", username);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invoking notification sender");
                }
                notificationSender.invoke(event);
            }
            catch (NotificationManagementException e) {
                log.error((Object)"Error while sending notifications on user operations", (Throwable)e);
            }
        } else {
            log.error((Object)"No registered notification sender found. Notification sending aborted");
        }
    }
}

