/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.IdentityMgtConfigException;
import org.wso2.carbon.identity.mgt.IdentityMgtEventListener;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigBuilder;
import org.wso2.carbon.identity.mgt.config.EmailNotificationConfig;
import org.wso2.carbon.identity.mgt.config.StorageType;
import org.wso2.carbon.identity.mgt.util.UserIdentityManagementUtil;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;

public class TenantManagementListener
implements TenantMgtListener {
    private static final int EXEC_ORDER = 40;
    private static final Log log = LogFactory.getLog(TenantManagementListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            PrivilegedCarbonContext.getThreadLocalCarbonContext();
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantInfo.getTenantDomain());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantInfo.getTenantId());
            UserIdentityManagementUtil.loadDefaultChallenges();
            IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)UserOperationEventListener.class.getName(), (String)IdentityMgtEventListener.class.getName());
            if (identityEventListenerConfig != null && Boolean.parseBoolean(identityEventListenerConfig.getEnable())) {
                Config emailConfigFile = ConfigBuilder.getInstance().loadEmailConfigFile();
                EmailNotificationConfig emailNotificationConfig = new EmailNotificationConfig();
                emailNotificationConfig.setProperties(emailConfigFile.getProperties());
                ConfigBuilder.getInstance().saveConfiguration(StorageType.REGISTRY, tenantInfo.getTenantId(), emailNotificationConfig);
            }
        }
        catch (IdentityMgtConfigException e) {
            log.error((Object)("Error occurred while saving default email templates in registry for tenant: " + tenantInfo.getTenantDomain()));
        }
        finally {
            PrivilegedCarbonContext.getThreadLocalCarbonContext();
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfoBean) throws StratosException {
    }

    public void onTenantDelete(int i) {
    }

    public void onTenantRename(int i, String s, String s1) throws StratosException {
    }

    public void onTenantInitialActivation(int i) throws StratosException {
    }

    public void onTenantActivation(int i) throws StratosException {
    }

    public void onTenantDeactivation(int i) throws StratosException {
    }

    public void onSubscriptionPlanChange(int i, String s, String s1) throws StratosException {
    }

    public int getListenerOrder() {
        return 40;
    }

    public void onPreDelete(int i) throws StratosException {
    }
}

