/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.mgt.listener.IdentityUserIdResolverListener;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.LoginIdentifier;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.UniqueIDUserClaimSearchEntry;
import org.wso2.carbon.user.core.model.UserClaimSearchEntry;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityUserNameResolverListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityUserNameResolverListener.class);
    private static final String DO_PRE_DELETE_USER_USER_NAME = "doPreDeleteUserUserName";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 14;
    }

    public boolean doPreAuthenticateWithID(String userID, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreAuthenticate(userName, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAuthenticateWithID(String userID, AuthenticationResult authenticationResult, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        boolean authenticated = authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS;
        String userName = authenticated ? ((User)authenticationResult.getAuthenticatedUser().get()).getUsername() : this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostAuthenticate(userName, authenticated, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAddUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreAddUser(userName, credential, roleList, claims, profile, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAddUserWithID(User user, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(user.getUserID(), (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(user.getUserID(), userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostAddUser(userName, credential, roleList, claims, profile, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateCredentialWithID(String userID, Object newCredential, Object oldCredential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreUpdateCredential(userName, newCredential, oldCredential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateCredentialWithID(String userID, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostUpdateCredential(userName, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateCredentialByAdminWithID(String userID, Object newCredential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreUpdateCredentialByAdmin(userName, newCredential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateCredentialByAdminWithID(String userID, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostUpdateCredentialByAdmin(userName, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreDeleteUserWithID(String userID, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_PRE_DELETE_USER_USER_NAME, userName);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreDeleteUser(userName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostDeleteUserWithID(String userID, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        try {
            String userName = (String)((Map)IdentityUtil.threadLocalProperties.get()).get(DO_PRE_DELETE_USER_USER_NAME);
            for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
                if (!this.isNotAResolverListener(listener) || listener.doPostDeleteUser(userName, userStoreManager)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_PRE_DELETE_USER_USER_NAME);
        }
        return true;
    }

    public boolean doPreSetUserClaimValueWithID(String userID, String claimURI, String claimValue, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreSetUserClaimValue(userName, claimURI, claimValue, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostSetUserClaimValueWithID(String userID, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostSetUserClaimValue(userName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreSetUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreSetUserClaimValues(userName, claims, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostSetUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostSetUserClaimValues(userName, claims, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValuesWithID(String userID, String[] claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreDeleteUserClaimValues(userName, claims, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostDeleteUserClaimValuesWithID(String userID, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostDeleteUserClaimValues(userName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValueWithID(String userID, String claimURI, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreDeleteUserClaimValue(userName, claimURI, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostDeleteUserClaimValueWithID(String userID, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostDeleteUserClaimValue(userName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAddRoleWithID(String roleName, String[] userIDList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] userNames = this.getUserNamesFromUserIDs(userIDList, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreAddRole(roleName, userNames, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAddRoleWithID(String roleName, String[] userIDList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] userNames = this.getUserNamesFromUserIDs(userIDList, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostAddRole(roleName, userNames, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAddInternalRoleWithID(String roleName, String[] userIDList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] userNames = this.getUserNamesFromUserIDs(userIDList, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreAddInternalRole(roleName, userNames, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAddInternalRoleWithID(String roleName, String[] userIDList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] userNames = this.getUserNamesFromUserIDs(userIDList, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostAddInternalRole(roleName, userNames, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateUserListOfRoleWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] deletedUserNames = this.getUserNamesFromUserIDs(deletedUserIDs, (AbstractUserStoreManager)userStoreManager);
        String[] newUserNames = this.getUserNamesFromUserIDs(newUserIDs, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreUpdateUserListOfRole(roleName, deletedUserNames, newUserNames, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateUserListOfRoleWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] deletedUserNames = this.getUserNamesFromUserIDs(deletedUserIDs, (AbstractUserStoreManager)userStoreManager);
        String[] newUserNames = this.getUserNamesFromUserIDs(newUserIDs, (AbstractUserStoreManager)userStoreManager);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostUpdateUserListOfRole(roleName, deletedUserNames, newUserNames, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreUpdateRoleListOfUser(userName, deletedRoles, newRoles, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostUpdateRoleListOfUser(userName, deletedRoles, newRoles, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserClaimValueWithID(String userID, String claim, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreGetUserClaimValue(userName, claim, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserClaimValuesWithID(String userID, String[] claims, String profileName, Map<String, String> claimMap, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreGetUserClaimValues(userName, claims, profileName, claimMap, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserClaimValueWithID(String userID, String claim, List<String> claimValue, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetUserClaimValue(userName, claim, claimValue, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserClaimValuesWithID(String userID, String[] claims, String profileName, Map<String, String> claimMap, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetUserClaimValues(userName, claims, profileName, claimMap, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserListWithID(String claimUri, String claimValue, List<User> returnUsersList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List returnUserNamesList = returnUsersList.stream().map(User::getUsername).collect(Collectors.toList());
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreGetUserList(claimUri, claimValue, returnUserNamesList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserListWithID(String claimUri, String claimValue, int limit, int offset, List<User> returnUsersList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List returnUserNamesList = returnUsersList.stream().map(User::getUsername).collect(Collectors.toList());
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener)) continue;
            return listener.doPreGetUserList(claimUri, claimValue, limit, offset, returnUserNamesList, userStoreManager);
        }
        return true;
    }

    public boolean doPostGetUserListWithID(String claimUri, String claimValue, List<User> returnUsersList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List returnUserNamesList = returnUsersList.stream().map(User::getUsername).collect(Collectors.toList());
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetUserList(claimUri, claimValue, returnUserNamesList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserListWithID(String claimUri, String claimValue, List<User> returnUsersList, int limit, int offset, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List returnUserNamesList = returnUsersList.stream().map(User::getUsername).collect(Collectors.toList());
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener)) continue;
            return listener.doPostGetUserList(claimUri, claimValue, returnUserNamesList, limit, offset, userStoreManager);
        }
        return true;
    }

    public boolean doPostGetPaginatedUserListWithID(String claimUri, String claimValue, List<User> returnUsersList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List returnUserNamesList = returnUsersList.stream().map(User::getUsername).collect(Collectors.toList());
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetPaginatedUserList(claimUri, claimValue, returnUserNamesList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostListUsersWithID(String filter, int limit, int offset, List<User> returnUsersList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List returnUserNamesList = returnUsersList.stream().map(User::getUsername).collect(Collectors.toList());
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostListUsers(filter, limit, offset, returnUserNamesList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetRoleListOfUserWithID(String userID, String filter, String[] roleList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userName = this.getUserNameFromUserID(userID, (AbstractUserStoreManager)userStoreManager);
        if (userName == null) {
            return this.handleUserNameResolveFailure(userID, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetRoleListOfUser(userName, filter, roleList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreGetUserList(condition, domain, profileName, limit, offset, sortBy, sortOrder, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, List<User> users, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<String> userNamesList = users.stream().map(User::getUsername).collect(Collectors.toList());
        String[] userNames = userNamesList.toArray(new String[0]);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener)) continue;
            return listener.doPostGetUserList(condition, domain, profileName, limit, offset, sortBy, sortOrder, userNames, userStoreManager);
        }
        return true;
    }

    public boolean doPostGetUserListOfRoleWithID(String roleName, List<User> userList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<String> returnUserNamesList = userList.stream().map(User::getUsername).collect(Collectors.toList());
        String[] returnUserNames = returnUserNamesList.toArray(new String[0]);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetUserListOfRole(roleName, returnUserNames, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUsersClaimValuesWithID(List<String> userIDs, List<String> claims, String profileName, List<UniqueIDUserClaimSearchEntry> uniqueIDUserClaimSearchEntries, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List userNamesList = ((AbstractUserStoreManager)userStoreManager).getUserNamesFromUserIDs(userIDs);
        String[] userNames = userNamesList.toArray(new String[0]);
        List userClaimSearchEntries = ((AbstractUserStoreManager)userStoreManager).getUserClaimSearchEntries(uniqueIDUserClaimSearchEntries);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetUsersClaimValues(userNames, claims.toArray(new String[0]), profileName, userClaimSearchEntries.toArray(new UserClaimSearchEntry[0]))) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAuthenticateWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String[] users = userStoreManager.getUserList(preferredUserNameClaim, preferredUserNameValue, null);
        if (users.length != 1) {
            return true;
        }
        String userName = users[0];
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreAuthenticate(userName, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAuthenticateWithID(String preferredUserNameClaim, String preferredUserNameValue, AuthenticationResult authenticationResult, UserStoreManager userStoreManager) throws UserStoreException {
        String userName;
        boolean authenticated;
        if (!this.isEnable()) {
            return true;
        }
        boolean bl = authenticated = authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS;
        if (authenticated) {
            userName = ((User)authenticationResult.getAuthenticatedUser().get()).getUsername();
        } else {
            String[] users = userStoreManager.getUserList(preferredUserNameClaim, preferredUserNameValue, null);
            if (users.length == 1) {
                userName = users[0];
            } else {
                return true;
            }
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostAuthenticate(userName, authenticated, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String username = ((AbstractUserStoreManager)userStoreManager).getUsernameByClaims(loginIdentifiers);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPreAuthenticate(username, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, AuthenticationResult authenticationResult, UserStoreManager userStoreManager) throws UserStoreException {
        boolean authenticated;
        if (!this.isEnable()) {
            return true;
        }
        boolean bl = authenticated = authenticationResult.getAuthenticationStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS;
        if (!authenticated) {
            return true;
        }
        String userName = ((User)authenticationResult.getAuthenticatedUser().get()).getUsername();
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostAuthenticate(userName, authenticated, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetRoleListOfUsersWithID(List<String> userIDs, Map<String, List<String>> rolesOfUsersMap, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List userNamesList = ((AbstractUserStoreManager)userStoreManager).getUserNamesFromUserIDs(userIDs);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || listener.doPostGetRoleListOfUsers(userNamesList.toArray(new String[0]), rolesOfUsersMap)) continue;
            return false;
        }
        return true;
    }

    private boolean handleUserNameResolveFailure(String userID, UserStoreManager userStoreManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("A userID cannot be found in the userStoreManager" + this.getUserStoreDomainName(userStoreManager) + "for the given userID: " + userID));
        }
        return true;
    }

    private String getUserStoreDomainName(UserStoreManager userStoreManager) {
        String domainNameProperty = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        if (StringUtils.isBlank((String)domainNameProperty)) {
            domainNameProperty = IdentityUtil.getPrimaryDomainName();
        }
        return domainNameProperty;
    }

    private String[] getUserNamesFromUserIDs(String[] userIDList, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        if (userIDList == null) {
            return new String[0];
        }
        List userNamesList = userStoreManager.getUserNamesFromUserIDs(this.getDomainLessNamesAsList(userIDList));
        return userNamesList.toArray(new String[0]);
    }

    private Collection<UserOperationEventListener> getUserStoreManagerListeners() {
        Map<Integer, UserOperationEventListener> userOperationEventListeners = IdentityMgtServiceDataHolder.getInstance().getUserOperationEventListeners();
        return userOperationEventListeners.values();
    }

    private List<String> getDomainLessNamesAsList(String[] names) {
        if (names == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(names).map(UserCoreUtil::removeDomainFromName).collect(Collectors.toList());
    }

    private boolean isNotAResolverListener(UserOperationEventListener listener) {
        return !(listener instanceof IdentityUserIdResolverListener) && !(listener instanceof IdentityUserNameResolverListener);
    }

    private String getUserNameFromUserID(String userID, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        return UserCoreUtil.removeDomainFromName((String)userStoreManager.getUserNameFromUserID(userID));
    }
}

