/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.mgt.listener.IdentityUserNameResolverListener;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.listener.UniqueIDUserOperationEventListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.UserClaimSearchEntry;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityUserIdResolverListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityUserIdResolverListener.class);
    private static final String DO_PRE_DELETE_USER_USER_ID = "doPreDeleteUserUserID";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 15;
    }

    public boolean doPreAuthenticate(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreAuthenticateWithID(userID, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAuthenticate(String userName, boolean authenticated, UserStoreManager userStoreManager) throws UserStoreException {
        AuthenticationResult authenticationResult;
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        if (authenticated) {
            authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
            User user = ((AbstractUserStoreManager)userStoreManager).getUser(userID, userName);
            authenticationResult.setAuthenticatedUser(user);
        } else {
            authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostAuthenticateWithID(userID, authenticationResult, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreAddUserWithID(userName, credential, roleList, claims, profile, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        User user = ((AbstractUserStoreManager)userStoreManager).getUser(null, userName);
        if (user == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostAddUserWithID(user, credential, roleList, claims, profile, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateCredential(String userName, Object newCredential, Object oldCredential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreUpdateCredentialWithID(userID, newCredential, oldCredential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateCredential(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostUpdateCredentialWithID(userID, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateCredentialByAdmin(String userName, Object newCredential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreUpdateCredentialByAdminWithID(userID, newCredential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateCredentialByAdmin(String userName, Object credential, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostUpdateCredentialByAdminWithID(userID, credential, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).put(DO_PRE_DELETE_USER_USER_ID, userID);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreDeleteUserWithID(userID, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        try {
            String userID = (String)((Map)IdentityUtil.threadLocalProperties.get()).get(DO_PRE_DELETE_USER_USER_ID);
            for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
                if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostDeleteUserWithID(userID, userStoreManager)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(DO_PRE_DELETE_USER_USER_ID);
        }
        return true;
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener)) continue;
            return ((UniqueIDUserOperationEventListener)listener).doPreSetUserClaimValueWithID(userID, claimURI, claimValue, profileName, userStoreManager);
        }
        return true;
    }

    public boolean doPostSetUserClaimValue(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostSetUserClaimValueWithID(userID, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreSetUserClaimValuesWithID(userID, claims, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostSetUserClaimValuesWithID(userID, claims, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValues(String userName, String[] claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreDeleteUserClaimValuesWithID(userID, claims, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostDeleteUserClaimValues(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostDeleteUserClaimValuesWithID(userID, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValue(String userName, String claimURI, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreDeleteUserClaimValueWithID(userID, claimURI, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostDeleteUserClaimValue(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostDeleteUserClaimValueWithID(userID, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAddRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        String[] userIDs;
        if (!this.isEnable()) {
            return true;
        }
        try {
            userIDs = this.getUserIdsFromUserNames(userList, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreAddRoleWithID(roleName, userIDs, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAddRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        String[] userIDs;
        if (!this.isEnable()) {
            return true;
        }
        try {
            userIDs = this.getUserIdsFromUserNames(userList, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostAddRoleWithID(roleName, userIDs, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreAddInternalRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        String[] userIDs;
        if (!this.isEnable()) {
            return true;
        }
        try {
            userIDs = this.getUserIdsFromUserNames(userList, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreAddInternalRoleWithID(roleName, userIDs, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostAddInternalRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) throws UserStoreException {
        String[] userIDs;
        if (!this.isEnable()) {
            return true;
        }
        try {
            userIDs = this.getUserIdsFromUserNames(userList, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostAddInternalRoleWithID(roleName, userIDs, permissions, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        String[] newUserIDs;
        String[] deletedUserIDs;
        if (!this.isEnable()) {
            return true;
        }
        try {
            deletedUserIDs = this.getUserIdsFromUserNames(deletedUsers, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        try {
            newUserIDs = this.getUserIdsFromUserNames(newUsers, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) throws UserStoreException {
        String[] newUserIDs;
        String[] deletedUserIDs;
        if (!this.isEnable()) {
            return true;
        }
        try {
            deletedUserIDs = this.getUserIdsFromUserNames(deletedUsers, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        try {
            newUserIDs = this.getUserIdsFromUserNames(newUsers, (AbstractUserStoreManager)userStoreManager);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostUpdateUserListOfRoleWithID(roleName, deletedUserIDs, newUserIDs, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostUpdateRoleListOfUserWithID(userID, deletedRoles, newRoles, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserClaimValue(String userName, String claim, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreGetUserClaimValueWithID(userID, claim, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserClaimValues(String userName, String[] claims, String profileName, Map<String, String> claimMap, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreGetUserClaimValuesWithID(userID, claims, profileName, claimMap, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserClaimValue(String userName, String claim, List<String> claimValue, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUserClaimValueWithID(userID, claim, claimValue, profileName, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserClaimValues(String userName, String[] claims, String profileName, Map<String, String> claimMap, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUserClaimValuesWithID(userID, claims, profileName, claimMap, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserList(String claimUri, String claimValue, List<String> returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, returnUserNameList);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreGetUserListWithID(claimUri, claimValue, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserList(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreGetUserListWithID(condition, domain, profileName, limit, offset, sortBy, sortOrder, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPreGetUserList(String claimUri, String claimValue, int limit, int offset, List<String> returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, returnUserNameList);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPreGetUserListWithID(claimUri, claimValue, limit, offset, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserList(String claimUri, String claimValue, List<String> returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, returnUserNameList);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUserListWithID(claimUri, claimValue, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserList(String claimUri, String claimValue, List<String> returnUserNameList, int limit, int offset, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, returnUserNameList);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUserListWithID(claimUri, claimValue, returnUsersList, limit, offset, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserList(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, String[] returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, Arrays.asList(returnUserNameList));
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUserListWithID(condition, domain, profileName, limit, offset, sortBy, sortOrder, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    private List<User> getUsersFromNames(AbstractUserStoreManager userStoreManager, List<String> userList) throws UserStoreException {
        return userStoreManager.getUsersFromUserNames(this.getDomainLessNamesFromList(userList));
    }

    private List<String> getDomainLessNamesFromList(List<String> userList) {
        if (userList == null) {
            return new ArrayList<String>();
        }
        return userList.stream().map(UserCoreUtil::removeDomainFromName).collect(Collectors.toList());
    }

    private String[] getDomainLessNames(String[] names) {
        if (names == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(names).map(UserCoreUtil::removeDomainFromName).toArray(String[]::new);
    }

    public boolean doPostGetPaginatedUserList(String claimUri, String claimValue, List<String> returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, returnUserNameList);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetPaginatedUserListWithID(claimUri, claimValue, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostListUsers(String filter, int limit, int offset, List<String> returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, returnUserNameList);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostListUsersWithID(filter, limit, offset, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetRoleListOfUser(String userName, String filter, String[] roleList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        String userID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        if (userID == null) {
            return this.handleUserIDResolveFailure(userName, userStoreManager);
        }
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetRoleListOfUserWithID(userID, filter, roleList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUserListOfRole(String roleName, String[] returnUserNameList, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List<User> returnUsersList = this.getUsersFromNames((AbstractUserStoreManager)userStoreManager, Arrays.asList(this.getDomainLessNames(returnUserNameList)));
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUserListOfRoleWithID(roleName, returnUsersList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetRoleListOfUsers(String[] userNames, Map<String, List<String>> rolesOfUsersMap, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List userIDsList = ((AbstractUserStoreManager)userStoreManager).getUserIDsFromUserNames(Arrays.asList(userNames));
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetRoleListOfUsersWithID(userIDsList, rolesOfUsersMap, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    public boolean doPostGetUsersClaimValues(String[] userNames, String[] claims, String profileName, UserClaimSearchEntry[] userClaimSearchEntries, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        List userIDsList = ((AbstractUserStoreManager)userStoreManager).getUserIDsFromUserNames(Arrays.asList(this.getDomainLessNames(userNames)));
        List<String> claimsList = Arrays.asList(claims);
        List uniqueIDUserClaimSearchEntriesList = ((AbstractUserStoreManager)userStoreManager).getUniqueIDUserClaimSearchEntries(userClaimSearchEntries);
        for (UserOperationEventListener listener : this.getUserStoreManagerListeners()) {
            if (!this.isNotAResolverListener(listener) || ((UniqueIDUserOperationEventListener)listener).doPostGetUsersClaimValuesWithID(userIDsList, claimsList, profileName, uniqueIDUserClaimSearchEntriesList, userStoreManager)) continue;
            return false;
        }
        return true;
    }

    private String[] getUserIdsFromUserNames(String[] userNames, AbstractUserStoreManager userStoreManager) throws UserStoreException {
        if (ArrayUtils.isEmpty((Object[])userNames)) {
            return new String[0];
        }
        List userIDsList = userStoreManager.getUserIDsFromUserNames(Arrays.asList(userNames));
        return userIDsList.toArray(new String[0]);
    }

    private boolean handleUserIDResolveFailure(String userName, UserStoreManager userStoreManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("A userID cannot be found in the userStoreManager" + this.getUserStoreDomainName(userStoreManager) + "for the given userName: " + userName));
        }
        return true;
    }

    private String getUserStoreDomainName(UserStoreManager userStoreManager) {
        String domainNameProperty = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        if (StringUtils.isBlank((String)domainNameProperty)) {
            domainNameProperty = IdentityUtil.getPrimaryDomainName();
        }
        return domainNameProperty;
    }

    private Collection<UserOperationEventListener> getUserStoreManagerListeners() {
        Map<Integer, UserOperationEventListener> userOperationEventListeners = IdentityMgtServiceDataHolder.getInstance().getUserOperationEventListeners();
        return userOperationEventListeners.values();
    }

    private boolean isNotAResolverListener(UserOperationEventListener listener) {
        return !(listener instanceof IdentityUserNameResolverListener) && !(listener instanceof IdentityUserIdResolverListener);
    }
}

