/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.internal;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;

public class IdentityMgtServiceDataHolder {
    private static IdentityMgtServiceDataHolder instance = new IdentityMgtServiceDataHolder();
    private static Log log = LogFactory.getLog(IdentityMgtServiceDataHolder.class);
    private boolean userSessionMappingEnabled;
    private static Map<Integer, UserOperationEventListener> userOperationEventListeners = new TreeMap<Integer, UserOperationEventListener>();

    private IdentityMgtServiceDataHolder() {
    }

    public static IdentityMgtServiceDataHolder getInstance() {
        return instance;
    }

    public boolean isUserSessionMappingEnabled() {
        return this.userSessionMappingEnabled;
    }

    public void setUserSessionMappingEnabled(boolean userSessionMappingEnabled) {
        if (log.isDebugEnabled()) {
            if (userSessionMappingEnabled) {
                log.debug((Object)"User session mapping enabled for server.");
            } else {
                log.debug((Object)"User session mapping not enabled for server.");
            }
        }
        this.userSessionMappingEnabled = userSessionMappingEnabled;
    }

    public Map<Integer, UserOperationEventListener> getUserOperationEventListeners() {
        return userOperationEventListeners;
    }

    public void setUserOperationEventListeners(Map<Integer, UserOperationEventListener> userOperationEventListeners) {
        IdentityMgtServiceDataHolder.userOperationEventListeners = userOperationEventListeners;
    }

    public void addUserOperationEventListener(UserOperationEventListener userOperationEventListener) {
        userOperationEventListeners.put(userOperationEventListener.getExecutionOrderId(), userOperationEventListener);
    }
}

