/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.authentication.framework.UserSessionManagementService;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.IdentityMgtConfig;
import org.wso2.carbon.identity.mgt.IdentityMgtConfigException;
import org.wso2.carbon.identity.mgt.IdentityMgtEventListener;
import org.wso2.carbon.identity.mgt.RecoveryProcessor;
import org.wso2.carbon.identity.mgt.config.Config;
import org.wso2.carbon.identity.mgt.config.ConfigBuilder;
import org.wso2.carbon.identity.mgt.config.EmailNotificationConfig;
import org.wso2.carbon.identity.mgt.config.StorageType;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtDeploymentInterceptor;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.mgt.listener.IdentityUserIdResolverListener;
import org.wso2.carbon.identity.mgt.listener.IdentityUserNameResolverListener;
import org.wso2.carbon.identity.mgt.listener.TenantManagementListener;
import org.wso2.carbon.identity.mgt.listener.UserOperationsNotificationListener;
import org.wso2.carbon.identity.mgt.listener.UserSessionTerminationListener;
import org.wso2.carbon.identity.mgt.store.RegistryCleanUpService;
import org.wso2.carbon.identity.mgt.util.UserIdentityManagementUtil;
import org.wso2.carbon.identity.notification.mgt.NotificationSender;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent", immediate=true)
public class IdentityMgtServiceComponent {
    private static final String DELAY_BETWEEN_RUNS = "TimeConfig.RegistryCleanUpPeriod";
    private static Log log = LogFactory.getLog(IdentityMgtServiceComponent.class);
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ConfigurationContextService configurationContextService;
    private static RecoveryProcessor recoveryProcessor;
    private static NotificationSender notificationSender;
    private static AttributeSearchService attributeSearchService;
    private static UserSessionManagementService userSessionManagementService;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        log.debug((Object)"Setting the Realm Service");
        IdentityMgtServiceComponent.realmService = realmService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        log.debug((Object)"Setting the Registry Service");
        IdentityMgtServiceComponent.registryService = registryService;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Setting theConfigurationContext Service");
        IdentityMgtServiceComponent.configurationContextService = configurationContextService;
    }

    public static RecoveryProcessor getRecoveryProcessor() {
        return recoveryProcessor;
    }

    private static void init() {
        IdentityMgtConfig.getInstance(realmService.getBootstrapRealmConfiguration());
        recoveryProcessor = new RecoveryProcessor();
        try {
            IdentityEventListenerConfig identityEventListenerConfig;
            UserRegistry registry = IdentityMgtServiceComponent.getRegistryService().getConfigSystemRegistry();
            if (!registry.resourceExists("/repository/components/org.wso2.carbon.identity.mgt")) {
                Collection questionCollection = registry.newCollection();
                registry.put("/repository/components/org.wso2.carbon.identity.mgt", (Resource)questionCollection);
                UserIdentityManagementUtil.loadDefaultChallenges();
            }
            if ((identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)UserOperationEventListener.class.getName(), (String)IdentityMgtEventListener.class.getName())) != null && Boolean.parseBoolean(identityEventListenerConfig.getEnable()) && !registry.resourceExists("identity/config/emailTemplate")) {
                Config emailConfigFile = ConfigBuilder.getInstance().loadEmailConfigFile();
                EmailNotificationConfig emailNotificationConfig = new EmailNotificationConfig();
                emailNotificationConfig.setProperties(emailConfigFile.getProperties());
                ConfigBuilder.getInstance().saveConfiguration(StorageType.REGISTRY, -1234, emailNotificationConfig);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating registry collection for org.wso2.carbon.identity.mgt component", (Throwable)e);
        }
        catch (IdentityMgtConfigException e) {
            log.error((Object)"Error occurred while saving default email templates in registry for super tenant");
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        ServiceRegistration identityUserNameResolverListener;
        ServiceRegistration identityUserIdResolverListener;
        ServiceRegistration serviceRegistration;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
        context.getBundleContext().registerService(AxisObserver.class.getName(), (Object)new IdentityMgtDeploymentInterceptor(), props);
        IdentityMgtServiceComponent.init();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management Listener is enabled");
        }
        if ((serviceRegistration = context.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new IdentityMgtEventListener(), null)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Management - UserOperationEventListener registered.");
            }
        } else {
            log.error((Object)"Identity Management - UserOperationEventListener could not be registered.");
        }
        UserOperationsNotificationListener notificationListener = new UserOperationsNotificationListener();
        ServiceRegistration userOperationNotificationSR = context.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)notificationListener, null);
        context.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)new TenantManagementListener(), null);
        context.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new UserSessionTerminationListener(), null);
        if (userOperationNotificationSR != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Management - UserOperationNotificationListener registered.");
            }
        } else {
            log.error((Object)"Identity Management - UserOperationNotificationListener could not be registered.");
        }
        if ((identityUserIdResolverListener = context.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new IdentityUserIdResolverListener(), null)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Management - IdentityUserIdResolverListener registered.");
            }
        } else {
            log.error((Object)"Identity Management - IdentityUserIdResolverListener could not be registered.");
        }
        if ((identityUserNameResolverListener = context.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new IdentityUserNameResolverListener(), null)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Management - IdentityUserNameResolverListener registered.");
            }
        } else {
            log.error((Object)"Identity Management - IdentityUserNameResolverListener could not be registered.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management bundle is activated");
        }
        RegistryCleanUpService registryCleanUpService = new RegistryCleanUpService(IdentityMgtConfig.getInstance().getRegistryCleanUpPeriod(), IdentityMgtConfig.getInstance().getRegistryCleanUpPeriod());
        registryCleanUpService.activateCleanUp();
        IdentityMgtServiceDataHolder.getInstance().setUserSessionMappingEnabled(FrameworkUtils.isUserSessionMappingEnabled());
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Identity Management bundle is de-activated");
    }

    protected void unsetRegistryService(RegistryService registryService) {
        log.debug((Object)"UnSetting the Registry Service");
        IdentityMgtServiceComponent.registryService = null;
    }

    protected void unsetRealmService(RealmService realmService) {
        log.debug((Object)"UnSetting the Realm Service");
        IdentityMgtServiceComponent.realmService = null;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"UnSetting the  ConfigurationContext Service");
        IdentityMgtServiceComponent.configurationContextService = null;
    }

    @Reference(name="carbon.identity.notification.mgt", service=NotificationSender.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetNotificationSender")
    protected void setNotificationSender(NotificationSender notificationSender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting notification sender in Entitlement bundle");
        }
        IdentityMgtServiceComponent.notificationSender = notificationSender;
    }

    protected void unsetNotificationSender(NotificationSender notificationSender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting notification sender in Entitlement bundle");
        }
        IdentityMgtServiceComponent.notificationSender = null;
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    public static NotificationSender getNotificationSender() {
        return notificationSender;
    }

    @Reference(name="registry.search.component", service=AttributeSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAttributeSearchService")
    protected void setAttributeSearchService(AttributeSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting Registry Attribute Search Service");
        }
        attributeSearchService = searchService;
    }

    protected void unsetAttributeSearchService(AttributeSearchService searchService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting Registry Attribute Search Service");
        }
        attributeSearchService = null;
    }

    public static AttributeSearchService getAttributeSearchService() {
        return attributeSearchService;
    }

    @Reference(name="userSessionManagementService", service=UserSessionManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserSessionManagementService")
    protected void setUserSessionManagementService(UserSessionManagementService sessionService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting Session Management Service");
        }
        userSessionManagementService = sessionService;
    }

    protected void unsetUserSessionManagementService(UserSessionManagementService sessionService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting Session Management Service");
        }
        userSessionManagementService = null;
    }

    public static UserSessionManagementService getUserSessionManagementService() {
        return userSessionManagementService;
    }

    @Reference(name="user.operation.event.listener.service", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserOperationEventListenerService")
    protected synchronized void setUserOperationEventListenerService(UserOperationEventListener userOperationEventListenerService) {
        IdentityMgtServiceDataHolder.getInstance().addUserOperationEventListener(userOperationEventListenerService);
    }

    protected synchronized void unsetUserOperationEventListenerService(UserOperationEventListener userOperationEventListenerService) {
        if (userOperationEventListenerService != null) {
            IdentityMgtServiceDataHolder.getInstance().getUserOperationEventListeners().remove(userOperationEventListenerService.getExecutionOrderId());
        }
    }
}

