/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.dto;

import java.util.HashMap;
import java.util.Map;

public class UserIdentityDTO {
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    private String userName;
    private long unlockTime;
    private long lastLogonTime;
    private long lastFailAttemptTime;
    private int failAttempts;
    private boolean accountLock;
    private boolean temporaryLock;
    private boolean passwordChangeRequired;
    private boolean oneTimeLogin;
    private Map<String, String> userDataMap = new HashMap<String, String>();
    private int tenantId;
    private Map<String, String> securityQuestions = new HashMap<String, String>();

    public UserIdentityDTO(String userName) {
        this.userName = userName;
    }

    public UserIdentityDTO(String userName, Map<String, String> userDataMap) {
        this.userName = userName;
        this.userDataMap = userDataMap;
        if (userDataMap.get("http://wso2.org/claims/identity/failedLoginAttempts") != null) {
            this.setFailAttempts(Integer.parseInt(userDataMap.get("http://wso2.org/claims/identity/failedLoginAttempts")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/lastFailedLoginAttemptTime") != null) {
            this.setLastFailAttemptTime(Long.parseLong(userDataMap.get("http://wso2.org/claims/identity/lastFailedLoginAttemptTime")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/temporaryLock") != null) {
            this.setTemporaryLock(Boolean.parseBoolean(userDataMap.get("http://wso2.org/claims/identity/temporaryLock")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/unlockTime") != null) {
            this.setUnlockTime(Long.parseLong(userDataMap.get("http://wso2.org/claims/identity/unlockTime")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/passwordChangeRequired") != null) {
            this.setPasswordChangeRequired(Boolean.parseBoolean(userDataMap.get("http://wso2.org/claims/identity/passwordChangeRequired")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/lastLogonTime") != null) {
            this.setLastLogonTime(Long.parseLong(userDataMap.get("http://wso2.org/claims/identity/lastLogonTime")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/accountLocked") != null) {
            this.setAccountLock(Boolean.parseBoolean(userDataMap.get("http://wso2.org/claims/identity/accountLocked")));
        }
    }

    public void setSecurityQuestion(String questionURI, String answer) {
        this.securityQuestions.put(questionURI, answer);
    }

    public Map<String, String> getSecurityQuestions() {
        return this.securityQuestions;
    }

    public void setSecurityQuestions(Map<String, String> securityQuestions) {
        this.securityQuestions = securityQuestions;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getUnlockTime() {
        return this.unlockTime;
    }

    public void setUnlockTime(long unlockTime) {
        this.unlockTime = unlockTime;
        this.userDataMap.put("http://wso2.org/claims/identity/unlockTime", Long.toString(unlockTime));
    }

    public long getLastLogonTime() {
        return this.lastLogonTime;
    }

    public void setLastLogonTime(long lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
        this.userDataMap.put("http://wso2.org/claims/identity/lastLogonTime", Long.toString(lastLogonTime));
    }

    public long getLastFailAttemptTime() {
        return this.lastFailAttemptTime;
    }

    public void setLastFailAttemptTime(long lastFailAttemptTime) {
        this.lastFailAttemptTime = lastFailAttemptTime;
        this.userDataMap.put("http://wso2.org/claims/identity/lastFailedLoginAttemptTime", Long.toString(lastFailAttemptTime));
    }

    public int getFailAttempts() {
        return this.failAttempts;
    }

    public void setFailAttempts(int failAttempts) {
        this.failAttempts = failAttempts;
        this.userDataMap.put("http://wso2.org/claims/identity/failedLoginAttempts", Integer.toString(failAttempts));
    }

    public void setFailAttempts() {
        ++this.failAttempts;
        this.userDataMap.put("http://wso2.org/claims/identity/failedLoginAttempts", Integer.toString(this.failAttempts));
    }

    public boolean getOneTimeLogin() {
        return this.oneTimeLogin;
    }

    public void setOneTimeLogin(boolean oneTimeLogin) {
        this.oneTimeLogin = oneTimeLogin;
        this.userDataMap.put("http://wso2.org/claims/identity/lastLogonTime", Boolean.toString(oneTimeLogin));
    }

    public boolean getPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
        this.userDataMap.put("http://wso2.org/claims/identity/passwordChangeRequired", Boolean.toString(passwordChangeRequired));
    }

    public boolean getTemporaryLock() {
        return this.temporaryLock;
    }

    public void setTemporaryLock(boolean temporaryLock) {
        this.temporaryLock = temporaryLock;
        this.userDataMap.put("http://wso2.org/claims/identity/temporaryLock", Boolean.toString(temporaryLock));
    }

    public boolean isAccountLocked() {
        if (this.unlockTime != 0L && this.unlockTime < System.currentTimeMillis()) {
            return false;
        }
        return this.accountLock;
    }

    public void setAccountLock(boolean accountLock) {
        this.accountLock = accountLock;
        this.userDataMap.put("http://wso2.org/claims/identity/accountLocked", Boolean.toString(accountLock));
    }

    public Map<String, String> getUserDataMap() {
        return this.userDataMap;
    }

    public void setUserDataMap(Map<String, String> userDataMap) {
        this.userDataMap = userDataMap;
    }

    public void setUserIdentityDataClaim(String claim, String value) {
        this.userDataMap.put(claim, value);
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public boolean getBoolean(Object value) {
        int IntegerValue = (Integer)value;
        return IntegerValue == 1;
    }
}

