/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.mgt.dto.UserIdentityClaimDTO;

public class UserIdentityClaimsDO
implements Serializable {
    private static final long serialVersionUID = -2450146518801449646L;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    private String userName;
    private int tenantId;
    private long unlockTime;
    private long lastLogonTime;
    private long lastFailAttemptTime;
    private int failedAttempts;
    private boolean accountLock;
    private boolean isAccountDisabled;
    private boolean passwordChangeRequired;
    private boolean oneTimeLogin;
    private Map<String, String> userIdentityDataMap = new HashMap<String, String>();
    private char[] temporaryPassword = null;
    private String confirmationCode = null;

    public UserIdentityClaimsDO(String userName) {
        this.userName = userName;
    }

    public UserIdentityClaimsDO(String userName, Map<String, String> userDataMap) {
        String lastLogonTime;
        String lastFailedAttemptTime;
        this.userName = userName;
        this.userIdentityDataMap = userDataMap;
        if (userDataMap.get("http://wso2.org/claims/identity/failedLoginAttempts") != null) {
            String failedAttemptsData = userDataMap.get("http://wso2.org/claims/identity/failedLoginAttempts").trim();
            if (!failedAttemptsData.isEmpty()) {
                this.setFailAttempts(Integer.parseInt(failedAttemptsData));
            } else {
                this.setFailAttempts(0);
            }
        }
        if (userDataMap.get("http://wso2.org/claims/identity/lastFailedLoginAttemptTime") != null && !(lastFailedAttemptTime = userDataMap.get("http://wso2.org/claims/identity/lastFailedLoginAttemptTime").trim()).isEmpty()) {
            this.setLastFailAttemptTime(Long.parseLong(lastFailedAttemptTime));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/unlockTime") != null) {
            String unlockTimeData = userDataMap.get("http://wso2.org/claims/identity/unlockTime").trim();
            if (!unlockTimeData.isEmpty()) {
                this.setUnlockTime(Long.parseLong(unlockTimeData));
            } else {
                this.setUnlockTime(0L);
            }
        }
        if (userDataMap.get("http://wso2.org/claims/identity/otp") != null) {
            String oneTimePassword = userDataMap.get("http://wso2.org/claims/identity/otp").trim();
            if (!oneTimePassword.isEmpty()) {
                this.setOneTimeLogin(Boolean.parseBoolean(oneTimePassword));
            } else {
                this.setOneTimeLogin(false);
            }
        }
        if (userDataMap.get("http://wso2.org/claims/identity/passwordChangeRequired") != null) {
            this.setPasswordChangeRequired(Boolean.parseBoolean(userDataMap.get("http://wso2.org/claims/identity/passwordChangeRequired")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/lastLogonTime") != null && !(lastLogonTime = userDataMap.get("http://wso2.org/claims/identity/lastLogonTime").trim()).isEmpty()) {
            this.setLastLogonTime(Long.parseLong(lastLogonTime));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/accountLocked") != null) {
            this.setAccountLock(Boolean.parseBoolean(userDataMap.get("http://wso2.org/claims/identity/accountLocked")));
        }
        if (userDataMap.get("http://wso2.org/claims/identity/accountDisabled") != null) {
            this.setAccountDisabled(Boolean.parseBoolean(userDataMap.get("http://wso2.org/claims/identity/accountDisabled")));
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getUnlockTime() {
        return this.unlockTime;
    }

    public void setUnlockTime(long unlockTime) {
        this.unlockTime = unlockTime;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/unlockTime", Long.toString(unlockTime));
    }

    public Map<String, String> getUserIdentityDataMap() {
        return this.userIdentityDataMap;
    }

    public long getLastLogonTime() {
        return this.lastLogonTime;
    }

    public void setLastLogonTime(long lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/lastLogonTime", Long.toString(lastLogonTime));
    }

    public long getLastFailAttemptTime() {
        return this.lastFailAttemptTime;
    }

    public void setLastFailAttemptTime(long lastFailAttemptTime) {
        this.lastFailAttemptTime = lastFailAttemptTime;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/lastFailedLoginAttemptTime", Long.toString(lastFailAttemptTime));
    }

    public int getFailAttempts() {
        return this.failedAttempts;
    }

    public void setFailAttempts(int failAttempts) {
        this.failedAttempts = failAttempts;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/failedLoginAttempts", Integer.toString(failAttempts));
    }

    public void setFailAttempts() {
        ++this.failedAttempts;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/failedLoginAttempts", Integer.toString(this.failedAttempts));
    }

    public boolean getOneTimeLogin() {
        return this.oneTimeLogin;
    }

    public void setOneTimeLogin(boolean oneTimeLogin) {
        this.oneTimeLogin = oneTimeLogin;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/otp", Boolean.toString(oneTimeLogin));
    }

    public boolean getPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/passwordChangeRequired", Boolean.toString(passwordChangeRequired));
    }

    public boolean isAccountLocked() {
        if (this.unlockTime != 0L && this.unlockTime < System.currentTimeMillis()) {
            return false;
        }
        return this.accountLock;
    }

    public boolean getAccountLock() {
        return this.accountLock;
    }

    public UserIdentityClaimsDO setAccountLock(boolean accountLock) {
        this.accountLock = accountLock;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/accountLocked", Boolean.toString(accountLock));
        return this;
    }

    public Map<String, String> getUserDataMap() {
        if (this.userIdentityDataMap == null) {
            return Collections.emptyMap();
        }
        return this.userIdentityDataMap;
    }

    public void setUserDataMap(Map<String, String> userDataMap) {
        this.userIdentityDataMap = userDataMap;
    }

    public void setUserIdentityDataClaim(String claim, String value) {
        this.userIdentityDataMap.put(claim, value);
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        if ("http://wso2.org/claims/identity/failedLoginAttempts".equalsIgnoreCase(claim)) {
            this.setFailAttempts(Integer.parseInt(value));
        } else if ("http://wso2.org/claims/identity/lastFailedLoginAttemptTime".equalsIgnoreCase(claim)) {
            this.setLastFailAttemptTime(Long.parseLong(value));
        } else if ("http://wso2.org/claims/identity/unlockTime".equalsIgnoreCase(claim)) {
            this.setUnlockTime(Long.parseLong(value));
        } else if ("http://wso2.org/claims/identity/otp".equalsIgnoreCase(claim)) {
            this.setOneTimeLogin(Boolean.parseBoolean(value));
        } else if ("http://wso2.org/claims/identity/passwordChangeRequired".equalsIgnoreCase(claim)) {
            this.setPasswordChangeRequired(Boolean.parseBoolean(value));
        } else if ("http://wso2.org/claims/identity/lastLogonTime".equalsIgnoreCase(claim)) {
            this.setLastLogonTime(Long.parseLong(value));
        } else if ("http://wso2.org/claims/identity/accountLocked".equalsIgnoreCase(claim)) {
            this.setAccountLock(Boolean.parseBoolean(value));
        } else if ("http://wso2.org/claims/identity/accountDisabled".equalsIgnoreCase(claim)) {
            this.setAccountDisabled(Boolean.parseBoolean(value));
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public boolean getBoolean(Object value) {
        int IntegerValue = (Integer)value;
        return IntegerValue == 1;
    }

    public char[] getTemporaryPassword() {
        return (char[])this.temporaryPassword.clone();
    }

    public void setTemporaryPassword(char[] temporaryPassword) {
        this.temporaryPassword = (char[])temporaryPassword.clone();
    }

    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    public void setConfirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
    }

    public Boolean getIsAccountDisabled() {
        return this.isAccountDisabled;
    }

    public void setAccountDisabled(boolean isAccountDisabled) {
        this.isAccountDisabled = isAccountDisabled;
        this.userIdentityDataMap.put("http://wso2.org/claims/identity/accountDisabled", Boolean.toString(isAccountDisabled));
    }

    public void updateUserSequeiryQuestions(UserIdentityClaimDTO[] securityQuestions) {
        for (UserIdentityClaimDTO dto : securityQuestions) {
            if (dto.getClaimUri() == null || dto.getClaimValue() == null || !dto.getClaimUri().contains("http://wso2.org/claims/identity/challengeQuestion")) continue;
            this.userIdentityDataMap.put(dto.getClaimUri(), dto.getClaimValue());
        }
    }

    public UserIdentityClaimDTO[] getUserSequeiryQuestions() {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.userIdentityDataMap.entrySet()) {
            if (!entry.getKey().contains("http://wso2.org/claims/identity/challengeQuestion")) continue;
            tempMap.put(entry.getKey(), entry.getValue());
        }
        if (tempMap.isEmpty()) {
            return new UserIdentityClaimDTO[0];
        }
        UserIdentityClaimDTO[] securityQuestions = new UserIdentityClaimDTO[tempMap.size()];
        int i = 0;
        for (Map.Entry entry : tempMap.entrySet()) {
            UserIdentityClaimDTO dto = new UserIdentityClaimDTO();
            dto.setClaimUri((String)entry.getKey());
            dto.setClaimValue((String)entry.getValue());
            securityQuestions[i] = dto;
            ++i;
        }
        return securityQuestions;
    }

    public void updateUserIdentityRecoveryData(UserIdentityClaimDTO[] userIdentityRecoveryData) {
        for (UserIdentityClaimDTO dto : userIdentityRecoveryData) {
            if (dto.getClaimUri() == null || dto.getClaimValue() == null || dto.getClaimUri().contains("http://wso2.org/claims/identity/challengeQuestion") || dto.getClaimUri().contains("http://wso2.org/claims/identity")) continue;
            this.userIdentityDataMap.put(dto.getClaimUri(), dto.getClaimValue());
        }
    }

    public UserIdentityClaimDTO[] getUserIdentityRecoveryData() {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.userIdentityDataMap.entrySet()) {
            if (entry.getKey().contains("http://wso2.org/claims/identity/challengeQuestion") || entry.getKey().contains("http://wso2.org/claims/identity")) continue;
            tempMap.put(entry.getKey(), entry.getValue());
        }
        if (tempMap.isEmpty()) {
            return new UserIdentityClaimDTO[0];
        }
        UserIdentityClaimDTO[] identityRecoveryData = new UserIdentityClaimDTO[tempMap.size()];
        int i = 0;
        for (Map.Entry entry : tempMap.entrySet()) {
            UserIdentityClaimDTO dto = new UserIdentityClaimDTO();
            dto.setClaimUri((String)entry.getKey());
            dto.setClaimValue((String)entry.getValue());
            identityRecoveryData[i] = dto;
            ++i;
        }
        return identityRecoveryData;
    }
}

