/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.config;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.IdentityMgtConfigException;
import org.wso2.carbon.identity.mgt.config.ConfigWriter;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryConfigWriter
implements ConfigWriter {
    private static final Log log = LogFactory.getLog(RegistryConfigWriter.class);

    @Override
    public void write(int tenantId, Properties props, String resourcePath) throws IdentityMgtConfigException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing data to registry path : " + resourcePath));
        }
        RegistryService registry = IdentityMgtServiceComponent.getRegistryService();
        try {
            UserRegistry userReg = registry.getConfigSystemRegistry(tenantId);
            Resource resource = userReg.newResource();
            Set<String> names = props.stringPropertyNames();
            for (String keyName : names) {
                ArrayList<String> value = new ArrayList<String>();
                String valueStr = props.getProperty(keyName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Write key : " + keyName + " value : " + value));
                }
                value.add(valueStr);
                resource.setProperty(keyName, value);
            }
            userReg.put(resourcePath, resource);
        }
        catch (RegistryException e) {
            throw new IdentityMgtConfigException("Error occurred while writing data to registry path : " + resourcePath, e);
        }
    }
}

