/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.IdentityMgtConfigException;
import org.wso2.carbon.identity.mgt.config.ConfigReader;
import org.wso2.carbon.identity.mgt.internal.IdentityMgtServiceComponent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryConfigReader
implements ConfigReader {
    private static Log log = LogFactory.getLog(RegistryConfigReader.class);

    @Override
    public Properties read(int tenantId, String resourcePath) throws IdentityMgtConfigException {
        Resource resource = null;
        Properties readerProps = null;
        RegistryService registry = IdentityMgtServiceComponent.getRegistryService();
        try {
            UserRegistry userReg = registry.getConfigSystemRegistry(tenantId);
            resource = userReg.get(resourcePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading data from registry path : " + resourcePath));
            }
            Properties props = resource.getProperties();
            readerProps = new Properties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                List listValue = (List)entry.getValue();
                String value = (String)listValue.get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read key : " + key + " value : " + value));
                }
                readerProps.put(key, value);
            }
        }
        catch (ResourceNotFoundException e) {
            readerProps = new Properties();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignored ResourceNotFoundException", (Throwable)e);
            }
        }
        catch (RegistryException e) {
            throw new IdentityMgtConfigException("Error occurred while reading registry data from path : " + resourcePath, e);
        }
        return readerProps;
    }
}

