/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.config;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.dto.EmailTemplateDTO;

public class EmailConfigTransformer {
    private static final Log log = LogFactory.getLog(EmailConfigTransformer.class);

    private EmailConfigTransformer() {
    }

    public static EmailTemplateDTO[] transform(Properties props) throws IdentityException {
        ArrayList<EmailTemplateDTO> emailTemplates = new ArrayList<EmailTemplateDTO>();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Transforming Properties to EmailTemplateDTO[]");
        }
        Set<String> keySet = props.stringPropertyNames();
        for (String key : keySet) {
            EmailTemplateDTO template = new EmailTemplateDTO();
            if ("passwordReset".equals(key)) {
                template.setDisplayName("Password Reset");
            } else if ("accountConfirmation".equals(key)) {
                template.setDisplayName("Account Confirm");
            } else if ("accountIdRecovery".equals(key)) {
                template.setDisplayName("Account Id Recovery");
            } else if ("accountUnLock".equals(key)) {
                template.setDisplayName("Account Unlock");
            } else if ("accountEnable".equals(key)) {
                template.setDisplayName("Account Enable");
            } else if ("accountDisable".equals(key)) {
                template.setDisplayName("Account Disable");
            } else if ("askPassword".equals(key)) {
                template.setDisplayName("Ask Password");
            } else if ("otp".equals(key)) {
                template.setDisplayName("One Time Password");
            } else if ("temporaryPassword".equals(key)) {
                template.setDisplayName("Temporary Password");
            } else if ("passwordExpires".equals(key)) {
                template.setDisplayName("Password Expires");
            } else if ("passwordExpired".equals(key)) {
                template.setDisplayName("Password Expired");
            } else {
                if (!"resendNotification".equals(key)) continue;
                template.setDisplayName("Resend Notification");
            }
            template.setName(key);
            String[] contents = props.getProperty(key).split("\\|");
            if (contents.length > 3) {
                throw IdentityException.error((String)"Cannot have | character in the template");
            }
            String subject = contents[0];
            String body = contents[1];
            String footer = contents[2];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Template info - name:" + key + " subject:" + subject + " body:" + body + " footer:" + footer));
            }
            template.setSubject(subject);
            template.setBody(body);
            template.setFooter(footer);
            emailTemplates.add(template);
        }
        return emailTemplates.toArray(new EmailTemplateDTO[emailTemplates.size()]);
    }

    public static Properties transform(EmailTemplateDTO[] templates) throws IdentityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Transforming EmailTemplateDTO[] to Properties");
        }
        Properties props = new Properties();
        for (EmailTemplateDTO template : templates) {
            StringBuilder contents = new StringBuilder();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Properties info - subject:" + template.getSubject() + " body:" + template.getBody() + " footer:" + template.getFooter()));
            }
            contents.append(template.getSubject()).append("|").append(template.getBody()).append("|").append(template.getFooter());
            props.setProperty(template.getName(), contents.toString());
        }
        return props;
    }
}

